/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.wicket;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.protocol.http.WebApplication;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Steps;
import org.jbehave.web.io.ArchivingFileManager;
import org.jbehave.web.io.FileArchiver;
import org.jbehave.web.io.FileManager;
import org.jbehave.web.io.FileMonitor;
import org.jbehave.web.io.SilentFileMonitor;
import org.jbehave.web.io.ZipFileArchiver;
import org.jbehave.web.runner.wicket.pages.DataFiles;
import org.jbehave.web.runner.wicket.pages.FindSteps;
import org.jbehave.web.runner.wicket.pages.Home;
import org.jbehave.web.runner.wicket.pages.RunStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRunnerApplication
extends WebApplication {
    protected void init() {
        super.init();
        this.addComponentInstantiationListener((IComponentInstantiationListener)new GuiceComponentInjector((Application)this, this.modules()));
        this.mountBookmarkablePage("/home", Home.class);
        this.mountBookmarkablePage("/data/files", DataFiles.class);
        this.mountBookmarkablePage("/steps/find", FindSteps.class);
        this.mountBookmarkablePage("/story/run", RunStory.class);
    }

    private Module[] modules() {
        return new Module[]{new ApplicationModule()};
    }

    protected Configuration configuration() {
        return new MostUsefulConfiguration();
    }

    protected StoryRunner storyRunner() {
        return new StoryRunner();
    }

    protected List<CandidateSteps> candidateSteps() {
        return Arrays.asList(new Steps());
    }

    protected FileMonitor fileMonitor() {
        return new SilentFileMonitor();
    }

    protected File uploadDirectory() {
        return new File("/tmp", "upload");
    }

    protected ZipFileArchiver fileArchiver() {
        return new ZipFileArchiver();
    }

    protected FileManager fileManager() {
        return new ArchivingFileManager((FileArchiver)this.fileArchiver(), this.fileMonitor(), this.uploadDirectory());
    }

    public Class<Home> getHomePage() {
        return Home.class;
    }

    protected class ApplicationModule
    extends AbstractModule {
        protected ApplicationModule() {
        }

        protected void configure() {
            this.bind(Configuration.class).toInstance((Object)WebRunnerApplication.this.configuration());
            this.bind(StoryRunner.class).toInstance((Object)WebRunnerApplication.this.storyRunner());
            this.bind((TypeLiteral)new TypeLiteral<List<CandidateSteps>>(){}).toInstance(WebRunnerApplication.this.candidateSteps());
            this.bind(FileManager.class).toInstance((Object)WebRunnerApplication.this.fileManager());
        }
    }
}

