/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.context;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.failures.BatchFailures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryContext
implements Serializable {
    private static final String EMPTY = "";
    private String input = "";
    private String metaFilter = "";
    private String output = "";
    private List<String> messages = new ArrayList<String>();
    private Throwable cause = null;
    private BatchFailures batchFailures = new BatchFailures();
    private List<Future<Embedder.ThrowableStory>> futures = new ArrayList<Future<Embedder.ThrowableStory>>();

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getMetaFilter() {
        return this.metaFilter;
    }

    public void setMetaFilter(String metaFilter) {
        this.metaFilter = metaFilter;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public BatchFailures getBatchFailures() {
        return this.batchFailures;
    }

    public void setBatchFailures(BatchFailures batchFailures) {
        this.batchFailures = batchFailures;
    }

    public List<Future<Embedder.ThrowableStory>> getFutures() {
        return this.futures;
    }

    public void setFutures(List<Future<Embedder.ThrowableStory>> futures) {
        this.futures = futures;
    }

    public List<String> getFailureMessages() {
        this.messages.clear();
        this.addFailureMessage(this.cause);
        return this.messages;
    }

    private void addFailureMessage(Throwable cause) {
        if (cause != null) {
            if (cause.getMessage() != null) {
                this.messages.add(cause.getMessage());
            }
            this.addFailureMessage(cause.getCause());
        }
    }

    public void clearFailureCause() {
        this.cause = null;
    }

    public void runFailedFor(Throwable cause) {
        this.cause = cause;
    }

    public String getFailureStackTrace() {
        StringWriter writer = new StringWriter();
        if (this.cause != null) {
            this.cause.printStackTrace(new PrintWriter(writer));
        }
        return writer.getBuffer().toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

