/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbehave.core.steps.StepType;
import org.jbehave.core.steps.Stepdoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepdocContext
implements Serializable {
    private List<SerializableStepdoc> allStepdocs = new ArrayList<SerializableStepdoc>();
    private List<SerializableStepdoc> stepdocs = new ArrayList<SerializableStepdoc>();
    private List<Class<?>> stepsClasses = new ArrayList();
    private View view = View.PATTERNS;
    private Sorting sorting = Sorting.BY_POSITION;
    private String matchingStep = "";

    public List<SerializableStepdoc> getAllStepdocs() {
        return this.allStepdocs;
    }

    public void setAllStepdocs(List<Stepdoc> stepdocs) {
        this.allStepdocs = this.serializableStepdocs(stepdocs);
    }

    public List<SerializableStepdoc> getStepdocs() {
        return this.stepdocs;
    }

    public void addAllStepdocs() {
        this.stepdocs.addAll(this.allStepdocs);
    }

    public void addStepdocs(List<Stepdoc> stepdocs) {
        this.stepdocs.addAll(this.serializableStepdocs(stepdocs));
    }

    public void clearStepdocs() {
        this.stepdocs.clear();
    }

    public void sortStepdocs() {
        ArrayList<SerializableStepdoc> sorted = new ArrayList<SerializableStepdoc>(this.stepdocs);
        Collections.sort(sorted);
        this.stepdocs = sorted;
    }

    public void setStepsInstances(List<Object> stepsInstances) {
        this.stepsClasses = this.stepsClasses(stepsInstances);
    }

    public List<Class<?>> getStepsClasses() {
        return this.stepsClasses;
    }

    public List<View> getViews() {
        return Arrays.asList(View.values());
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public List<Sorting> getSortings() {
        return Arrays.asList(Sorting.values());
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public void setSorting(Sorting sorting) {
        this.sorting = sorting;
    }

    public String getMatchingStep() {
        return this.matchingStep;
    }

    public void setMatchingStep(String matchingStep) {
        this.matchingStep = matchingStep;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private List<Class<?>> stepsClasses(List<Object> stepsInstances) {
        ArrayList classes = new ArrayList();
        for (Object instance : stepsInstances) {
            classes.add(instance.getClass());
        }
        return classes;
    }

    private List<SerializableStepdoc> serializableStepdocs(List<Stepdoc> stepdocs) {
        ArrayList<SerializableStepdoc> serializables = new ArrayList<SerializableStepdoc>();
        for (Stepdoc stepdoc : stepdocs) {
            serializables.add(new SerializableStepdoc(stepdoc));
        }
        return serializables;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializableStepdoc
    implements Serializable,
    Comparable<SerializableStepdoc> {
        private StepType stepType;
        private String startingWord;
        private String pattern;
        private String methodSignature;
        private Class<?> stepsClass;

        public SerializableStepdoc(Stepdoc stepdoc) {
            this.stepType = stepdoc.getStepType();
            this.startingWord = stepdoc.getStartingWord();
            this.pattern = stepdoc.getPattern();
            this.methodSignature = stepdoc.getMethodSignature();
            this.stepsClass = stepdoc.getStepsInstance().getClass();
        }

        public StepType getStepType() {
            return this.stepType;
        }

        public String getStartingWord() {
            return this.startingWord;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Class<?> getStepsClass() {
            return this.stepsClass;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this).toString();
        }

        @Override
        public int compareTo(SerializableStepdoc that) {
            return CompareToBuilder.reflectionCompare((Object)this, (Object)that);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sorting {
        BY_POSITION,
        BY_PATTERN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        PATTERNS,
        WITH_METHODS;

    }
}

