/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.waffle.controllers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.codehaus.waffle.action.annotation.ActionMethod;
import org.codehaus.waffle.action.annotation.PRG;
import org.codehaus.waffle.menu.Menu;
import org.codehaus.waffle.menu.MenuAwareController;
import org.jbehave.scenario.Configuration;
import org.jbehave.scenario.PropertyBasedConfiguration;
import org.jbehave.scenario.ScenarioRunner;
import org.jbehave.scenario.definition.StoryDefinition;
import org.jbehave.scenario.parser.ScenarioParser;
import org.jbehave.scenario.reporters.PrintStreamScenarioReporter;
import org.jbehave.scenario.reporters.ScenarioReporter;
import org.jbehave.scenario.steps.CandidateSteps;
import org.jbehave.web.runner.waffle.controllers.ScenarioContext;

public class ScenarioController
extends MenuAwareController {
    private final ScenarioParser scenarioParser;
    private final ScenarioRunner scenarioRunner;
    private final CandidateSteps[] steps;
    private ByteArrayOutputStream outputStream;
    private Configuration configuration;
    private ScenarioContext scenarioContext;

    public ScenarioController(Menu menu, Configuration configuration, ScenarioParser scenarioParser, ScenarioRunner scenarioRunner, CandidateSteps ... steps) {
        super(menu);
        this.scenarioParser = scenarioParser;
        this.scenarioRunner = scenarioRunner;
        this.steps = steps;
        this.outputStream = new ByteArrayOutputStream();
        this.configuration = new PropertyBasedConfiguration(configuration){

            public ScenarioReporter forReportingScenarios() {
                return new PrintStreamScenarioReporter(new PrintStream(ScenarioController.this.outputStream));
            }
        };
        this.scenarioContext = new ScenarioContext();
    }

    @ActionMethod(asDefault=true)
    public void show() {
    }

    @ActionMethod(asDefault=false)
    @PRG(value=false)
    public void run() {
        if (StringUtils.isNotBlank((String)this.scenarioContext.getInput())) {
            try {
                this.outputStream.reset();
                this.scenarioContext.clearFailureCause();
                this.scenarioRunner.run(this.storyDefinition(), this.configuration, this.steps);
            }
            catch (Throwable e) {
                this.scenarioContext.runFailedFor(e);
            }
            this.scenarioContext.setOutput(this.outputStream.toString());
        }
    }

    private StoryDefinition storyDefinition() {
        return this.scenarioParser.defineStoryFrom(this.scenarioContext.getInput());
    }

    public ScenarioContext getScenarioContext() {
        return this.scenarioContext;
    }

    public void setScenarioContext(ScenarioContext scenarioContext) {
        this.scenarioContext = scenarioContext;
    }
}

