/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.waffle.controllers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.waffle.action.annotation.ActionMethod;
import org.codehaus.waffle.action.annotation.PRG;
import org.codehaus.waffle.io.FileUploader;
import org.codehaus.waffle.menu.Menu;
import org.codehaus.waffle.menu.MenuAwareController;
import org.jbehave.web.io.FileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadController
extends MenuAwareController {
    private final FileUploader uploader;
    private final FileManager manager;
    private List<String> errors = new ArrayList<String>();
    private List<File> uploadedFiles = new ArrayList<File>();
    private int filesToUpload = 1;

    public FileUploadController(Menu menu, FileUploader uploader, FileManager manager) {
        super(menu);
        this.uploader = uploader;
        this.manager = manager;
    }

    @ActionMethod(asDefault=true)
    @PRG(value=false)
    public void upload() {
        this.errors.clear();
        this.uploadedFiles.clear();
        List files = this.uploader.getFiles();
        this.errors.addAll(this.uploader.getErrors());
        this.uploadedFiles.addAll(this.manager.write(files, this.errors));
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    public List<File> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public int getFilesToUpload() {
        return this.filesToUpload;
    }
}

