/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jbehave.web.io.FileArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileArchiver
implements FileArchiver {
    private static final String UNIX_SEPARATOR = "/";
    private static final String ARCHIVER_NAME = "zip";
    private ArchiveStreamFactory factory = new ArchiveStreamFactory();

    @Override
    public boolean isArchive(File file) {
        return this.fileExtension(file).equalsIgnoreCase(ARCHIVER_NAME);
    }

    private String fileExtension(File file) {
        return StringUtils.substringAfterLast((String)file.getName(), (String)".");
    }

    @Override
    public void archive(File archive, File directory) {
        try {
            ArchiveOutputStream out = this.factory.createArchiveOutputStream(ARCHIVER_NAME, (OutputStream)new FileOutputStream(archive));
            List<File> files = this.listContent(directory);
            for (File file : files) {
                if (file.isDirectory()) continue;
                ZipArchiveEntry entry = new ZipArchiveEntry(this.relativeTo(file, directory).getPath());
                this.zipEntry(entry, out, file);
            }
            out.close();
        }
        catch (Exception e) {
            throw new FileArchiveFailedException(archive, directory, e);
        }
    }

    @Override
    public File relativeTo(File file, File directory) {
        String filePath = FilenameUtils.separatorsToUnix((String)file.getPath());
        String directoryPath = FilenameUtils.separatorsToUnix((String)directory.getPath());
        if (!directoryPath.endsWith(UNIX_SEPARATOR)) {
            directoryPath = directoryPath + UNIX_SEPARATOR;
        }
        return new File(StringUtils.remove((String)filePath, (String)directoryPath));
    }

    private void zipEntry(ZipArchiveEntry entry, ArchiveOutputStream out, File file) throws IOException, FileNotFoundException {
        out.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)out);
        out.closeArchiveEntry();
    }

    @Override
    public File directoryOf(File archive) {
        return new File(this.pathWithoutExtension(archive));
    }

    private String pathWithoutExtension(File file) {
        return StringUtils.substringBeforeLast((String)file.getPath(), (String)".");
    }

    @Override
    public void unarchive(File archive, File directory) {
        FileInputStream is = null;
        ArchiveInputStream in = null;
        try {
            is = new FileInputStream(archive);
            in = this.factory.createArchiveInputStream(ARCHIVER_NAME, (InputStream)is);
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)in.getNextEntry()) != null) {
                this.unzipEntry(entry, (InputStream)in, directory);
            }
            this.close(is);
            this.close((InputStream)in);
        }
        catch (Exception e) {
            try {
                throw new FileUnarchiveFailedException(archive, directory, e);
            }
            catch (Throwable throwable) {
                this.close(is);
                this.close((InputStream)in);
                throw throwable;
            }
        }
    }

    private void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<File> listContent(File file) {
        ArrayList<File> content = new ArrayList<File>();
        content.add(file);
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                content.addAll(this.listContent(child));
            }
        }
        return content;
    }

    private void unzipEntry(ZipArchiveEntry entry, InputStream in, File directory) throws IOException {
        if (entry.isDirectory()) {
            this.createDir(new File(directory, entry.getName()));
            return;
        }
        File outputFile = new File(directory, entry.getName());
        this.createDir(outputFile.getParentFile());
        this.copy(entry, in, outputFile);
    }

    private void createDir(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Failed to create dir " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(ZipArchiveEntry entry, InputStream in, File outputFile) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static final class FileUnarchiveFailedException
    extends RuntimeException {
        public FileUnarchiveFailedException(File archive, File directory, Exception cause) {
            super("Failed to unarchive " + archive + " to dir " + directory, cause);
        }
    }

    public static final class FileArchiveFailedException
    extends RuntimeException {
        public FileArchiveFailedException(File archive, File directory, Exception cause) {
            super("Failed to archive dir " + directory + " to " + archive, cause);
        }
    }
}

