/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ResourceFinder {
    public static final String DEFAULT_ROOT_DIRECTORY = "";
    public static final String DEFAULT_CLASSPATH_PREFIX = "classpath:";
    private final ClassLoader classLoader;
    private final String classpathPrefix;
    private String rootDirectory;

    public ResourceFinder() {
        this(DEFAULT_ROOT_DIRECTORY);
    }

    public ResourceFinder(String rootDirectory) {
        this(Thread.currentThread().getContextClassLoader(), rootDirectory, DEFAULT_CLASSPATH_PREFIX);
    }

    public ResourceFinder(ClassLoader classLoader, String rootDirectory) {
        this(classLoader, rootDirectory, DEFAULT_CLASSPATH_PREFIX);
    }

    public ResourceFinder(ClassLoader classLoader, String rootDirectory, String classpathPrefix) {
        this.classLoader = classLoader;
        this.classpathPrefix = classpathPrefix;
        this.rootDirectory = rootDirectory;
    }

    public String resourceAsString(String relativePath) {
        String resourcePath = this.resolvePath(relativePath);
        try {
            try {
                return this.classpathResource(resourcePath);
            }
            catch (ResourceNotFoundException e) {
                return this.filesystemResource(resourcePath);
            }
        }
        catch (IOException e) {
            throw new ResourceRetrievalFailedException(resourcePath);
        }
    }

    public void useRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    private String classpathResource(String resourcePath) throws IOException {
        InputStream inputStream = this.classLoader.getResourceAsStream(resourcePath);
        if (inputStream != null) {
            return IOUtils.toString((InputStream)inputStream);
        }
        throw new ResourceNotFoundException(resourcePath, this.classLoader);
    }

    private String filesystemResource(String resourcePath) throws IOException {
        File file = new File(resourcePath);
        if (file.exists()) {
            return FileUtils.readFileToString((File)file);
        }
        throw new ResourceNotFoundException(resourcePath);
    }

    private String resolvePath(String relativePath) {
        String resourcePath = this.rootDirectory.startsWith(this.classpathPrefix) ? this.resourcePath(this.stripPrefix(this.rootDirectory, this.classpathPrefix), relativePath) : this.resourcePath(this.rootDirectory, relativePath);
        return resourcePath;
    }

    private String resourcePath(String rootDirectory, String relativePath) {
        if (StringUtils.isBlank((String)rootDirectory)) {
            return relativePath;
        }
        return rootDirectory + "/" + relativePath;
    }

    private String stripPrefix(String path, String prefix) {
        return path.substring(prefix.length());
    }

    public static class ResourceRetrievalFailedException
    extends RuntimeException {
        public ResourceRetrievalFailedException(String resourcePath) {
            super("Failed to retrieve resource " + resourcePath);
        }
    }

    public static class ResourceNotFoundException
    extends RuntimeException {
        public ResourceNotFoundException(String resourcePath) {
            super("Resource " + resourcePath + " not found");
        }

        public ResourceNotFoundException(String resourcePath, ClassLoader classLoader) {
            super("Resource " + resourcePath + " not found in classLoader " + classLoader);
        }
    }
}

