/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.jbehave.web.io.FileMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStreamFileMonitor
implements FileMonitor {
    private final PrintStream output;

    public PrintStreamFileMonitor() {
        this(System.out);
    }

    public PrintStreamFileMonitor(PrintStream output) {
        this.output = output;
    }

    protected void print(PrintStream output, String message) {
        this.print(output, message, null);
    }

    protected void print(PrintStream output, String message, Exception cause) {
        output.println(message);
        if (cause != null) {
            cause.printStackTrace(output);
        }
    }

    @Override
    public void contentListed(String path, File directory, boolean relativePaths, List<File> content) {
        this.print(this.output, "Listed content of path " + path + " from directory " + directory + " using " + (relativePaths ? "relative" : "full") + " paths: " + content);
    }

    @Override
    public void fileDeleted(File file) {
        this.print(this.output, "Deleted file " + file);
    }

    @Override
    public void fileUnarchived(File file, File directory) {
        this.print(this.output, "Unarchived file " + file + " to directory " + directory);
    }

    @Override
    public void fileUploaded(File file) {
        this.print(this.output, "Uploaded file " + file);
    }

    @Override
    public void fileUploadFailed(FileItem item, Exception cause) {
        this.print(this.output, "File upload of " + item + " failed: ", cause);
    }

    @Override
    public void filesListed(File uploadDirectory, List<File> files) {
        this.print(this.output, "Listed files from upload directory " + uploadDirectory + ": " + files);
    }
}

