/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jbehave.web.io.FileArchiver;
import org.jbehave.web.io.FileManager;
import org.jbehave.web.io.FileMonitor;
import org.jbehave.web.io.ZipFileArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivingFileManager
implements FileManager {
    final FileArchiver archiver;
    final FileMonitor monitor;
    private final File uploadDirectory;

    public ArchivingFileManager(FileArchiver archiver, FileMonitor monitor, File uploadDirectory) {
        this.archiver = archiver;
        this.monitor = monitor;
        this.uploadDirectory = uploadDirectory;
    }

    @Override
    public List<File> list() {
        File directory = this.uploadDirectory();
        List<File> files = Arrays.asList(directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        }));
        this.monitor.filesListed(directory, files);
        return files;
    }

    File uploadDirectory() {
        this.uploadDirectory.mkdirs();
        return this.uploadDirectory;
    }

    @Override
    public List<File> listContent(File file, boolean relativePaths) {
        if (!this.archiver.isArchive(file)) {
            return Arrays.asList(file);
        }
        File directory = new File(this.uploadDirectory, this.archiver.directoryOf(new File(file.getName())).getPath());
        ArrayList<File> content = new ArrayList<File>();
        for (File archiveFile : this.archiver.listContent(directory)) {
            File contentFile = relativePaths ? this.archiver.relativeTo(archiveFile, directory) : archiveFile;
            content.add(contentFile);
        }
        this.monitor.contentListed(file.getPath(), directory, relativePaths, content);
        return content;
    }

    @Override
    public void delete(List<File> files) {
        for (File file : files) {
            this.deleteFile(file);
        }
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            for (String child : file.list()) {
                this.deleteFile(new File(file, child));
            }
        }
        if (this.archiver.isArchive(file)) {
            File directory = this.archiver.directoryOf(file);
            this.deleteFile(directory);
            this.monitor.fileDeleted(directory);
        }
        file.delete();
        this.monitor.fileDeleted(file);
    }

    @Override
    public List<File> upload(List<FileItem> fileItems, List<String> errors) {
        ArrayList<File> files = new ArrayList<File>();
        File directory = this.uploadDirectory();
        for (FileItem item : fileItems) {
            try {
                File file = this.writeItemToFile(directory, item);
                this.monitor.fileUploaded(file);
                files.add(file);
            }
            catch (FileItemNameMissingException e) {
            }
            catch (FileWriteFailedException e) {
                errors.add(e.getMessage());
                if (e.getCause() != null) {
                    errors.add(e.getCause().getMessage());
                }
                this.monitor.fileUploadFailed(item, e);
            }
        }
        return files;
    }

    @Override
    public void unarchiveFiles(List<File> files, List<String> errors) {
        File directory = this.uploadDirectory();
        for (File file : files) {
            if (!this.archiver.isArchive(file)) continue;
            try {
                this.archiver.unarchive(file, directory);
                this.monitor.fileUnarchived(file, directory);
            }
            catch (ZipFileArchiver.FileUnarchiveFailedException e) {
                errors.add(e.getMessage());
                if (e.getCause() == null) continue;
                errors.add(e.getCause().getMessage());
            }
        }
    }

    private File writeItemToFile(File directory, FileItem item) {
        if (StringUtils.isBlank((String)item.getName())) {
            throw new FileItemNameMissingException(item);
        }
        File file = new File(directory, this.fileName(item));
        try {
            if (file.exists()) {
                file.createNewFile();
            }
            item.write(file);
        }
        catch (Exception e) {
            throw new FileWriteFailedException(file, (Throwable)e);
        }
        return file;
    }

    private String fileName(FileItem item) {
        return FilenameUtils.getName((String)item.getName());
    }

    @Override
    public File getUploadDirectory() {
        return this.uploadDirectory;
    }

    public static final class FileWriteFailedException
    extends RuntimeException {
        public FileWriteFailedException(File file, Throwable cause) {
            super(file.toString() + " write failed", cause);
        }
    }

    public static final class FileItemNameMissingException
    extends RuntimeException {
        public FileItemNameMissingException(FileItem file) {
            super(file.toString() + " missing name");
        }
    }
}

