/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jbehave.web.io.FileArchiver;

public class ZipFileArchiver
implements FileArchiver {
    private static final String ZIP = ".zip";

    public boolean isArchive(File file) {
        return file.getName().endsWith(ZIP);
    }

    public File unarchivedDir(File file) {
        return new File(StringUtils.removeEnd((String)file.getPath(), (String)ZIP));
    }

    public void unarchive(File archive, File outputDir) {
        try {
            ZipFile zipfile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                this.unzipEntry(zipfile, entry, outputDir);
            }
        }
        catch (Exception e) {
            throw new FileUnarchiveFailedException(archive, outputDir, e);
        }
    }

    private void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            this.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            this.createDir(outputFile.getParentFile());
        }
        InputStream in = zipfile.getInputStream(entry);
        this.copy(in, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream inputStream, File outputFile) throws IOException {
        BufferedInputStream in = new BufferedInputStream(inputStream);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
    }

    private void createDir(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Failed to create dir " + dir);
        }
    }

    public static final class FileUnarchiveFailedException
    extends RuntimeException {
        public FileUnarchiveFailedException(File archive, File outputDir, Exception cause) {
            super(archive.toString() + File.pathSeparator + outputDir.toString(), cause);
        }
    }
}

