/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.jbehave.web.io.FileArchiver;
import org.jbehave.web.io.FileManager;
import org.jbehave.web.io.ZipFileArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivingFileManager
implements FileManager {
    private final FileArchiver archiver;
    private final File uploadDirectory;

    public ArchivingFileManager(FileArchiver archiver, File uploadDirectory) {
        this.archiver = archiver;
        this.uploadDirectory = uploadDirectory;
    }

    @Override
    public List<File> list() {
        return Arrays.asList(this.uploadDirectory().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        }));
    }

    private File uploadDirectory() {
        this.uploadDirectory.mkdirs();
        return this.uploadDirectory;
    }

    @Override
    public void delete(List<String> paths) {
        for (String path : paths) {
            this.deleteFile(new File(path));
        }
    }

    private void deleteFile(File file) {
        if (file.isDirectory()) {
            for (String child : file.list()) {
                this.deleteFile(new File(file, child));
            }
        }
        if (this.archiver.isArchive(file)) {
            this.deleteFile(this.archiver.unarchivedDir(file));
        }
        file.delete();
    }

    @Override
    public List<File> write(List<FileItem> fileItems, List<String> errors) {
        ArrayList<File> files = new ArrayList<File>();
        File directory = this.uploadDirectory();
        for (FileItem item : fileItems) {
            try {
                File file = this.writeItemToFile(directory, item);
                files.add(file);
                if (!this.archiver.isArchive(file)) continue;
                try {
                    this.archiver.unarchive(file, directory);
                }
                catch (ZipFileArchiver.FileUnarchiveFailedException e) {
                    errors.add(e.getMessage());
                }
            }
            catch (FileItemNameMissingException e) {
            }
            catch (FileWriteFailedException e) {
                errors.add(e.getMessage());
            }
        }
        return files;
    }

    private File writeItemToFile(File directory, FileItem item) {
        if (StringUtils.isBlank((String)item.getName())) {
            throw new FileItemNameMissingException(item);
        }
        File file = new File(directory, item.getName());
        try {
            if (file.exists()) {
                file.createNewFile();
            }
            item.write(file);
        }
        catch (Exception e) {
            throw new FileWriteFailedException(file, (Throwable)e);
        }
        return file;
    }

    public static final class FileWriteFailedException
    extends RuntimeException {
        public FileWriteFailedException(File file, Throwable cause) {
            super(file.toString() + " write failed", cause);
        }
    }

    public static final class FileItemNameMissingException
    extends RuntimeException {
        public FileItemNameMissingException(FileItem file) {
            super(file.toString() + " missing name");
        }
    }
}

