/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.spring;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringStepsFactory
extends AbstractStepsFactory {
    private final ApplicationContext context;

    public SpringStepsFactory(Configuration configuration, ApplicationContext context) {
        super(configuration);
        this.context = context;
    }

    protected List<Class<?>> stepsTypes() {
        ArrayList types = new ArrayList();
        for (String name : this.context.getBeanDefinitionNames()) {
            Class type = this.context.getType(name);
            if (!this.isAllowed(type) || !this.hasAnnotatedMethods(type)) continue;
            types.add(type);
        }
        return types;
    }

    protected boolean isAllowed(Class<?> type) {
        return type != null && !Modifier.isAbstract(type.getModifiers());
    }

    public Object createInstanceOfType(Class<?> type) {
        for (String name : this.context.getBeanDefinitionNames()) {
            Class beanType = this.context.getType(name);
            if (!type.equals(beanType)) continue;
            return this.context.getBean(name);
        }
        throw new AbstractStepsFactory.StepsInstanceNotFound(type, (InjectableStepsFactory)this);
    }
}

