/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.google.gson.Gson;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.jbehave.core.annotations.AsJson;
import org.jbehave.core.annotations.AsParameters;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.model.Verbatim;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepMonitor;

public class ParameterConverters {
    public static final StepMonitor DEFAULT_STEP_MONITOR = new SilentStepMonitor();
    public static final Locale DEFAULT_NUMBER_FORMAT_LOCAL = Locale.ENGLISH;
    public static final String DEFAULT_COLLECTION_SEPARATOR = ",";
    public static final boolean DEFAULT_THREAD_SAFETY = true;
    private static final String DEFAULT_TRUE_VALUE = "true";
    private static final String DEFAULT_FALSE_VALUE = "false";
    private final StepMonitor monitor;
    private final List<ParameterConverter> converters;
    private final boolean threadSafe;
    private String escapedCollectionSeparator;

    public ParameterConverters() {
        this(new LoadFromClasspath(), new TableTransformers());
    }

    public ParameterConverters(TableTransformers tableTransformers) {
        this(new LoadFromClasspath(), tableTransformers);
    }

    public ParameterConverters(ResourceLoader resourceLoader) {
        this(resourceLoader, new TableTransformers());
    }

    public ParameterConverters(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(DEFAULT_STEP_MONITOR, resourceLoader, new ParameterControls(), tableTransformers);
    }

    public ParameterConverters(StepMonitor monitor, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers) {
        this(monitor, resourceLoader, parameterControls, tableTransformers, DEFAULT_NUMBER_FORMAT_LOCAL, DEFAULT_COLLECTION_SEPARATOR, true);
    }

    public ParameterConverters(StepMonitor monitor, Keywords keywords, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers) {
        this(monitor, keywords, resourceLoader, parameterControls, tableTransformers, DEFAULT_NUMBER_FORMAT_LOCAL, DEFAULT_COLLECTION_SEPARATOR, true);
    }

    public ParameterConverters(ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, boolean threadSafe) {
        this(DEFAULT_STEP_MONITOR, resourceLoader, parameterControls, tableTransformers, DEFAULT_NUMBER_FORMAT_LOCAL, DEFAULT_COLLECTION_SEPARATOR, threadSafe);
    }

    public ParameterConverters(StepMonitor monitor, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, Locale locale, String collectionSeparator, boolean threadSafe) {
        this(monitor, new LocalizedKeywords(), resourceLoader, parameterControls, tableTransformers, locale, collectionSeparator, threadSafe);
    }

    public ParameterConverters(StepMonitor monitor, Keywords keywords, ResourceLoader resourceLoader, ParameterControls parameterControls, TableTransformers tableTransformers, Locale locale, String collectionSeparator, boolean threadSafe) {
        this(monitor, new ArrayList<ParameterConverter>(), threadSafe);
        this.addConverters(this.defaultConverters(keywords, resourceLoader, parameterControls, new TableParsers(keywords, this), tableTransformers, locale, collectionSeparator));
    }

    public ParameterConverters(StepMonitor monitor, Keywords keywords, ResourceLoader resourceLoader, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers, Locale locale, String collectionSeparator, boolean threadSafe) {
        this(monitor, new ArrayList<ParameterConverter>(), threadSafe);
        this.addConverters(this.defaultConverters(keywords, resourceLoader, parameterControls, tableParsers, tableTransformers, locale, collectionSeparator));
    }

    private ParameterConverters(StepMonitor monitor, List<ParameterConverter> converters, boolean threadSafe) {
        this.monitor = monitor;
        this.threadSafe = threadSafe;
        this.converters = threadSafe ? new CopyOnWriteArrayList<ParameterConverter>(converters) : new ArrayList<ParameterConverter>(converters);
    }

    protected ParameterConverter[] defaultConverters(Keywords keywords, ResourceLoader resourceLoader, ParameterControls parameterControls, TableParsers tableParsers, TableTransformers tableTransformers, Locale locale, String collectionSeparator) {
        this.escapedCollectionSeparator = this.escapeRegexPunctuation(collectionSeparator);
        ExamplesTableFactory tableFactory = new ExamplesTableFactory(keywords, resourceLoader, this, parameterControls, tableParsers, tableTransformers);
        JsonFactory jsonFactory = new JsonFactory();
        return new ParameterConverter[]{new BooleanConverter(), new NumberConverter(NumberFormat.getInstance(locale)), new StringConverter(), new StringListConverter(this.escapedCollectionSeparator), new DateConverter(), new EnumConverter(), new ExamplesTableConverter(tableFactory), new ExamplesTableParametersConverter(tableFactory), new JsonConverter(jsonFactory), new FunctionalParameterConverter<String, Path>(String.class, Path.class, x$0 -> Paths.get(x$0, new String[0])), new FunctionalParameterConverter<String, Currency>(String.class, Currency.class, Currency::getInstance), new FunctionalParameterConverter<String, Pattern>(String.class, Pattern.class, Pattern::compile), new FunctionalParameterConverter<String, File>(String.class, File.class, File::new), new FunctionalParameterConverter<String, Verbatim>(String.class, Verbatim.class, Verbatim::new), new FunctionalParameterConverter<String, Duration>(String.class, Duration.class, Duration::parse), new FunctionalParameterConverter<String, Instant>(String.class, Instant.class, Instant::parse), new FunctionalParameterConverter<String, LocalDate>(String.class, LocalDate.class, LocalDate::parse), new FunctionalParameterConverter<String, LocalDateTime>(String.class, LocalDateTime.class, LocalDateTime::parse), new FunctionalParameterConverter<String, LocalTime>(String.class, LocalTime.class, LocalTime::parse), new FunctionalParameterConverter<String, MonthDay>(String.class, MonthDay.class, MonthDay::parse), new FunctionalParameterConverter<String, OffsetDateTime>(String.class, OffsetDateTime.class, OffsetDateTime::parse), new FunctionalParameterConverter<String, OffsetTime>(String.class, OffsetTime.class, OffsetTime::parse), new FunctionalParameterConverter<String, Period>(String.class, Period.class, Period::parse), new FunctionalParameterConverter<String, Year>(String.class, Year.class, Year::parse), new FunctionalParameterConverter<String, YearMonth>(String.class, YearMonth.class, YearMonth::parse), new FunctionalParameterConverter<String, ZonedDateTime>(String.class, ZonedDateTime.class, ZonedDateTime::parse), new FunctionalParameterConverter<String, ZoneId>(String.class, ZoneId.class, ZoneId::of), new FunctionalParameterConverter<String, ZoneOffset>(String.class, ZoneOffset.class, ZoneOffset::of), new FunctionalParameterConverter<String, OptionalDouble>(String.class, OptionalDouble.class, value -> OptionalDouble.of((Double)this.convert((String)value, Double.TYPE))), new FunctionalParameterConverter<String, OptionalInt>(String.class, OptionalInt.class, value -> OptionalInt.of((Integer)this.convert((String)value, Integer.TYPE))), new FunctionalParameterConverter<String, OptionalLong>(String.class, OptionalLong.class, value -> OptionalLong.of((Long)this.convert((String)value, Long.TYPE)))};
    }

    private String escapeRegexPunctuation(String matchThis) {
        return matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
    }

    public ParameterConverters addConverters(ParameterConverter ... converters) {
        return this.addConverters(Arrays.asList(converters));
    }

    public ParameterConverters addConverters(List<? extends ParameterConverter> converters) {
        this.converters.addAll(0, converters);
        return this;
    }

    private static boolean isChainComplete(Queue<ParameterConverter> convertersChain) {
        return !convertersChain.isEmpty() && ParameterConverters.isBaseType(convertersChain.peek().getSourceType());
    }

    private static Object applyConverters(Object value, Type basicType, Queue<ParameterConverter> convertersChain) {
        Object identity = convertersChain.peek().convertValue(value, basicType);
        return convertersChain.stream().skip(1L).reduce(identity, (v, c) -> c.convertValue(v, c.getTargetType()), (l, r) -> l);
    }

    public Object convert(String value, Type type) {
        Class clazz;
        Queue<ParameterConverter> converters = this.findConverters(type);
        if (ParameterConverters.isChainComplete(converters)) {
            Object converted = ParameterConverters.applyConverters(value, type, converters);
            Queue classes = converters.stream().map(Object::getClass).collect(Collectors.toCollection(LinkedList::new));
            this.monitor.convertedValueOfType(value, type, converted, classes);
            return converted;
        }
        if (ParameterConverters.isAssignableFromRawType(Optional.class, type)) {
            Type elementType = ParameterConverters.argumentType(type);
            return Optional.of(this.convert(value, elementType));
        }
        if (ParameterConverters.isAssignableFromRawType(Collection.class, type)) {
            Queue<ParameterConverter> typeConverters;
            Type elementType = ParameterConverters.argumentType(type);
            Collection collection = ParameterConverters.createCollection(ParameterConverters.rawClass(type));
            if (collection != null && !(typeConverters = this.findConverters(elementType)).isEmpty()) {
                Type sourceType = typeConverters.peek().getSourceType();
                if (ParameterConverters.isBaseType(sourceType)) {
                    ParameterConverters.fillCollection(value, this.escapedCollectionSeparator, typeConverters, elementType, collection);
                } else if (ParameterConverters.isAssignableFrom(Parameters.class, sourceType)) {
                    ExamplesTable table = (ExamplesTable)this.findBaseConverter((Type)((Object)ExamplesTable.class)).convertValue(value, (Type)((Object)String.class));
                    ParameterConverters.fillCollection(table.getRowsAsParameters(), typeConverters, elementType, collection);
                }
                return collection;
            }
        }
        if (type instanceof Class && (clazz = (Class)type).isArray()) {
            String[] elements = ParameterConverters.parseElements(value, this.escapedCollectionSeparator);
            Class<?> elementType = clazz.getComponentType();
            ParameterConverter elementConverter = this.findBaseConverter(elementType);
            Object array = ParameterConverters.createArray(elementType, elements.length);
            if (elementConverter != null && array != null) {
                ParameterConverters.fillArray(elements, elementConverter, elementType, array);
                return array;
            }
        }
        throw new ParameterConversionFailed("No parameter converter for " + type);
    }

    private ParameterConverter findBaseConverter(Type type) {
        for (ParameterConverter converter : this.converters) {
            if (!converter.canConvertFrom((Type)((Object)String.class)) || !converter.canConvertTo(type)) continue;
            return converter;
        }
        return null;
    }

    private Queue<ParameterConverter> findConverters(Type type) {
        LinkedList<ParameterConverter> convertersChain = new LinkedList<ParameterConverter>();
        this.putConverters(type, convertersChain);
        return convertersChain;
    }

    private void putConverters(Type type, LinkedList<ParameterConverter> container) {
        for (ParameterConverter converter : this.converters) {
            if (!converter.canConvertTo(type)) continue;
            container.addFirst(converter);
            Type sourceType = converter.getSourceType();
            if (ParameterConverters.isBaseType(sourceType)) break;
            this.putConverters(sourceType, container);
        }
    }

    private static boolean isBaseType(Type type) {
        return String.class.isAssignableFrom((Class)type);
    }

    private static boolean isAssignableFrom(Class<?> clazz, Type type) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type);
    }

    private static boolean isAssignableFromRawType(Class<?> clazz, Type type) {
        return type instanceof ParameterizedType && ParameterConverters.isAssignableFrom(clazz, ((ParameterizedType)type).getRawType());
    }

    private static Class<?> rawClass(Type type) {
        return (Class)((ParameterizedType)type).getRawType();
    }

    private static Class<?> argumentClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
            return typeArgument instanceof ParameterizedType ? ParameterConverters.rawClass(typeArgument) : (Class)typeArgument;
        }
        return (Class)type;
    }

    private static Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    private static boolean isAnnotationPresent(Type type, Class<? extends Annotation> annotationClass) {
        if (type instanceof ParameterizedType) {
            return ParameterConverters.rawClass(type).isAnnotationPresent(annotationClass) || ParameterConverters.argumentClass(type).isAnnotationPresent(annotationClass);
        }
        return type instanceof Class && ((Class)type).isAnnotationPresent(annotationClass);
    }

    private static String[] parseElements(String value, String elementSeparator) {
        String[] elements = value.trim().isEmpty() ? new String[]{} : value.split(elementSeparator);
        Arrays.setAll(elements, i -> elements[i].trim());
        return elements;
    }

    private static void fillCollection(String value, String elementSeparator, Queue<ParameterConverter> convertersChain, Type elementType, Collection convertedValues) {
        ParameterConverters.fillCollection(Arrays.asList(ParameterConverters.parseElements(value, elementSeparator)), convertersChain, elementType, convertedValues);
    }

    private static void fillCollection(Collection elements, Queue<ParameterConverter> convertersChain, Type elementType, Collection convertedValues) {
        for (Object element : elements) {
            Object convertedValue = ParameterConverters.applyConverters(element, elementType, convertersChain);
            convertedValues.add(convertedValue);
        }
    }

    private static <T> void fillArray(String[] elements, ParameterConverter<String, T> elementConverter, Type elementType, Object convertedValues) {
        for (int i = 0; i < elements.length; ++i) {
            T convertedValue = elementConverter.convertValue(elements[i], elementType);
            Array.set(convertedValues, i, convertedValue);
        }
    }

    private static <E> Collection<E> createCollection(Class<?> collectionType) {
        if (collectionType.isInterface()) {
            if (Set.class == collectionType) {
                return new HashSet();
            }
            if (List.class == collectionType) {
                return new ArrayList();
            }
            if (SortedSet.class == collectionType || NavigableSet.class == collectionType) {
                return new TreeSet();
            }
        }
        try {
            return (Collection)collectionType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Object createArray(Class<?> elementType, int length) {
        try {
            return Array.newInstance(elementType, length);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public ParameterConverters newInstanceAdding(ParameterConverter converter) {
        ArrayList<ParameterConverter> convertersForNewInstance = new ArrayList<ParameterConverter>(this.converters);
        convertersForNewInstance.add(converter);
        return new ParameterConverters(this.monitor, convertersForNewInstance, this.threadSafe);
    }

    public static interface ParameterConverter<S, T> {
        public boolean canConvertTo(Type var1);

        public boolean canConvertFrom(Type var1);

        public T convertValue(S var1, Type var2);

        public Type getSourceType();

        public Type getTargetType();
    }

    public static class JsonFactory {
        private Keywords keywords;
        private final ResourceLoader resourceLoader;

        public JsonFactory() {
            this(new LocalizedKeywords());
        }

        public JsonFactory(Keywords keywords) {
            this(keywords, new LoadFromClasspath());
        }

        public JsonFactory(ResourceLoader resourceLoader) {
            this(new LocalizedKeywords(), resourceLoader);
        }

        public JsonFactory(Keywords keywords, ResourceLoader resourceLoader) {
            this.keywords = keywords;
            this.resourceLoader = resourceLoader;
        }

        public JsonFactory(Configuration configuration) {
            this.keywords = configuration.keywords();
            this.resourceLoader = configuration.storyLoader();
        }

        public Object createJson(String input, Type type) {
            String jsonAsString = StringUtils.isBlank((CharSequence)input) || this.isJson(input) ? input : this.resourceLoader.loadResourceAsText(input);
            return new Gson().fromJson(jsonAsString, type);
        }

        protected boolean isJson(String input) {
            return input.startsWith("[") && input.endsWith("]") || input.startsWith("{") && input.endsWith("}");
        }

        public void useKeywords(Keywords keywords) {
            this.keywords = keywords;
        }

        public Keywords keywords() {
            return this.keywords;
        }
    }

    public static class BooleanConverter
    extends FromStringParameterConverter<Boolean> {
        private final String trueValue;
        private final String falseValue;

        public BooleanConverter() {
            this(ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanConverter(String trueValue, String falseValue) {
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public boolean canConvertTo(Type type) {
            return super.canConvertTo(type) || ParameterConverters.isAssignableFrom(Boolean.TYPE, type);
        }

        @Override
        public Boolean convertValue(String value, Type type) {
            try {
                return BooleanUtils.toBoolean((String)value, (String)this.trueValue, (String)this.falseValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    public static class NumberConverter
    extends FromStringParameterConverter<Number> {
        private static List<Class<?>> primitiveTypes = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        private final NumberFormat numberFormat;
        private ThreadLocal<NumberFormat> threadLocalNumberFormat = new ThreadLocal();

        public NumberConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NumberConverter(NumberFormat numberFormat) {
            NumberConverter numberConverter = this;
            synchronized (numberConverter) {
                this.numberFormat = numberFormat;
                this.threadLocalNumberFormat.set((NumberFormat)this.numberFormat.clone());
            }
        }

        @Override
        public boolean canConvertTo(Type type) {
            return super.canConvertTo(type) || primitiveTypes.contains(type);
        }

        @Override
        public Number convertValue(String value, Type type) {
            try {
                Number n = this.numberFormat().parse(value);
                if (type == Byte.class || type == Byte.TYPE) {
                    return n.byteValue();
                }
                if (type == Short.class || type == Short.TYPE) {
                    return n.shortValue();
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    return n.intValue();
                }
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf(n.floatValue());
                }
                if (type == Long.class || type == Long.TYPE) {
                    return n.longValue();
                }
                if (type == Double.class || type == Double.TYPE) {
                    return n.doubleValue();
                }
                if (type == BigInteger.class) {
                    return BigInteger.valueOf(n.longValue());
                }
                if (type == BigDecimal.class) {
                    return new BigDecimal(this.canonicalize(value));
                }
                if (type == AtomicInteger.class) {
                    return new AtomicInteger(Integer.parseInt(value));
                }
                if (type == AtomicLong.class) {
                    return new AtomicLong(Long.parseLong(value));
                }
                return n;
            }
            catch (NumberFormatException | ParseException e) {
                throw new ParameterConversionFailed(value, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NumberFormat numberFormat() {
            if (this.threadLocalNumberFormat.get() == null) {
                NumberConverter numberConverter = this;
                synchronized (numberConverter) {
                    this.threadLocalNumberFormat.set((NumberFormat)this.numberFormat.clone());
                }
            }
            return this.threadLocalNumberFormat.get();
        }

        private String canonicalize(String value) {
            boolean isNegative;
            int decimalPointSeparator = 46;
            char minusSign = '-';
            String rxNotDigits = "[\\.,]";
            StringBuilder builder = new StringBuilder(value.length());
            if (this.numberFormat() instanceof DecimalFormat) {
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)this.numberFormat()).getDecimalFormatSymbols();
                minusSign = decimalFormatSymbols.getMinusSign();
                decimalPointSeparator = decimalFormatSymbols.getDecimalSeparator();
            }
            value = value.trim();
            int decimalPointPosition = value.lastIndexOf(decimalPointSeparator);
            int firstDecimalPointPosition = value.indexOf(decimalPointSeparator);
            if (firstDecimalPointPosition != decimalPointPosition) {
                throw new NumberFormatException("Invalid format, more than one decimal point has been found.");
            }
            if (decimalPointPosition != -1) {
                String sf = value.substring(0, decimalPointPosition).replaceAll(rxNotDigits, "");
                String dp = value.substring(decimalPointPosition + 1).replaceAll(rxNotDigits, "");
                builder.append(sf);
                builder.append('.');
                builder.append(dp);
            } else {
                builder.append(value.replaceAll(rxNotDigits, ""));
            }
            boolean bl = isNegative = value.charAt(0) == minusSign;
            if (isNegative) {
                builder.setCharAt(0, '-');
            }
            return builder.toString();
        }
    }

    public static class StringConverter
    extends FromStringParameterConverter<String> {
        private static final String NEWLINES_PATTERN = "(\n)|(\r\n)";
        private static final String SYSTEM_NEWLINE = System.getProperty("line.separator");

        @Override
        public String convertValue(String value, Type type) {
            return value != null ? value.replaceAll(NEWLINES_PATTERN, SYSTEM_NEWLINE) : null;
        }
    }

    public static class StringListConverter
    extends AbstractListParameterConverter<String> {
        public StringListConverter() {
            this(ParameterConverters.DEFAULT_COLLECTION_SEPARATOR);
        }

        public StringListConverter(String valueSeparator) {
            super(valueSeparator, new StringConverter());
        }

        @Override
        public List<String> convertValue(String value, Type type) {
            if (value.trim().isEmpty()) {
                return Collections.emptyList();
            }
            return super.convertValue(value, type);
        }
    }

    public static class DateConverter
    extends FromStringParameterConverter<Date> {
        public static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
        private final DateFormat dateFormat;

        public DateConverter() {
            this(DEFAULT_FORMAT);
        }

        public DateConverter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public Date convertValue(String value, Type type) {
            try {
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new ParameterConversionFailed("Failed to convert value " + value + " with date format " + (this.dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)this.dateFormat).toPattern() : this.dateFormat), e);
            }
        }
    }

    public static class EnumConverter
    extends FromStringParameterConverter<Enum<?>> {
        @Override
        public boolean canConvertTo(Type type) {
            return type instanceof Class && ((Class)type).isEnum();
        }

        @Override
        public Enum<?> convertValue(String value, Type type) {
            String typeClass = ((Class)type).getName();
            Class enumClass = (Class)type;
            Method valueOfMethod = null;
            try {
                valueOfMethod = enumClass.getMethod("valueOf", String.class);
                valueOfMethod.setAccessible(true);
                return (Enum)valueOfMethod.invoke((Object)enumClass, value);
            }
            catch (Exception e) {
                throw new ParameterConversionFailed("Failed to convert " + value + " for Enum " + typeClass, e);
            }
        }
    }

    public static class ExamplesTableConverter
    extends FunctionalParameterConverter<String, ExamplesTable> {
        public ExamplesTableConverter(ExamplesTableFactory factory) {
            super(factory::createExamplesTable);
        }
    }

    public static class ExamplesTableParametersConverter
    extends FromStringParameterConverter<Object> {
        private final ExamplesTableFactory factory;

        public ExamplesTableParametersConverter(ExamplesTableFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean canConvertTo(Type type) {
            return ExamplesTableParametersConverter.isExamplesTableParameters(type);
        }

        @Override
        public Object convertValue(String value, Type type) {
            List rows = this.factory.createExamplesTable(value).getRowsAs(ParameterConverters.argumentClass(type));
            if (ParameterConverters.isAssignableFromRawType(List.class, type)) {
                return rows;
            }
            int rowCount = rows.size();
            Validate.isTrue((rowCount == 1 ? 1 : 0) != 0, (String)"Exactly one row is expected in ExamplesTable in order to convert it to %s, but found %d row(s)", (Object[])new Object[]{type, rowCount});
            return rows.get(0);
        }

        public static boolean isExamplesTableParameters(Type type) {
            return ParameterConverters.isAnnotationPresent(type, AsParameters.class);
        }
    }

    public static class JsonConverter
    extends FromStringParameterConverter<Object> {
        private final JsonFactory factory;

        public JsonConverter() {
            this(new JsonFactory());
        }

        public JsonConverter(JsonFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean canConvertTo(Type type) {
            return ParameterConverters.isAnnotationPresent(type, AsJson.class);
        }

        @Override
        public Object convertValue(String value, Type type) {
            return this.factory.createJson(value, type);
        }
    }

    public static class FunctionalParameterConverter<S, T>
    extends AbstractParameterConverter<S, T> {
        private final Function<S, T> converterFunction;

        public FunctionalParameterConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> converterFunction) {
            super(sourceType, targetType);
            this.converterFunction = converterFunction;
        }

        protected FunctionalParameterConverter(Function<S, T> converterFunction) {
            this.converterFunction = converterFunction;
        }

        @Override
        public T convertValue(S value, Type type) {
            return this.converterFunction.apply(value);
        }
    }

    public static class ParameterConversionFailed
    extends RuntimeException {
        public ParameterConversionFailed(String message) {
            super(message);
        }

        public ParameterConversionFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MethodReturningConverter
    extends FromStringParameterConverter<Object> {
        private Method method;
        private Class<?> stepsType;
        private InjectableStepsFactory stepsFactory;

        public MethodReturningConverter(Method method, Object instance) {
            this(method, instance.getClass(), new InstanceStepsFactory((Configuration)new MostUsefulConfiguration(), instance));
        }

        public MethodReturningConverter(Method method, Class<?> stepsType, InjectableStepsFactory stepsFactory) {
            this.method = method;
            this.stepsType = stepsType;
            this.stepsFactory = stepsFactory;
        }

        @Override
        public boolean canConvertTo(Type type) {
            return ParameterConverters.isAssignableFrom(this.method.getReturnType(), type);
        }

        @Override
        public Object convertValue(String value, Type type) {
            try {
                Object instance = this.instance();
                return this.method.invoke(instance, value);
            }
            catch (Exception e) {
                throw new ParameterConversionFailed("Failed to invoke method " + this.method + " with value " + value + " in " + type, e);
            }
        }

        private Object instance() {
            return this.stepsFactory.createInstanceOfType(this.stepsType);
        }
    }

    public static class EnumListConverter
    extends AbstractListParameterConverter<Enum<?>> {
        public EnumListConverter() {
            this(ParameterConverters.DEFAULT_COLLECTION_SEPARATOR);
        }

        public EnumListConverter(String valueSeparator) {
            super(valueSeparator, new EnumConverter());
        }
    }

    public static class FluentEnumConverter
    extends EnumConverter {
        @Override
        public Enum<?> convertValue(String value, Type type) {
            return super.convertValue(value.replaceAll("\\W", "_").toUpperCase(), type);
        }
    }

    public static class BooleanListConverter
    extends AbstractListParameterConverter<Boolean> {
        public BooleanListConverter() {
            this(ParameterConverters.DEFAULT_COLLECTION_SEPARATOR, ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator) {
            this(valueSeparator, ParameterConverters.DEFAULT_TRUE_VALUE, ParameterConverters.DEFAULT_FALSE_VALUE);
        }

        public BooleanListConverter(String valueSeparator, String trueValue, String falseValue) {
            super(valueSeparator, new BooleanConverter(trueValue, falseValue));
        }
    }

    public static class NumberListConverter
    extends AbstractListParameterConverter<Number> {
        public NumberListConverter() {
            this(NumberFormat.getInstance(DEFAULT_NUMBER_FORMAT_LOCAL), ParameterConverters.DEFAULT_COLLECTION_SEPARATOR);
        }

        public NumberListConverter(NumberFormat numberFormat, String valueSeparator) {
            super(valueSeparator, new NumberConverter(numberFormat));
        }
    }

    public static abstract class AbstractListParameterConverter<T>
    extends FromStringParameterConverter<List<T>> {
        private final String valueSeparator;
        private final Queue<ParameterConverter> elementConverters;

        public AbstractListParameterConverter(String valueSeparator, FromStringParameterConverter<T> elementConverter) {
            this.valueSeparator = valueSeparator;
            this.elementConverters = new LinkedList<ParameterConverter>();
            this.elementConverters.add(elementConverter);
        }

        @Override
        public boolean canConvertTo(Type type) {
            return ParameterConverters.isAssignableFromRawType(List.class, type) && this.elementConverters.peek().canConvertTo(ParameterConverters.argumentType(type));
        }

        @Override
        public List<T> convertValue(String value, Type type) {
            Type elementType = ParameterConverters.argumentType(type);
            ArrayList convertedValues = new ArrayList();
            ParameterConverters.fillCollection(value, this.valueSeparator, this.elementConverters, elementType, convertedValues);
            return convertedValues;
        }
    }

    public static abstract class AbstractParameterConverter<S, T>
    implements ParameterConverter<S, T> {
        private final Type sourceType;
        private final Type targetType;

        public AbstractParameterConverter() {
            Map types = TypeUtils.getTypeArguments(this.getClass(), ParameterConverter.class);
            TypeVariable<Class<T>>[] typeVariables = ParameterConverter.class.getTypeParameters();
            this.sourceType = (Type)types.get(typeVariables[0]);
            this.targetType = (Type)types.get(typeVariables[1]);
        }

        public AbstractParameterConverter(Type sourceType, Type targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        @Override
        public boolean canConvertTo(Type type) {
            return AbstractParameterConverter.isAssignable(this.targetType, type);
        }

        @Override
        public boolean canConvertFrom(Type type) {
            return AbstractParameterConverter.isAssignable(this.sourceType, type);
        }

        @Override
        public Type getSourceType() {
            return this.sourceType;
        }

        @Override
        public Type getTargetType() {
            return this.targetType;
        }

        private static boolean isAssignable(Type from, Type to) {
            if (from instanceof Class) {
                return ParameterConverters.isAssignableFrom((Class)from, to);
            }
            return from.equals(to);
        }
    }

    public static abstract class FromStringParameterConverter<T>
    extends AbstractParameterConverter<String, T> {
        public FromStringParameterConverter() {
        }

        public FromStringParameterConverter(Type targetType) {
            super((Type)((Object)String.class), targetType);
        }
    }
}

