/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;

public class MarkUnmatchedStepsAsPending
implements StepCollector {
    private final StepFinder stepFinder;
    private final Keywords keywords;

    public MarkUnmatchedStepsAsPending() {
        this(new StepFinder());
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder) {
        this(stepFinder, new LocalizedKeywords());
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder, Keywords keywords) {
        this.stepFinder = stepFinder;
        this.keywords = keywords;
    }

    @Override
    public List<Step> collectBeforeOrAfterStoriesSteps(List<BeforeOrAfterStep> beforeOrAfterStoriesSteps) {
        return beforeOrAfterStoriesSteps.stream().map(BeforeOrAfterStep::createStep).collect(Collectors.toList());
    }

    @Override
    public List<Step> collectBeforeOrAfterStorySteps(List<BeforeOrAfterStep> beforeOrAfterStorySteps, Meta storyMeta) {
        return this.createSteps(beforeOrAfterStorySteps, storyMeta);
    }

    @Override
    public List<Step> collectBeforeScenarioSteps(List<BeforeOrAfterStep> beforeScenarioSteps, Meta storyAndScenarioMeta) {
        return this.createSteps(beforeScenarioSteps, storyAndScenarioMeta);
    }

    @Override
    public List<Step> collectAfterScenarioSteps(List<BeforeOrAfterStep> afterScenarioSteps, Meta storyAndScenarioMeta) {
        return afterScenarioSteps.stream().map(step -> step.createStepUponOutcome(storyAndScenarioMeta)).collect(Collectors.toList());
    }

    @Override
    public Map<StepCollector.Stage, List<Step>> collectLifecycleSteps(List<StepCandidate> stepCandidates, Lifecycle lifecycle, Meta storyAndScenarioMeta, Scope scope, StepMonitor stepMonitor) {
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        List<Step> beforeSteps = this.collectMatchedSteps(lifecycle.getBeforeSteps(scope), namedParameters, stepCandidates, null, stepMonitor);
        List afterSteps = Stream.of(AfterScenario.Outcome.values()).map(outcome -> this.collectMatchedSteps(lifecycle.getAfterSteps(scope, (AfterScenario.Outcome)((Object)outcome), storyAndScenarioMeta), (Map<String, String>)namedParameters, stepCandidates, (AfterScenario.Outcome)((Object)outcome), stepMonitor)).flatMap(Collection::stream).collect(Collectors.toList());
        EnumMap<StepCollector.Stage, List<Step>> steps = new EnumMap<StepCollector.Stage, List<Step>>(StepCollector.Stage.class);
        steps.put(StepCollector.Stage.BEFORE, beforeSteps);
        steps.put(StepCollector.Stage.AFTER, afterSteps);
        return steps;
    }

    @Override
    public List<Step> collectScenarioSteps(List<StepCandidate> stepCandidates, Scenario scenario, Map<String, String> parameters, StepMonitor stepMonitor) {
        return this.collectMatchedSteps(scenario.getSteps(), parameters, stepCandidates, null, stepMonitor);
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfterSteps, Meta meta) {
        return beforeOrAfterSteps.stream().map(step -> step.createStepWith(meta)).collect(Collectors.toList());
    }

    private List<Step> collectMatchedSteps(List<String> stepsAsString, Map<String, String> namedParameters, List<StepCandidate> stepCandidates, AfterScenario.Outcome outcome, StepMonitor stepMonitor) {
        ArrayList<Step> steps = new ArrayList<Step>();
        String previousNonAndStep = null;
        for (String stepAsString : stepsAsString) {
            Step step = StepCreator.createPendingStep(stepAsString, previousNonAndStep);
            List<StepCandidate> prioritisedCandidates = this.stepFinder.prioritise(stepAsString, new ArrayList<StepCandidate>(stepCandidates));
            for (StepCandidate candidate : prioritisedCandidates) {
                candidate.useStepMonitor(stepMonitor);
                if (candidate.ignore(stepAsString)) {
                    step = StepCreator.createIgnorableStep(stepAsString);
                    break;
                }
                if (candidate.comment(stepAsString)) {
                    step = StepCreator.createComment(stepAsString);
                    break;
                }
                if (!candidate.matches(stepAsString, previousNonAndStep)) continue;
                if (candidate.isPending()) {
                    ((StepCreator.PendingStep)step).annotatedOn(candidate.getMethod());
                } else {
                    ArrayList<Step> composedSteps = new ArrayList<Step>();
                    if (candidate.isComposite()) {
                        candidate.addComposedSteps(composedSteps, stepAsString, namedParameters, prioritisedCandidates);
                    }
                    step = outcome != null ? candidate.createMatchedStepUponOutcome(stepAsString, namedParameters, composedSteps, outcome) : candidate.createMatchedStep(stepAsString, namedParameters, composedSteps);
                }
                if (this.keywords.isAndStep(stepAsString) || this.keywords.isIgnorableStep(stepAsString)) break;
                previousNonAndStep = stepAsString;
                break;
            }
            if (!this.keywords.isAndStep(stepAsString) && !this.keywords.isIgnorableStep(stepAsString)) {
                previousNonAndStep = stepAsString;
            }
            steps.add(step);
        }
        return steps;
    }
}

