/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jbehave.core.annotations.Parameter;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

public class ConvertedParameters
implements Parameters {
    private final Map<String, String> values;
    private final ParameterConverters parameterConverters;

    public ConvertedParameters(Row row, ParameterConverters parameterConverters) {
        this(row.values(), parameterConverters);
    }

    public ConvertedParameters(Map<String, String> values, ParameterConverters parameterConverters) {
        this.values = values;
        this.parameterConverters = parameterConverters;
    }

    @Override
    public <T> T valueAs(String name, Type type) {
        return this.convert(this.valueFor(name), type);
    }

    @Override
    public <T> T valueAs(String name, Type type, T defaultValue) {
        if (this.values.containsKey(name)) {
            return this.valueAs(name, type);
        }
        return defaultValue;
    }

    @Override
    public <T> T mapTo(Class<T> type) {
        return this.mapTo(type, Collections.emptyMap());
    }

    @Override
    public <T> T mapTo(Class<T> type, Map<String, String> fieldNameMapping) {
        try {
            T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Map.Entry<String, Field> mappedField : ConvertedParameters.findFields(type, this.values().keySet(), fieldNameMapping).entrySet()) {
                Field field = mappedField.getValue();
                T value = this.valueAs(mappedField.getKey(), field.getGenericType());
                field.setAccessible(true);
                field.set(instance, value);
            }
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new ParametersNotMappableToType(e);
        }
    }

    private static Map<String, Field> findFields(Class<?> type, Set<String> fieldNames, Map<String, String> fieldNameMapping) {
        HashMap<String, Field> mappedFields = new HashMap<String, Field>();
        ArrayList<String> unmappableFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            Optional<Field> fieldWrapper = ConvertedParameters.findField(type, fieldName, fieldNameMapping);
            if (fieldWrapper.isPresent()) {
                mappedFields.put(fieldName, fieldWrapper.get());
                continue;
            }
            unmappableFields.add(fieldName);
        }
        if (unmappableFields.isEmpty()) {
            return mappedFields;
        }
        throw new ParametersNotMappableToType(String.format("Unable to map %s field(s) for type %s", unmappableFields, type));
    }

    private static <T> Optional<Field> findField(Class<T> type, String name, Map<String, String> fieldNameMapping) {
        String mapping = fieldNameMapping.get(name);
        String fieldName = mapping == null ? name : mapping;
        Optional<Field> field = Stream.of(type.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Parameter.class)).filter(f -> fieldName.equals(f.getAnnotation(Parameter.class).name())).findFirst();
        return field.isPresent() ? field : ConvertedParameters.findField(type, fieldName);
    }

    private static Optional<Field> findField(Class<?> type, String fieldName) {
        for (Field field : type.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return Optional.of(field);
        }
        if (type.getSuperclass() != null) {
            return ConvertedParameters.findField(type.getSuperclass(), fieldName);
        }
        return Optional.empty();
    }

    private <T> T convert(String value, Type type) {
        return (T)this.parameterConverters.convert(value, type);
    }

    private String valueFor(String name) {
        if (!this.values.containsKey(name)) {
            throw new ValueNotFound(name);
        }
        return this.values.get(name);
    }

    @Override
    public Map<String, String> values() {
        return this.values;
    }

    public static class ParametersNotMappableToType
    extends RuntimeException {
        public ParametersNotMappableToType(String message) {
            super(message);
        }

        public ParametersNotMappableToType(Exception cause) {
            super(cause);
        }
    }

    public static class ValueNotFound
    extends RuntimeException {
        public ValueNotFound(String name) {
            super(name);
        }
    }
}

