/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Step;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.ThreadSafeReporter;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.Timing;

public class ConcurrentStoryReporter
implements StoryReporter {
    private static Method beforeStoriesSteps;
    private static Method afterStoriesSteps;
    private static Method storyCancelled;
    private static Method storyExcluded;
    private static Method beforeStory;
    private static Method afterStory;
    private static Method narrative;
    private static Method lifecycle;
    private static Method beforeStorySteps;
    private static Method afterStorySteps;
    private static Method beforeScenarioSteps;
    private static Method afterScenarioSteps;
    private static Method beforeComposedSteps;
    private static Method afterComposedSteps;
    private static Method scenarioExcluded;
    private static Method beforeScenarios;
    private static Method beforeScenario;
    private static Method afterScenario;
    private static Method afterScenarios;
    private static Method beforeGivenStories;
    private static Method givenStories;
    private static Method givenStoriesPaths;
    private static Method afterGivenStories;
    private static Method beforeExamples;
    private static Method example;
    private static Method afterExamples;
    private static Method beforeStep;
    private static Method successful;
    private static Method ignorable;
    private static Method comment;
    private static Method pending;
    private static Method pendingDeprecated;
    private static Method notPerformed;
    private static Method failed;
    private static Method failedOutcomes;
    private static Method dryRun;
    private static Method pendingMethods;
    private static Method restarted;
    private static Method restartedStory;
    private final StoryReporter crossReferencing;
    private final StoryReporter delegate;
    private final StoryReporter threadSafeDelegate;
    private final boolean multiThreading;
    private final List<DelayedMethod> delayedMethods;
    private boolean invoked = false;

    public ConcurrentStoryReporter(StoryReporter crossReferencing, List<StoryReporter> delegates, boolean multiThreading) {
        this.crossReferencing = crossReferencing;
        ArrayList<StoryReporter> reporters = new ArrayList<StoryReporter>(delegates);
        List<StoryReporter> threadSafeDelegates = reporters.stream().filter(ThreadSafeReporter.class::isInstance).collect(Collectors.toList());
        this.threadSafeDelegate = new DelegatingStoryReporter(threadSafeDelegates);
        reporters.removeAll(threadSafeDelegates);
        this.delegate = new DelegatingStoryReporter(reporters);
        this.multiThreading = multiThreading;
        this.delayedMethods = multiThreading ? Collections.synchronizedList(new ArrayList()) : null;
    }

    @Override
    public void beforeStoriesSteps(StepCollector.Stage stage) {
        this.perform(reporter -> reporter.beforeStoriesSteps(stage), beforeStoriesSteps, new Object[]{stage});
    }

    @Override
    public void afterStoriesSteps(StepCollector.Stage stage) {
        this.perform(reporter -> reporter.afterStoriesSteps(stage), afterStoriesSteps, new Object[]{stage});
    }

    @Override
    public void storyExcluded(Story story, String filter) {
        this.perform(reporter -> reporter.storyExcluded(story, filter), storyExcluded, story, filter);
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.perform(reporter -> reporter.beforeStory(story, givenStory), beforeStory, story, givenStory);
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.perform(reporter -> reporter.afterStory(givenStory), afterStory, givenStory);
    }

    @Override
    public void narrative(Narrative narrative) {
        this.perform(reporter -> reporter.narrative(narrative), ConcurrentStoryReporter.narrative, narrative);
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        this.perform(reporter -> reporter.lifecycle(lifecycle), ConcurrentStoryReporter.lifecycle, lifecycle);
    }

    @Override
    public void beforeStorySteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.perform(reporter -> reporter.beforeStorySteps(stage, type), beforeStorySteps, new Object[]{stage, type});
    }

    @Override
    public void afterStorySteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.perform(reporter -> reporter.afterStorySteps(stage, type), afterStorySteps, new Object[]{stage, type});
    }

    @Override
    public void beforeComposedSteps() {
        this.perform(StoryReporter::beforeComposedSteps, beforeComposedSteps, new Object[0]);
    }

    @Override
    public void afterComposedSteps() {
        this.perform(StoryReporter::afterComposedSteps, afterComposedSteps, new Object[0]);
    }

    @Override
    public void beforeScenarioSteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.perform(reporter -> reporter.beforeScenarioSteps(stage, type), beforeScenarioSteps, new Object[]{stage, type});
    }

    @Override
    public void afterScenarioSteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.perform(reporter -> reporter.afterScenarioSteps(stage, type), afterScenarioSteps, new Object[]{stage, type});
    }

    @Override
    public void scenarioExcluded(Scenario scenario, String filter) {
        this.perform(reporter -> reporter.scenarioExcluded(scenario, filter), scenarioExcluded, scenario, filter);
    }

    @Override
    public void beforeScenarios() {
        this.perform(StoryReporter::beforeScenarios, beforeScenarios, new Object[0]);
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        this.perform(reporter -> reporter.beforeScenario(scenario), beforeScenario, scenario);
    }

    @Override
    public void afterScenario(Timing timing) {
        this.perform(reporter -> reporter.afterScenario(timing), afterScenario, timing);
    }

    @Override
    public void afterScenarios() {
        this.perform(StoryReporter::afterScenarios, afterScenarios, new Object[0]);
    }

    @Override
    public void beforeGivenStories() {
        this.perform(StoryReporter::beforeGivenStories, beforeGivenStories, new Object[0]);
    }

    @Override
    public void givenStories(GivenStories stories) {
        this.perform(reporter -> reporter.givenStories(stories), givenStories, stories);
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.perform(reporter -> reporter.givenStories(storyPaths), givenStoriesPaths, storyPaths);
    }

    @Override
    public void afterGivenStories() {
        this.perform(StoryReporter::afterGivenStories, afterGivenStories, new Object[0]);
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.perform(reporter -> reporter.beforeExamples(steps, table), beforeExamples, steps, table);
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        this.perform(reporter -> reporter.example(tableRow, exampleIndex), example, tableRow, exampleIndex);
    }

    @Override
    public void afterExamples() {
        this.perform(StoryReporter::afterExamples, afterExamples, new Object[0]);
    }

    @Override
    public void beforeStep(Step step) {
        this.perform(reporter -> reporter.beforeStep(step), beforeStep, step);
    }

    @Override
    public void successful(String step) {
        this.perform(reporter -> reporter.successful(step), successful, step);
    }

    @Override
    public void ignorable(String step) {
        this.perform(reporter -> reporter.ignorable(step), ignorable, step);
    }

    @Override
    public void comment(String step) {
        this.perform(reporter -> reporter.comment(step), comment, step);
    }

    @Override
    public void pending(StepCreator.PendingStep step) {
        this.perform(reporter -> reporter.pending(step), pending, step);
    }

    @Override
    public void pending(String step) {
        this.perform(reporter -> reporter.pending(step), pendingDeprecated, step);
    }

    @Override
    public void notPerformed(String step) {
        this.perform(reporter -> reporter.notPerformed(step), notPerformed, step);
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.perform(reporter -> reporter.failed(step, cause), failed, step, cause);
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.perform(reporter -> reporter.failedOutcomes(step, table), failedOutcomes, step, table);
    }

    @Override
    public void dryRun() {
        this.perform(StoryReporter::dryRun, dryRun, new Object[0]);
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.perform(reporter -> reporter.pendingMethods(methods), pendingMethods, methods);
    }

    @Override
    public void restarted(String step, Throwable cause) {
        this.perform(reporter -> reporter.restarted(step, cause), restarted, step, cause);
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        this.perform(reporter -> reporter.restartedStory(story, cause), restartedStory, story, cause);
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.perform(reporter -> reporter.storyCancelled(story, storyDuration), storyCancelled, story, storyDuration);
    }

    private void perform(Consumer<StoryReporter> crossReferencingInvoker, Method delayedMethod, Object ... delayedMethodArgs) {
        crossReferencingInvoker.accept(this.crossReferencing);
        crossReferencingInvoker.accept(this.threadSafeDelegate);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(delayedMethod, delayedMethodArgs));
        } else {
            crossReferencingInvoker.accept(this.delegate);
        }
    }

    public StoryReporter getDelegate() {
        return this.delegate;
    }

    public boolean invoked() {
        return this.invoked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeDelayed() {
        if (!this.multiThreading) {
            return;
        }
        StoryReporter storyReporter = this.delegate;
        synchronized (storyReporter) {
            for (DelayedMethod delayed : this.delayedMethods) {
                delayed.invoke(this.delegate);
            }
            this.delayedMethods.clear();
        }
        this.invoked = true;
    }

    static {
        try {
            beforeStoriesSteps = StoryReporter.class.getMethod("beforeStoriesSteps", StepCollector.Stage.class);
            afterStoriesSteps = StoryReporter.class.getMethod("afterStoriesSteps", StepCollector.Stage.class);
            storyCancelled = StoryReporter.class.getMethod("storyCancelled", Story.class, StoryDuration.class);
            storyExcluded = StoryReporter.class.getMethod("storyExcluded", Story.class, String.class);
            beforeStory = StoryReporter.class.getMethod("beforeStory", Story.class, Boolean.TYPE);
            afterStory = StoryReporter.class.getMethod("afterStory", Boolean.TYPE);
            narrative = StoryReporter.class.getMethod("narrative", Narrative.class);
            lifecycle = StoryReporter.class.getMethod("lifecycle", Lifecycle.class);
            beforeStorySteps = StoryReporter.class.getMethod("beforeStorySteps", StepCollector.Stage.class, Lifecycle.ExecutionType.class);
            afterStorySteps = StoryReporter.class.getMethod("afterStorySteps", StepCollector.Stage.class, Lifecycle.ExecutionType.class);
            beforeScenarioSteps = StoryReporter.class.getMethod("beforeScenarioSteps", StepCollector.Stage.class, Lifecycle.ExecutionType.class);
            afterScenarioSteps = StoryReporter.class.getMethod("afterScenarioSteps", StepCollector.Stage.class, Lifecycle.ExecutionType.class);
            beforeComposedSteps = StoryReporter.class.getMethod("beforeComposedSteps", new Class[0]);
            afterComposedSteps = StoryReporter.class.getMethod("afterComposedSteps", new Class[0]);
            scenarioExcluded = StoryReporter.class.getMethod("scenarioExcluded", Scenario.class, String.class);
            beforeScenarios = StoryReporter.class.getMethod("beforeScenarios", new Class[0]);
            beforeScenario = StoryReporter.class.getMethod("beforeScenario", Scenario.class);
            afterScenario = StoryReporter.class.getMethod("afterScenario", Timing.class);
            afterScenarios = StoryReporter.class.getMethod("afterScenarios", new Class[0]);
            beforeGivenStories = StoryReporter.class.getMethod("beforeGivenStories", new Class[0]);
            givenStories = StoryReporter.class.getMethod("givenStories", GivenStories.class);
            givenStoriesPaths = StoryReporter.class.getMethod("givenStories", List.class);
            afterGivenStories = StoryReporter.class.getMethod("afterGivenStories", new Class[0]);
            beforeExamples = StoryReporter.class.getMethod("beforeExamples", List.class, ExamplesTable.class);
            example = StoryReporter.class.getMethod("example", Map.class, Integer.TYPE);
            afterExamples = StoryReporter.class.getMethod("afterExamples", new Class[0]);
            beforeStep = StoryReporter.class.getMethod("beforeStep", Step.class);
            successful = StoryReporter.class.getMethod("successful", String.class);
            ignorable = StoryReporter.class.getMethod("ignorable", String.class);
            comment = StoryReporter.class.getMethod("comment", String.class);
            pending = StoryReporter.class.getMethod("pending", StepCreator.PendingStep.class);
            pendingDeprecated = StoryReporter.class.getMethod("pending", String.class);
            notPerformed = StoryReporter.class.getMethod("notPerformed", String.class);
            failed = StoryReporter.class.getMethod("failed", String.class, Throwable.class);
            failedOutcomes = StoryReporter.class.getMethod("failedOutcomes", String.class, OutcomesTable.class);
            dryRun = StoryReporter.class.getMethod("dryRun", new Class[0]);
            pendingMethods = StoryReporter.class.getMethod("pendingMethods", List.class);
            restarted = StoryReporter.class.getMethod("restarted", String.class, Throwable.class);
            restartedStory = StoryReporter.class.getMethod("restartedStory", Story.class, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class DelayedMethod {
        private Method method;
        private Object[] args;

        public DelayedMethod(Method method, Object ... args) {
            this.method = method;
            this.args = args;
        }

        public void invoke(StoryReporter delegate) {
            try {
                this.method.invoke((Object)delegate, this.args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("" + this.method, e);
            }
        }
    }
}

