/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.SGRCodes;

public class ANSIConsoleOutput
extends ConsoleOutput {
    private static final char ESCAPE_CHARACTER = '\u001b';
    private static final String SGR_CONTROL = "m";
    private static final String CODE_SEPARATOR = ";";
    private SGRCodes codes = new SGRCodes();

    public ANSIConsoleOutput() {
    }

    public ANSIConsoleOutput(Keywords keywords) {
        super(keywords);
    }

    public ANSIConsoleOutput(Properties outputPatterns, Keywords keywords, boolean reportFailureTrace) {
        super(outputPatterns, keywords, reportFailureTrace);
    }

    public ANSIConsoleOutput assignCode(String key, SGRCodes.SGRCode code) {
        this.codes.assignCode(key, code);
        return this;
    }

    public ANSIConsoleOutput withCodes(SGRCodes codes) {
        this.codes = codes;
        return this;
    }

    @Override
    protected String format(String key, String defaultPattern, Object ... args) {
        String formatted = super.format(key, defaultPattern, args);
        if (this.codes.hasCode(key)) {
            SGRCodes.SGRCode code = this.codes.getCode(key);
            formatted = this.escapeCodeFor(code) + this.highlightParameterValues(formatted, code) + this.escapeCodeFor(SGRCodes.SGRCode.RESET);
        }
        return formatted;
    }

    private String highlightParameterValues(String formatted, SGRCodes.SGRCode code) {
        String valueStart = this.lookupPattern("\uff5f", "\uff5f");
        String valueEnd = this.lookupPattern("\uff60", "\uff60");
        return formatted.replaceAll(valueStart, this.escapeCodeFor(this.highlightCode(), code)).replaceAll(valueEnd, this.escapeCodeFor(SGRCodes.SGRCode.RESET, code));
    }

    private SGRCodes.SGRCode highlightCode() {
        if (this.codes.hasCode("highlight")) {
            return this.codes.getCode("highlight");
        }
        return SGRCodes.SGRCode.UNDERLINE;
    }

    private String escapeCodeFor(SGRCodes.SGRCode code) {
        return this.controlSequenceInitiator((Object)((Object)code) + SGR_CONTROL);
    }

    private String escapeCodeFor(SGRCodes.SGRCode first, SGRCodes.SGRCode second) {
        return this.controlSequenceInitiator((Object)((Object)first) + CODE_SEPARATOR + (Object)((Object)second) + SGR_CONTROL);
    }

    private String controlSequenceInitiator(String code) {
        return "\u001b[" + code;
    }
}

