/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.steps.StepType;

abstract class AbstractRegexParser {
    protected static final String NONE = "";
    private static final String CRLF = "\\r?\\n";
    private final Keywords keywords;

    protected AbstractRegexParser() {
        this(new LocalizedKeywords());
    }

    protected AbstractRegexParser(Keywords keywords) {
        this.keywords = keywords;
    }

    protected Keywords keywords() {
        return this.keywords;
    }

    protected List<String> splitElements(String text, String keyword) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder element = new StringBuilder();
        String[] elementsAsText = text.split(keyword);
        for (int i = 0; i < elementsAsText.length; ++i) {
            String elementAsText = elementsAsText[i];
            element.append(elementAsText);
            if (this.isLastLineNotComment(elementAsText)) {
                AbstractRegexParser.addNonEmptyElement(element.toString(), elements, keyword);
                element = new StringBuilder();
                continue;
            }
            if (i == elementsAsText.length - 1) {
                AbstractRegexParser.addNonEmptyElement(element.toString(), elements, keyword);
                continue;
            }
            element.append(keyword);
        }
        return elements;
    }

    private static void addNonEmptyElement(String elementToAdd, List<String> elements, String keyword) {
        if (elementToAdd.trim().length() > 0) {
            elements.add(keyword + "\n" + elementToAdd);
        }
    }

    private boolean isLastLineNotComment(String elementAsText) {
        String[] elementLines = elementAsText.split(CRLF, -1);
        return !elementLines[elementLines.length - 1].startsWith(this.keywords.ignorable());
    }

    protected String startingWithNL(String text) {
        if (!text.startsWith("\n")) {
            return "\n" + text;
        }
        return text;
    }

    protected List<String> findSteps(String stepsAsText) {
        Matcher matcher = this.findingSteps().matcher(stepsAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Pattern findingSteps() {
        String startingWords = this.concatenateStartingWords();
        return Pattern.compile("((" + startingWords + ")(.*?))(\\Z|" + startingWords + "|\\n" + this.keywords().examplesTable() + ")", 32);
    }

    protected String concatenateStartingWords() {
        List<String> startingWords = Stream.concat(this.keywords().startingWords(stepType -> stepType != StepType.IGNORABLE).map(s -> s + "\\s"), this.keywords().startingWords(stepType -> stepType == StepType.IGNORABLE)).collect(Collectors.toList());
        return this.concatenateWithOr(CRLF, startingWords);
    }

    protected String concatenateWithOr(String beforeKeyword, List<String> keywords) {
        StringBuilder builder = new StringBuilder(beforeKeyword).append("(?:");
        for (String keyword : keywords) {
            builder.append(keyword).append('|');
        }
        if (!keywords.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').toString();
    }
}

