/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStory;

public class GivenStories {
    public static final GivenStories EMPTY = new GivenStories("");
    private final List<GivenStory> stories = new ArrayList<GivenStory>();
    private final String asString;
    private ExamplesTable examplesTable;

    public GivenStories(String asString) {
        this.asString = asString;
        for (String path : asString.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)path)) continue;
            this.stories.add(new GivenStory(path));
        }
    }

    public List<GivenStory> getStories() {
        for (GivenStory story : this.stories) {
            story.useParameters(this.parametersByAnchor(story.getAnchor()));
        }
        return this.stories;
    }

    private Map<String, String> parametersByAnchor(String anchor) {
        int examplesRow = -1;
        if (!StringUtils.isBlank((CharSequence)anchor)) {
            try {
                examplesRow = Integer.parseInt(anchor);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Map<String, String> parameters = null;
        if (examplesRow > -1 && this.examplesTable != null && examplesRow < this.examplesTable.getRowCount()) {
            parameters = this.examplesTable.getRow(examplesRow);
        }
        if (parameters == null) {
            return new HashMap<String, String>();
        }
        return parameters;
    }

    public List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (GivenStory story : this.stories) {
            paths.add(story.asString().trim());
        }
        return Collections.unmodifiableList(paths);
    }

    public boolean requireParameters() {
        for (GivenStory story : this.stories) {
            if (!story.hasAnchorWithExamplesReference()) continue;
            return true;
        }
        return false;
    }

    public void useExamplesTable(ExamplesTable examplesTable) {
        this.examplesTable = examplesTable;
    }

    public String asString() {
        return this.asString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

