/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.List;
import org.jbehave.core.model.ExamplesTable;

public final class ExamplesTableStringBuilder {
    private ExamplesTableStringBuilder() {
    }

    public static String buildExamplesTableString(ExamplesTable.TableProperties properties, List<String> headers, List<List<String>> rows) {
        String headerSeparator = properties.getHeaderSeparator();
        String valueSeparator = properties.getValueSeparator();
        String rowSeparator = properties.getRowSeparator();
        StringBuilder tableBuilder = new StringBuilder();
        headers.forEach(header -> tableBuilder.append(headerSeparator).append((String)header));
        tableBuilder.append(headerSeparator).append(rowSeparator);
        for (List<String> row : rows) {
            int headersSize = headers.size();
            for (int i = 0; i < headersSize; ++i) {
                tableBuilder.append(valueSeparator).append(i < row.size() ? row.get(i) : "");
            }
            tableBuilder.append(valueSeparator).append(rowSeparator);
        }
        return tableBuilder.toString();
    }
}

