/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.junit;

import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.AllStepCandidates;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.junit.JUnit4DescriptionGenerator;
import org.jbehave.core.junit.JUnit4StoryReporter;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnit4StoryRunner
extends BlockJUnit4ClassRunner {
    private final ConfigurableEmbedder configurableEmbedder;
    private final Embedder configuredEmbedder;
    private final Configuration configuration;
    private final Description description;
    private int numberOfTestCases;

    public JUnit4StoryRunner(Class<? extends ConfigurableEmbedder> testClass) throws InitializationError, ReflectiveOperationException {
        super(testClass);
        this.configurableEmbedder = testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.configuredEmbedder = this.configurableEmbedder.configuredEmbedder();
        this.configuration = this.configuredEmbedder.configuration();
        List<String> storyPaths = this.storyPathsFor(this.configurableEmbedder);
        StepMonitor originalStepMonitor = this.configuration.stepMonitor();
        this.configuration.useStepMonitor(new NullStepMonitor());
        List<Description> storyDescriptions = this.buildDescriptionsFromStories(storyPaths);
        this.configuration.useStepMonitor(originalStepMonitor);
        this.description = Description.createSuiteDescription(testClass);
        for (Description storyDescription : storyDescriptions) {
            this.description.addChild(storyDescription);
        }
    }

    private List<String> storyPathsFor(ConfigurableEmbedder configurableEmbedder) {
        if (configurableEmbedder instanceof JUnitStories) {
            return ((JUnitStories)configurableEmbedder).storyPaths();
        }
        throw new IllegalArgumentException("Only ConfigurableEmbedder of type JUnitStories is supported");
    }

    public Description getDescription() {
        return this.description;
    }

    public int testCount() {
        return this.numberOfTestCases;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                JUnit4StoryReporter reporter = new JUnit4StoryReporter(notifier, JUnit4StoryRunner.this.description, JUnit4StoryRunner.this.configuration.keywords());
                reporter.usePendingStepStrategy(JUnit4StoryRunner.this.configuration.pendingStepStrategy());
                JUnit4StoryRunner.this.addToStoryReporterFormats(reporter);
                JUnit4StoryRunner.this.configurableEmbedder.run();
            }
        };
    }

    public static EmbedderControls recommendedControls(Embedder embedder) {
        return embedder.embedderControls().doIgnoreFailureInView(true).doIgnoreFailureInStories(true);
    }

    private List<CandidateSteps> getCandidateSteps() {
        InjectableStepsFactory stepsFactory = this.configurableEmbedder.stepsFactory();
        if (stepsFactory != null) {
            return stepsFactory.createCandidateSteps();
        }
        return this.configuredEmbedder.stepsFactory().createCandidateSteps();
    }

    private void addToStoryReporterFormats(StoryReporter reporter) {
        StoryReporterBuilder storyReporterBuilder = this.configuration.storyReporterBuilder();
        storyReporterBuilder.withFormats(new StoryReporterBuilder.ProvidedFormat(reporter));
    }

    private List<Description> buildDescriptionsFromStories(List<String> storyPaths) {
        List<CandidateSteps> candidateSteps = this.getCandidateSteps();
        AllStepCandidates allStepCandidates = new AllStepCandidates(this.configuration.stepConditionMatcher(), candidateSteps);
        JUnit4DescriptionGenerator descriptionGenerator = new JUnit4DescriptionGenerator(allStepCandidates, this.configuration);
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        this.addSuite(storyDescriptions, "BeforeStories");
        PerformableTree performableTree = this.createPerformableTree(allStepCandidates, storyPaths);
        storyDescriptions.addAll(descriptionGenerator.createDescriptionsFrom(performableTree));
        this.addSuite(storyDescriptions, "AfterStories");
        this.numberOfTestCases += descriptionGenerator.getTestCases();
        return storyDescriptions;
    }

    private PerformableTree createPerformableTree(AllStepCandidates allStepCandidates, List<String> storyPaths) {
        BatchFailures failures = new BatchFailures(this.configuredEmbedder.embedderControls().verboseFailures());
        PerformableTree performableTree = this.configuredEmbedder.performableTree();
        PerformableTree.RunContext context = performableTree.newRunContext(this.configuration, allStepCandidates, this.configuredEmbedder.embedderMonitor(), this.configuredEmbedder.metaFilter(), failures);
        performableTree.addStories(context, this.configuredEmbedder.storyManager().storiesOfPaths(storyPaths));
        return performableTree;
    }

    private void addSuite(List<Description> storyDescriptions, String name) {
        storyDescriptions.add(Description.createTestDescription(Object.class, (String)name));
        ++this.numberOfTestCases;
    }
}

