/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.io.StoryLoader;

public class LoadFromURL
implements ResourceLoader,
StoryLoader {
    private final Charset charset;

    public LoadFromURL() {
        this(StandardCharsets.UTF_8);
    }

    public LoadFromURL(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String loadResourceAsText(String resourcePath) {
        String string;
        block8: {
            InputStream resourceAsStream = this.resourceAsStream(resourcePath);
            try {
                string = IOUtils.toString((InputStream)resourceAsStream, (Charset)this.charset);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception cause) {
                    throw new InvalidStoryResource(resourcePath, cause);
                }
            }
            resourceAsStream.close();
        }
        return string;
    }

    @Override
    public String loadStoryAsText(String storyPath) {
        return this.loadResourceAsText(storyPath);
    }

    protected InputStream resourceAsStream(String resourcePath) throws IOException {
        return new URL(resourcePath).openStream();
    }
}

