/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.failures;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ConcurrentHashMap;

public class BatchFailures
extends ConcurrentHashMap<String, Throwable> {
    private final boolean verbose;

    public BatchFailures() {
        this(false);
    }

    public BatchFailures(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.keySet()) {
            Throwable failure = (Throwable)this.get(name);
            sb.append("\n");
            sb.append(name);
            sb.append(": ");
            sb.append(this.verbose ? this.stackTraceOf(failure) : failure);
        }
        return sb.toString();
    }

    private String stackTraceOf(Throwable failure) {
        StringWriter writer = new StringWriter();
        failure.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

