/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.expressions.ExpressionArguments;
import org.jbehave.core.expressions.ExpressionProcessor;

public class MultiArgExpressionProcessor<T>
implements ExpressionProcessor<T> {
    private static final int ARGS_GROUP = 1;
    private final Pattern pattern;
    private final String expressionName;
    private final int minArgNumber;
    private final int maxArgNumber;
    private final Function<String, ExpressionArguments> argsParser;
    private final Function<List<String>, T> evaluator;

    public MultiArgExpressionProcessor(String expressionName, int minArgNumber, int maxArgNumber, Function<String, ExpressionArguments> argsParser, Function<List<String>, T> evaluator) {
        this.pattern = Pattern.compile("^" + expressionName + "\\((.*)\\)$", 34);
        this.expressionName = expressionName;
        this.minArgNumber = minArgNumber;
        this.maxArgNumber = maxArgNumber;
        this.argsParser = argsParser;
        this.evaluator = evaluator;
    }

    public MultiArgExpressionProcessor(String expressionName, int minArgNumber, int maxArgNumber, Function<List<String>, T> evaluator) {
        this(expressionName, minArgNumber, maxArgNumber, ExpressionArguments::new, evaluator);
    }

    public MultiArgExpressionProcessor(String expressionName, int expectedArgNumber, Function<List<String>, T> evaluator) {
        this(expressionName, expectedArgNumber, expectedArgNumber, evaluator);
    }

    public MultiArgExpressionProcessor(String expressionName, int expectedArgNumber, Function<String, ExpressionArguments> argsParser, Function<List<String>, T> evaluator) {
        this(expressionName, expectedArgNumber, expectedArgNumber, argsParser, evaluator);
    }

    @Override
    public Optional<T> execute(String expression) {
        Matcher expressionMatcher = this.pattern.matcher(expression);
        if (expressionMatcher.find()) {
            List<String> args = this.parseArgs(expressionMatcher.group(1));
            T expressionResult = this.evaluator.apply(args);
            return Optional.of(expressionResult);
        }
        return Optional.empty();
    }

    private List<String> parseArgs(String argsAsString) {
        if (this.minArgNumber == 1 && this.maxArgNumber == 1) {
            return Collections.singletonList(argsAsString);
        }
        List<String> args = this.argsParser.apply(argsAsString).getArguments();
        int argsNumber = args.size();
        if (this.minArgNumber == this.maxArgNumber) {
            if (argsNumber != this.minArgNumber) {
                this.throwException(argsAsString, argsNumber, error -> error.append(this.minArgNumber));
            }
        } else if (argsNumber < this.minArgNumber || argsNumber > this.maxArgNumber) {
            this.throwException(argsAsString, argsNumber, error -> error.append("from ").append(this.minArgNumber).append(" to ").append(this.maxArgNumber));
        }
        return args;
    }

    private void throwException(String argsAsString, int argsNumber, Consumer<StringBuilder> expectationsAppender) {
        StringBuilder errorMessageBuilder = new StringBuilder("The expected number of arguments for '").append(this.expressionName).append("' expression is ");
        expectationsAppender.accept(errorMessageBuilder);
        errorMessageBuilder.append(", but found ").append(argsNumber).append(" argument");
        if (argsNumber != 1) {
            errorMessageBuilder.append('s');
        }
        if (argsNumber > 0) {
            errorMessageBuilder.append(": '").append(argsAsString).append('\'');
        }
        throw new IllegalArgumentException(errorMessageBuilder.toString());
    }
}

