/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.model.Story;

public class StoryTimeouts {
    private static final String COMMA = ",";
    private EmbedderControls embedderControls;
    private EmbedderMonitor embedderMonitor;
    private List<TimeoutParser> parsers = new ArrayList<TimeoutParser>();

    public StoryTimeouts(EmbedderControls embedderControls, EmbedderMonitor embedderMonitor) {
        this.embedderControls = embedderControls;
        this.embedderMonitor = embedderMonitor;
        this.configureDefaultParsers();
    }

    private void configureDefaultParsers() {
        this.parsers.addAll(Arrays.asList(new SimpleTimeoutParser(), new DigitTimeoutParser()));
    }

    public StoryTimeouts withParsers(TimeoutParser ... parsers) {
        this.parsers.addAll(0, Arrays.asList(parsers));
        return this;
    }

    public long getTimeoutInSecs(Story story) {
        Map<String, StoryTimeout> timeouts = this.asMap(this.embedderControls.storyTimeouts());
        for (StoryTimeout timeout : timeouts.values()) {
            if (!timeout.allowedByPath(story.getPath())) continue;
            long timeoutInSecs = timeout.getTimeoutInSecs();
            this.embedderMonitor.usingTimeout(story.getName(), timeoutInSecs);
            return timeoutInSecs;
        }
        for (StoryTimeout timeout : timeouts.values()) {
            if (!timeout.isDefault()) continue;
            long timeoutInSecs = timeout.getTimeoutInSecs();
            this.embedderMonitor.usingTimeout(story.getName(), timeoutInSecs);
            return timeoutInSecs;
        }
        long timeoutInSecs = 300L;
        this.embedderMonitor.usingTimeout(story.getName(), timeoutInSecs);
        return timeoutInSecs;
    }

    private Map<String, StoryTimeout> asMap(String timeoutsAsString) {
        HashMap<String, StoryTimeout> timeouts = new HashMap<String, StoryTimeout>();
        if (StringUtils.isBlank((String)timeoutsAsString)) {
            return timeouts;
        }
        for (String timeoutAsString : timeoutsAsString.split(COMMA)) {
            StoryTimeout timeout = new StoryTimeout(timeoutAsString, this.parsers);
            timeouts.put(timeout.getPathPattern(), timeout);
        }
        return timeouts;
    }

    public static interface TimeoutParser {
        public boolean isValid(String var1);

        public long asSeconds(String var1);
    }

    public static class SimpleTimeoutParser
    implements TimeoutParser {
        private static final String UNIT_PATTERN = "[a-zA-Z]+";
        private static final Pattern TIMEOUT_PATTERN = Pattern.compile("(\\d+)\\s*([a-zA-Z]+)");
        private Map<String, Long> units = new HashMap<String, Long>();

        public SimpleTimeoutParser() {
            this.addUnit("d", 86400L).addUnit("h", 3600L).addUnit("m", 60L).addUnit("s", 1L);
        }

        private SimpleTimeoutParser addUnit(String unit, long value) {
            if (!unit.matches(UNIT_PATTERN)) {
                throw new TimeoutFormatException("Unit '" + unit + "' must be a non-numeric word");
            }
            if (value < 0L) {
                throw new TimeoutFormatException("Unit value '" + value + "' cannot be negative");
            }
            this.units.put(unit, value);
            return this;
        }

        @Override
        public boolean isValid(String timeout) {
            return TIMEOUT_PATTERN.matcher(timeout).find();
        }

        @Override
        public long asSeconds(String timeout) {
            long total = 0L;
            Matcher matcher = TIMEOUT_PATTERN.matcher(timeout);
            while (matcher.find()) {
                long value = Long.parseLong(matcher.group(1));
                String unit = matcher.group(2);
                if (!this.units.containsKey(unit)) {
                    throw new TimeoutFormatException("Unrecognized unit: " + unit);
                }
                total += this.units.get(unit) * value;
            }
            return total;
        }
    }

    public static class DigitTimeoutParser
    implements TimeoutParser {
        private static final Pattern TIMEOUT_PATTERN = Pattern.compile("(\\d+)");

        @Override
        public boolean isValid(String timeout) {
            return TIMEOUT_PATTERN.matcher(timeout).find();
        }

        @Override
        public long asSeconds(String timeout) {
            return Long.parseLong(timeout);
        }
    }

    public static class StoryTimeout {
        private static final String COLON = ":";
        private boolean isDefault;
        private String pathPattern = "";
        private String timeout = "0";
        private String timeoutAsString;
        private List<TimeoutParser> parsers;

        public StoryTimeout(String timeoutAsString, List<TimeoutParser> parsers) {
            this.timeoutAsString = timeoutAsString;
            this.parsers = parsers;
            if (timeoutAsString.contains(COLON)) {
                String[] timeoutByPath = timeoutAsString.split(COLON);
                this.pathPattern = timeoutByPath[0];
                this.timeout = timeoutByPath[1];
            } else {
                this.isDefault = true;
                this.timeout = timeoutAsString;
            }
        }

        public boolean allowedByPath(String path) {
            if (path != null) {
                return path.matches(this.regexOf(this.pathPattern));
            }
            return false;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String getPathPattern() {
            return this.pathPattern;
        }

        public long getTimeoutInSecs() {
            for (TimeoutParser parser : this.parsers) {
                if (!parser.isValid(this.timeout)) continue;
                return parser.asSeconds(this.timeout);
            }
            throw new TimeoutFormatException("No format found for timeout: " + this.timeout);
        }

        public String getTimeoutAsString() {
            return this.timeoutAsString;
        }

        private String regexOf(String pattern) {
            try {
                Pattern.compile(pattern);
                return pattern;
            }
            catch (PatternSyntaxException e) {
                return pattern.replace("*", ".*");
            }
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class TimeoutFormatException
    extends IllegalArgumentException {
        public TimeoutFormatException(String message) {
            super(message);
        }
    }
}

