/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;

public abstract class PrintingEmbedderMonitor
implements EmbedderMonitor {
    @Override
    public void batchFailed(BatchFailures failures) {
        this.print("Failed to run batch %s", failures);
    }

    @Override
    public void beforeOrAfterStoriesFailed() {
        this.print("Failed to run before or after stories steps", new Object[0]);
    }

    @Override
    public void embeddableFailed(String name, Throwable cause) {
        this.print("Failed to run embeddable %s", name);
        this.printStackTrace(cause);
    }

    @Override
    public void embeddableNotConfigurable(String name) {
        this.print("Embeddable %s must be an instance of %s", name, ConfigurableEmbedder.class);
    }

    @Override
    public void embeddablesSkipped(List<String> classNames) {
        this.print("Skipped embeddables %s", classNames);
    }

    @Override
    public void metaExcluded(Meta meta, MetaFilter filter) {
        this.print("%s excluded by filter '%s'", meta, filter.asString());
    }

    @Override
    public void runningEmbeddable(String name) {
        this.print("Running embeddable %s", name);
    }

    @Override
    public void runningStory(String path) {
        this.print("Running story %s", path);
    }

    @Override
    public void storyFailed(String path, Throwable cause) {
        this.print("Failed to run story %s", path);
        this.printStackTrace(cause);
    }

    @Override
    public void storiesSkipped(List<String> storyPaths) {
        this.print("Skipped stories %s", storyPaths);
    }

    @Override
    public void storiesExcluded(List<Story> excluded, MetaFilter filter, boolean verbose) {
        StringBuilder format = new StringBuilder("%d stories excluded by filter: %s%n");
        if (verbose) {
            for (Story story : excluded) {
                format.append(story.getPath()).append("%n");
            }
        }
        this.print(format.toString(), excluded.size(), filter.asString());
    }

    @Override
    public void scenarioExcluded(Scenario scenario, MetaFilter filter) {
        this.print("Scenario '%s' excluded by filter: %s%n", scenario.getTitle(), filter.asString());
    }

    @Override
    public void runningWithAnnotatedEmbedderRunner(String className) {
        this.print("Running with AnnotatedEmbedderRunner '%s'", className);
    }

    @Override
    public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
        this.print("Annotated instance %s if not of type %s", annotatedInstance, type);
    }

    @Override
    public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
        this.print("Generating reports view to '%s' using formats '%s' and view properties '%s'", outputDirectory, formats, viewProperties);
    }

    @Override
    public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
        this.print("Failed to generate reports view to '%s' using formats '%s' and view properties '%s'", outputDirectory, formats, viewProperties);
    }

    @Override
    public void reportsViewGenerated(ReportsCount count) {
        this.print("Reports view generated with %d stories (of which %d pending) containing %d scenarios (of which %d pending)", count.getStories(), count.getStoriesPending(), count.getScenarios(), count.getScenariosPending());
        if (count.getStoriesExcluded() > 0 || count.getScenariosExcluded() > 0) {
            this.print("Meta filters excluded %d stories and  %d scenarios", count.getStoriesExcluded(), count.getScenariosExcluded());
        }
    }

    @Override
    public void reportsViewFailures(ReportsCount count) {
        this.print("Failures in reports view: %d scenarios failed", count.getScenariosFailed());
    }

    @Override
    public void reportsViewNotGenerated() {
        this.print("Reports view not generated", new Object[0]);
    }

    @Override
    public void mappingStory(String storyPath, List<String> metaFilters) {
        this.print("Mapping story %s with meta filters %s", storyPath, metaFilters);
    }

    @Override
    public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
        this.print("Generating maps view to '%s' using story maps '%s' and view properties '%s'", outputDirectory, storyMaps, viewProperties);
    }

    @Override
    public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
        this.print("Failed to generating maps view to '%s' using story maps '%s' and view properties '%s'", outputDirectory, storyMaps, viewProperties);
        this.printStackTrace(cause);
    }

    @Override
    public void processingSystemProperties(Properties properties) {
        this.print("Processing system properties %s", properties);
    }

    @Override
    public void systemPropertySet(String name, String value) {
        this.print("System property '%s' set to '%s'", name, value);
    }

    @Override
    public void storyTimeout(Story story, StoryDuration storyDuration) {
        this.print("Story %s duration of %d seconds has exceeded timeout of %d seconds", story.getPath(), storyDuration.getDurationInSecs(), storyDuration.getTimeoutInSecs());
    }

    @Override
    public void usingThreads(int threads) {
        this.print("Using %d threads", threads);
    }

    @Override
    public void usingExecutorService(ExecutorService executorService) {
        this.print("Using executor service %s", executorService);
    }

    @Override
    public void usingControls(EmbedderControls embedderControls) {
        this.print("Using controls %s", embedderControls);
    }

    @Override
    public void invalidTimeoutFormat(String path) {
        this.print("Failed to set specific story timeout for story %s because 'storyTimeoutInSecsByPath' has incorrect format", path);
        this.print("'storyTimeoutInSecsByPath' must be a CSV of regex expressions matching story paths. E.g. \"*/long/*.story:5000,*/short/*.story:200\"", new Object[0]);
    }

    @Override
    public void usingTimeout(String path, long timeout) {
        this.print("Using timeout for story %s of %d secs.", path, timeout);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected abstract void print(String var1, Object ... var2);

    protected abstract void printStackTrace(Throwable var1);
}

