/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.AllStepCandidates;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MatchingStepMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.IgnoringStepsFailure;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.PendingStepsFound;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.RestartingStoryFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.ConcurrentStoryReporter;
import org.jbehave.core.reporters.DelegatingStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.PendingStepMethodGenerator;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;
import org.jbehave.core.steps.Timing;
import org.jbehave.core.steps.context.StepsContext;

public class PerformableTree {
    private static final Map<String, String> NO_PARAMETERS = new HashMap<String, String>();
    private PerformableRoot root = new PerformableRoot();

    public PerformableRoot getRoot() {
        return this.root;
    }

    public void addStories(RunContext context, List<Story> stories) {
        this.root.addBeforeSteps(context.beforeStoriesSteps());
        for (Story story : stories) {
            this.root.add(this.performableStory(context, story, NO_PARAMETERS));
        }
        this.root.addAfterSteps(context.afterStoriesSteps());
    }

    private PerformableStory performableStory(RunContext context, Story story, Map<String, String> storyParameters) {
        PerformableStory performableStory = new PerformableStory(story, context.configuration().keywords(), context.givenStory());
        FilteredStory filteredStory = context.filter(story);
        Meta storyMeta = story.getMeta();
        boolean storyExcluded = filteredStory.excluded();
        performableStory.excluded(storyExcluded);
        if (!storyExcluded) {
            Map lifecycleSteps = context.lifecycleSteps(story.getLifecycle(), storyMeta, Scope.STORY);
            performableStory.addBeforeSteps(Lifecycle.ExecutionType.SYSTEM, context.beforeStorySteps(storyMeta));
            performableStory.addBeforeSteps(Lifecycle.ExecutionType.USER, (PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.BEFORE));
            performableStory.addAll(this.performableScenarios(context, story, storyParameters, filteredStory));
            if (performableStory.hasIncludedScenarios()) {
                HashMap<String, String> givenStoryParameters = new HashMap<String, String>(storyParameters);
                this.addMetaParameters(givenStoryParameters, storyMeta);
                performableStory.setGivenStories(this.performableGivenStories(context, story.getGivenStories(), givenStoryParameters));
            }
            performableStory.addAfterSteps(Lifecycle.ExecutionType.USER, (PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.AFTER));
            performableStory.addAfterSteps(Lifecycle.ExecutionType.SYSTEM, context.afterStorySteps(storyMeta));
        }
        return performableStory;
    }

    private List<PerformableScenario> performableScenarios(RunContext context, Story story, Map<String, String> storyParameters, FilteredStory filterContext) {
        List<Map<String, String>> storyExamplesTableRows;
        ArrayList<PerformableScenario> performableScenarios = new ArrayList<PerformableScenario>();
        ExamplesTable storyExamplesTable = story.getLifecycle().getExamplesTable();
        if (storyExamplesTable.isEmpty()) {
            storyExamplesTableRows = new ArrayList<Map<String, String>>();
            storyExamplesTableRows.add(new HashMap());
        } else {
            storyExamplesTableRows = storyExamplesTable.getRows();
        }
        boolean runBeforeAndAfterScenarioSteps = this.shouldRunBeforeOrAfterScenarioSteps(context);
        for (Map<String, String> storyExamplesTableRow : storyExamplesTableRows) {
            for (Map.Entry<String, String> entry : storyExamplesTableRow.entrySet()) {
                entry.setValue((String)context.configuration().parameterConverters().convert(entry.getValue(), (Type)((Object)String.class)));
            }
        }
        for (int i = 0; i < storyExamplesTableRows.size(); ++i) {
            Map<String, String> storyExamplesTableRow;
            storyExamplesTableRow = storyExamplesTableRows.get(i);
            Iterator<Object> iterator = story.getScenarios().iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> scenarioParameters = new HashMap<String, String>(storyParameters);
                Scenario scenario = (Scenario)iterator.next();
                PerformableScenario performableScenario = this.performableScenario(context, story, scenarioParameters, filterContext, runBeforeAndAfterScenarioSteps, scenario, storyExamplesTableRow, storyExamplesTable.isEmpty() ? -1 : i);
                if (!performableScenario.isPerformable()) continue;
                performableScenarios.add(performableScenario);
            }
        }
        return performableScenarios;
    }

    private PerformableScenario performableScenario(RunContext context, Story story, Map<String, String> storyParameters, FilteredStory filterContext, boolean runBeforeAndAfterScenarioSteps, Scenario originalScenario, Map<String, String> storyExamplesTableRow, int storyExamplesTableRowIndex) {
        Scenario scenario = originalScenario;
        if (storyExamplesTableRowIndex != -1) {
            scenario = new Scenario(scenario.getTitle() + " [" + (storyExamplesTableRowIndex + 1) + "]", scenario.getMeta(), scenario.getGivenStories(), scenario.getExamplesTable(), scenario.getSteps());
        }
        PerformableScenario performableScenario = new PerformableScenario(scenario, story.getPath());
        if (context.failureOccurred() && context.configuration().storyControls().skipScenariosAfterFailure()) {
            return performableScenario;
        }
        boolean scenarioExcluded = filterContext.excluded(originalScenario);
        performableScenario.excluded(scenarioExcluded);
        if (!scenarioExcluded) {
            Meta storyAndScenarioMeta = scenario.getMeta().inheritFrom(story.getMeta());
            if (this.isParameterisedByExamples(scenario)) {
                ExamplesTable table = scenario.getExamplesTable();
                List<Map<String, String>> tableRows = table.getRows();
                for (int exampleIndex = 0; exampleIndex < tableRows.size(); ++exampleIndex) {
                    Map<String, String> scenarioParameters = tableRows.get(exampleIndex);
                    HashMap<String, String> scenarioParametersCopy = new HashMap<String, String>(storyParameters);
                    scenarioParametersCopy.putAll(storyExamplesTableRow);
                    scenarioParametersCopy.putAll(scenarioParameters);
                    for (Map.Entry entry : scenarioParametersCopy.entrySet()) {
                        String value = context.configuration().parameterControls().replaceAllDelimitedNames((String)entry.getValue(), storyExamplesTableRow);
                        entry.setValue((String)context.configuration().parameterConverters().convert(value, (Type)((Object)String.class)));
                    }
                    LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(scenarioParametersCopy);
                    for (Map.Entry<String, String> storyExamplesTableRowEntry : storyExamplesTableRow.entrySet()) {
                        String key = storyExamplesTableRowEntry.getKey();
                        if (parameters.containsKey(key)) continue;
                        parameters.put(key, storyExamplesTableRowEntry.getValue());
                    }
                    this.addExampleScenario(context, scenario, performableScenario, story, storyAndScenarioMeta, parameters, exampleIndex);
                }
            } else if (!storyExamplesTableRow.isEmpty()) {
                this.addExampleScenario(context, scenario, performableScenario, story, storyAndScenarioMeta, new HashMap<String, String>(storyExamplesTableRow), -1);
            } else {
                NormalPerformableScenario normalScenario = this.normalScenario(context, story, scenario, storyAndScenarioMeta, storyParameters);
                if (runBeforeAndAfterScenarioSteps) {
                    normalScenario.addBeforeSteps(Lifecycle.ExecutionType.SYSTEM, context.beforeScenarioSteps(storyAndScenarioMeta, ScenarioType.NORMAL));
                }
                performableScenario.useNormalScenario(normalScenario);
                if (runBeforeAndAfterScenarioSteps) {
                    normalScenario.addAfterSteps(Lifecycle.ExecutionType.SYSTEM, context.afterScenarioSteps(storyAndScenarioMeta, ScenarioType.NORMAL));
                }
            }
        }
        return performableScenario;
    }

    private void addExampleScenario(RunContext context, Scenario scenario, PerformableScenario performableScenario, Story story, Meta storyAndScenarioMeta, Map<String, String> parameters, int exampleIndex) {
        Meta exampleScenarioMeta = this.parameterMeta(context, parameters).inheritFrom(storyAndScenarioMeta);
        if (!context.filter().excluded(exampleScenarioMeta)) {
            ExamplePerformableScenario exampleScenario = this.exampleScenario(context, story, scenario, storyAndScenarioMeta, parameters, exampleIndex);
            performableScenario.addExampleScenario(exampleScenario);
        }
    }

    private NormalPerformableScenario normalScenario(RunContext context, Story story, Scenario scenario, Meta storyAndScenarioMeta, Map<String, String> storyParameters) {
        NormalPerformableScenario normalScenario = new NormalPerformableScenario(story);
        normalScenario.setStoryAndScenarioMeta(storyAndScenarioMeta);
        this.addStepsWithLifecycle(normalScenario, context, story.getLifecycle(), storyParameters, scenario, storyAndScenarioMeta);
        return normalScenario;
    }

    private ExamplePerformableScenario exampleScenario(RunContext context, Story story, Scenario scenario, Meta storyAndScenarioMeta, Map<String, String> parameters, int exampleIndex) {
        ExamplePerformableScenario exampleScenario = new ExamplePerformableScenario(story, parameters, exampleIndex);
        exampleScenario.setStoryAndScenarioMeta(storyAndScenarioMeta);
        exampleScenario.addBeforeSteps(Lifecycle.ExecutionType.SYSTEM, context.beforeScenarioSteps(storyAndScenarioMeta, ScenarioType.EXAMPLE));
        this.addStepsWithLifecycle(exampleScenario, context, story.getLifecycle(), parameters, scenario, storyAndScenarioMeta);
        exampleScenario.addAfterSteps(Lifecycle.ExecutionType.SYSTEM, context.afterScenarioSteps(storyAndScenarioMeta, ScenarioType.EXAMPLE));
        return exampleScenario;
    }

    private Meta parameterMeta(RunContext context, Map<String, String> parameters) {
        Meta meta = Meta.EMPTY;
        Keywords keywords = context.configuration().keywords();
        String metaText = keywords.meta();
        if (parameters.containsKey(metaText)) {
            meta = Meta.createMeta(parameters.get(metaText), keywords);
        }
        return meta;
    }

    private void addStepsWithLifecycle(AbstractPerformableScenario performableScenario, RunContext context, Lifecycle lifecycle, Map<String, String> parameters, Scenario scenario, Meta storyAndScenarioMeta) {
        Map lifecycleSteps = context.lifecycleSteps(lifecycle, storyAndScenarioMeta, Scope.SCENARIO);
        performableScenario.addBeforeSteps(Lifecycle.ExecutionType.SYSTEM, context.beforeScenarioSteps(storyAndScenarioMeta, ScenarioType.ANY));
        performableScenario.addBeforeSteps(Lifecycle.ExecutionType.USER, (PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.BEFORE));
        this.addMetaParameters(parameters, storyAndScenarioMeta);
        performableScenario.setGivenStories(this.performableGivenStories(context, scenario.getGivenStories(), parameters));
        performableScenario.addSteps(context.scenarioSteps(lifecycle, storyAndScenarioMeta, scenario, parameters));
        performableScenario.addAfterSteps(Lifecycle.ExecutionType.USER, (PerformableSteps)lifecycleSteps.get((Object)StepCollector.Stage.AFTER));
        performableScenario.addAfterSteps(Lifecycle.ExecutionType.SYSTEM, context.afterScenarioSteps(storyAndScenarioMeta, ScenarioType.ANY));
    }

    private PerformableGivenStories performableGivenStories(RunContext context, GivenStories givenStories, Map<String, String> parameters) {
        ArrayList<PerformableStory> stories = new ArrayList<PerformableStory>();
        if (givenStories.getPaths().size() > 0) {
            for (GivenStory givenStory : givenStories.getStories()) {
                RunContext childContext = context.childContextFor(givenStory);
                Story story = this.storyOfPath(context.configuration(), childContext.path());
                if (givenStory.hasAnchorParameters()) {
                    story = this.storyWithMatchingScenarios(story, givenStory.getAnchorParameters());
                }
                parameters.putAll(givenStory.getParameters());
                stories.add(this.performableStory(childContext, story, parameters));
            }
        }
        return new PerformableGivenStories(stories, givenStories);
    }

    private Story storyWithMatchingScenarios(Story story, Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return story;
        }
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        for (Scenario scenario : story.getScenarios()) {
            if (!this.matchesParameters(scenario, parameters)) continue;
            scenarios.add(scenario);
        }
        return story.cloneWithScenarios(scenarios);
    }

    private boolean matchesParameters(Scenario scenario, Map<String, String> parameters) {
        Meta meta = scenario.getMeta();
        for (String name : parameters.keySet()) {
            if (!meta.hasProperty(name)) continue;
            return meta.getProperty(name).equals(parameters.get(name));
        }
        return false;
    }

    public Story storyOfPath(Configuration configuration, String storyPath) {
        String storyAsText = configuration.storyLoader().loadStoryAsText(storyPath);
        return configuration.storyParser().parseStory(storyAsText, storyPath);
    }

    public Story storyOfText(Configuration configuration, String storyAsText, String storyId) {
        return configuration.storyParser().parseStory(storyAsText, storyId);
    }

    private void addMetaParameters(Map<String, String> storyParameters, Meta meta) {
        for (String name : meta.getPropertyNames()) {
            if (storyParameters.containsKey(name)) continue;
            storyParameters.put(name, meta.getProperty(name));
        }
    }

    private boolean shouldRunBeforeOrAfterScenarioSteps(RunContext context) {
        return !context.configuration().storyControls().skipBeforeAndAfterScenarioStepsIfGivenStory() || !context.givenStory();
    }

    private boolean isParameterisedByExamples(Scenario scenario) {
        return !scenario.getExamplesTable().isEmpty() && !scenario.getGivenStories().requireParameters();
    }

    public void perform(RunContext context, Story story) {
        boolean restartingStory = false;
        try {
            this.performCancellable(context, story);
            if (context.restartStory()) {
                context.reporter().restartedStory(story, context.failure(context.state()));
                restartingStory = true;
                this.perform(context, story);
            }
        }
        catch (InterruptedException e) {
            if (context.isCancelled(story)) {
                context.reporter().storyCancelled(story, context.storyDuration(story));
                context.reporter().afterStory(context.givenStory);
            }
            throw new UUIDExceptionWrapper(e);
        }
        finally {
            if (!context.givenStory() && !restartingStory) {
                this.invokeDelayedReporters(context.reporter());
            }
        }
    }

    private void performCancellable(RunContext context, Story story) throws InterruptedException {
        if (context.configuration().storyControls().resetStateBeforeStory()) {
            context.resetState();
            context.resetFailures(story);
        }
        if (!story.getPath().equals(context.path())) {
            context.currentPath(story.getPath());
        }
        if (context.configuration.dryRun()) {
            context.reporter().dryRun();
        }
        this.root.get(story).perform(context);
        if (context.failureOccurred()) {
            context.addFailure(story);
        }
    }

    public void performBeforeOrAfterStories(RunContext context, StepCollector.Stage stage) {
        String storyPath = StringUtils.capitalize((String)stage.name().toLowerCase()) + "Stories";
        context.currentPath(storyPath);
        context.reporter().beforeStoriesSteps(stage);
        try {
            (stage == StepCollector.Stage.BEFORE ? this.root.beforeSteps : this.root.afterSteps).perform(context, false);
        }
        catch (InterruptedException e) {
            throw new UUIDExceptionWrapper(e);
        }
        finally {
            context.reporter().afterStoriesSteps(stage);
            this.invokeDelayedReporters(context.reporter());
        }
    }

    private void invokeDelayedReporters(StoryReporter reporter) {
        if (reporter instanceof ConcurrentStoryReporter) {
            ((ConcurrentStoryReporter)reporter).invokeDelayed();
        } else if (reporter instanceof DelegatingStoryReporter) {
            for (StoryReporter delegate : ((DelegatingStoryReporter)reporter).getDelegates()) {
                this.invokeDelayedReporters(delegate);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public RunContext newRunContext(Configuration configuration, AllStepCandidates allStepCandidates, EmbedderMonitor embedderMonitor, MetaFilter filter, BatchFailures failures) {
        return new RunContext(configuration, allStepCandidates, embedderMonitor, filter, failures);
    }

    public static class PerformableRoot {
        private PerformableSteps beforeSteps = new PerformableSteps();
        private Map<String, PerformableStory> stories = new LinkedHashMap<String, PerformableStory>();
        private PerformableSteps afterSteps = new PerformableSteps();

        public void addBeforeSteps(PerformableSteps beforeSteps) {
            this.beforeSteps = beforeSteps;
        }

        public void add(PerformableStory performableStory) {
            this.stories.put(performableStory.getStory().getPath(), performableStory);
        }

        public void addAfterSteps(PerformableSteps afterSteps) {
            this.afterSteps = afterSteps;
        }

        public PerformableStory get(Story story) {
            PerformableStory performableStory = this.stories.get(story.getPath());
            if (performableStory != null) {
                return performableStory;
            }
            throw new RuntimeException("No performable story for path " + story.getPath());
        }

        public List<PerformableStory> getStories() {
            return new ArrayList<PerformableStory>(this.stories.values());
        }
    }

    public static class RunContext {
        private final Configuration configuration;
        private final boolean givenStory;
        private final AllStepCandidates allStepCandidates;
        private final EmbedderMonitor embedderMonitor;
        private final MetaFilter filter;
        private final BatchFailures failures;
        private final StepsContext stepsContext;
        private final Map<Story, StoryDuration> cancelledStories = new HashMap<Story, StoryDuration>();
        private final Map<String, List<StepCreator.PendingStep>> pendingStories = new HashMap<String, List<StepCreator.PendingStep>>();
        private final ThreadLocal<StoryRunContext> storyRunContext = ThreadLocal.withInitial(() -> new StoryRunContext());

        public RunContext(Configuration configuration, AllStepCandidates allStepCandidates, EmbedderMonitor embedderMonitor, MetaFilter filter, BatchFailures failures) {
            this(configuration, allStepCandidates, embedderMonitor, filter, failures, false);
        }

        private RunContext(Configuration configuration, AllStepCandidates allStepCandidates, EmbedderMonitor embedderMonitor, MetaFilter filter, BatchFailures failures, boolean givenStory) {
            this.configuration = configuration;
            this.givenStory = givenStory;
            this.allStepCandidates = allStepCandidates;
            this.embedderMonitor = embedderMonitor;
            this.filter = filter;
            this.failures = failures;
            this.stepsContext = configuration.stepsContext();
            this.resetState();
        }

        public StepsContext stepsContext() {
            return this.stepsContext;
        }

        public boolean restartScenario() {
            for (Throwable cause = this.failure(this.state()); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RestartingScenarioFailure)) continue;
                return true;
            }
            return false;
        }

        public boolean restartStory() {
            for (Throwable cause = this.failure(this.state()); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RestartingStoryFailure)) continue;
                return true;
            }
            return false;
        }

        public void currentPath(String path) {
            this.currentRunContext().pathIs(path);
            this.currentRunContext().reporterIs(this.configuration.storyReporter(path));
        }

        public void interruptIfCancelled() throws InterruptedException {
            for (Story story : this.cancelledStories.keySet()) {
                if (!this.path().equals(story.getPath())) continue;
                throw new InterruptedException(this.path());
            }
        }

        public boolean dryRun() {
            return this.configuration.storyControls().dryRun();
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public String path() {
            return this.currentRunContext().path();
        }

        public FilteredStory filter(Story story) {
            return new FilteredStory(this.filter, story, this.configuration.storyControls(), this.givenStory());
        }

        public MetaFilter filter() {
            return this.filter;
        }

        public PerformableSteps beforeStoriesSteps() {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStoriesSteps(this.allStepCandidates.getBeforeStoriesSteps()));
        }

        public PerformableSteps afterStoriesSteps() {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStoriesSteps(this.allStepCandidates.getAfterStoriesSteps()));
        }

        public PerformableSteps beforeStorySteps(Meta storyMeta) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStorySteps(this.allStepCandidates.getBeforeStorySteps(this.givenStory), storyMeta));
        }

        public PerformableSteps afterStorySteps(Meta storyMeta) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeOrAfterStorySteps(this.allStepCandidates.getAfterStorySteps(this.givenStory), storyMeta));
        }

        public PerformableSteps beforeScenarioSteps(Meta storyAndScenarioMeta, ScenarioType type) {
            return new PerformableSteps(this.configuration.stepCollector().collectBeforeScenarioSteps(this.allStepCandidates.getBeforeScenarioSteps(type), storyAndScenarioMeta));
        }

        public PerformableSteps afterScenarioSteps(Meta storyAndScenarioMeta, ScenarioType type) {
            return new PerformableSteps(this.configuration.stepCollector().collectAfterScenarioSteps(this.allStepCandidates.getAfterScenarioSteps(type), storyAndScenarioMeta));
        }

        private Map<StepCollector.Stage, PerformableSteps> lifecycleSteps(Lifecycle lifecycle, Meta meta, Scope scope) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            Map<StepCollector.Stage, List<Step>> steps = this.configuration.stepCollector().collectLifecycleSteps(this.allStepCandidates.getRegularSteps(), lifecycle, meta, scope, monitor);
            EnumMap<StepCollector.Stage, PerformableSteps> performableSteps = new EnumMap<StepCollector.Stage, PerformableSteps>(StepCollector.Stage.class);
            for (Map.Entry<StepCollector.Stage, List<Step>> entry : steps.entrySet()) {
                performableSteps.put(entry.getKey(), new PerformableSteps(entry.getValue(), monitor.matched()));
            }
            return performableSteps;
        }

        private PerformableSteps scenarioSteps(Lifecycle lifecycle, Meta meta, Scenario scenario, Map<String, String> parameters) {
            MatchingStepMonitor monitor = new MatchingStepMonitor(this.configuration.stepMonitor());
            StepCollector stepCollector = this.configuration.stepCollector();
            Map<StepCollector.Stage, List<Step>> beforeOrAfterStepSteps = stepCollector.collectLifecycleSteps(this.allStepCandidates.getRegularSteps(), lifecycle, meta, Scope.STEP, monitor);
            LinkedList<Step> steps = new LinkedList<Step>();
            for (Step step : stepCollector.collectScenarioSteps(this.allStepCandidates.getRegularSteps(), scenario, parameters, monitor)) {
                steps.addAll((Collection<Step>)beforeOrAfterStepSteps.get((Object)StepCollector.Stage.BEFORE));
                steps.add(step);
                steps.addAll((Collection<Step>)beforeOrAfterStepSteps.get((Object)StepCollector.Stage.AFTER));
            }
            return new PerformableSteps(steps, monitor.matched());
        }

        public RunContext childContextFor(GivenStory givenStory) {
            RunContext child = new RunContext(this.configuration, this.allStepCandidates, this.embedderMonitor, this.filter, this.failures, true);
            child.currentRunContext().pathIs(this.configuration.pathCalculator().calculate(this.path(), givenStory.getPath()));
            return child;
        }

        public void cancelStory(Story story, StoryDuration storyDuration) {
            this.cancelledStories.put(story, storyDuration);
        }

        public boolean isCancelled(Story story) {
            return this.cancelledStories.containsKey(story);
        }

        public StoryDuration storyDuration(Story story) {
            return this.cancelledStories.get(story);
        }

        public State state() {
            return this.currentRunContext().state();
        }

        public void stateIs(State state) {
            this.currentRunContext().stateIs(state);
        }

        public boolean failureOccurred() {
            return this.failed(this.state());
        }

        public void resetState() {
            this.currentRunContext().resetState();
        }

        public void resetFailures() {
            this.failures.clear();
        }

        public void resetFailures(Story story) {
            this.failures.entrySet().removeIf(entry -> ((String)entry.getKey()).equals(this.toBatchFailuresKey(story, (Throwable)entry.getValue())));
        }

        public StoryReporter reporter() {
            return this.currentRunContext().reporter();
        }

        public boolean failed(State state) {
            return !state.getClass().equals(FineSoFar.class);
        }

        public Throwable failure(State state) {
            if (this.failed(state)) {
                return state.getFailure().getCause();
            }
            return null;
        }

        public void addFailure(Story story) {
            this.addFailure(story, this.failure(this.state()));
        }

        public void addFailure(Story story, Throwable cause) {
            if (cause != null) {
                this.failures.put(this.toBatchFailuresKey(story, cause), cause);
            }
        }

        public void pendingSteps(List<StepCreator.PendingStep> pendingSteps) {
            if (!pendingSteps.isEmpty()) {
                this.pendingStories.put(this.path(), pendingSteps);
            }
        }

        public boolean hasPendingSteps() {
            return this.pendingStories.containsKey(this.path());
        }

        public boolean isStoryPending() {
            return this.pendingStories.containsKey(this.path());
        }

        public boolean hasFailed() {
            return this.failed(this.state());
        }

        public Status status(State initial) {
            if (this.isStoryPending()) {
                return Status.PENDING;
            }
            if (this.failed(initial)) {
                return Status.NOT_PERFORMED;
            }
            return this.hasFailed() ? Status.FAILED : Status.SUCCESSFUL;
        }

        public MetaFilter getFilter() {
            return this.filter;
        }

        public BatchFailures getFailures() {
            return this.failures;
        }

        public EmbedderMonitor embedderMonitor() {
            return this.embedderMonitor;
        }

        private StoryRunContext currentRunContext() {
            return this.storyRunContext.get();
        }

        private String toBatchFailuresKey(Story story, Throwable cause) {
            return String.format("%s@%s", story.getPath(), Integer.toHexString(cause.hashCode()));
        }
    }

    public static class PerformableSteps
    implements ReportingFailures {
        private final transient List<Step> steps;
        private final transient List<StepCreator.PendingStep> pendingSteps;
        private List<MatchingStepMonitor.StepMatch> matches;
        private List<StepResult> results;

        public PerformableSteps() {
            this(null);
        }

        public PerformableSteps(List<Step> steps) {
            this(steps, null);
        }

        public PerformableSteps(List<Step> steps, List<MatchingStepMonitor.StepMatch> stepMatches) {
            this.steps = steps != null ? steps : new ArrayList();
            this.pendingSteps = this.pendingSteps();
            this.matches = stepMatches;
        }

        public void add(PerformableSteps performableSteps) {
            this.steps.addAll(performableSteps.steps);
            this.pendingSteps.addAll(performableSteps.pendingSteps);
            if (performableSteps.matches != null) {
                if (this.matches == null) {
                    this.matches = new ArrayList<MatchingStepMonitor.StepMatch>();
                }
                this.matches.addAll(performableSteps.matches);
            }
        }

        public void perform(RunContext context, boolean interruptIfCancelled) throws InterruptedException {
            State state;
            if (this.steps.size() == 0) {
                return;
            }
            Keywords keywords = context.configuration().keywords();
            State originalState = state = context.state();
            StoryReporter reporter = context.reporter();
            this.results = new ArrayList<StepResult>();
            for (Step step : this.steps) {
                try {
                    if (interruptIfCancelled) {
                        context.interruptIfCancelled();
                    }
                    state = state.run(step, this.results, keywords, reporter);
                }
                catch (RestartingScenarioFailure e) {
                    reporter.restarted(step.asString(keywords), e);
                    throw e;
                }
            }
            context.stateIs(state instanceof Ignoring ? originalState : state);
            context.pendingSteps(this.pendingSteps);
            this.generatePendingStepMethods(context, this.pendingSteps);
        }

        @Override
        public void reportFailures(FailureContext context) {
            if (this.results == null) {
                return;
            }
            for (StepResult result : this.results) {
                if (!(result instanceof AbstractStepResult.Failed)) continue;
                context.addFailure(result.getFailure());
            }
        }

        private List<StepCreator.PendingStep> pendingSteps() {
            ArrayList<StepCreator.PendingStep> pending = new ArrayList<StepCreator.PendingStep>();
            for (Step step : this.steps) {
                if (!(step instanceof StepCreator.PendingStep)) continue;
                pending.add((StepCreator.PendingStep)step);
            }
            return pending;
        }

        private void generatePendingStepMethods(RunContext context, List<StepCreator.PendingStep> pendingSteps) {
            if (!pendingSteps.isEmpty()) {
                PendingStepMethodGenerator generator = new PendingStepMethodGenerator(context.configuration().keywords());
                ArrayList<String> methods = new ArrayList<String>();
                for (StepCreator.PendingStep pendingStep : pendingSteps) {
                    if (pendingStep.annotated()) continue;
                    String generatedMethod = generator.generateMethod(pendingStep);
                    pendingStep.setPendingMethod(generatedMethod);
                    methods.add(generatedMethod);
                }
                context.reporter().pendingMethods(methods);
                if (context.configuration().pendingStepStrategy() instanceof FailingUponPendingStep) {
                    throw new PendingStepsFound(pendingSteps);
                }
            }
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class PerformableStory
    extends PerformableEntity {
        private final Story story;
        private final transient Keywords keywords;
        private final boolean givenStory;
        private boolean excluded;
        private Status status;
        private Timing timing = new Timing();
        private List<PerformableScenario> scenarios = new ArrayList<PerformableScenario>();

        public PerformableStory(Story story, Keywords keywords, boolean givenStory) {
            super(StoryReporter::beforeStorySteps, StoryReporter::afterStorySteps);
            this.story = story;
            this.keywords = keywords;
            this.givenStory = givenStory;
        }

        public void excluded(boolean excluded) {
            this.excluded = excluded;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public Story getStory() {
            return this.story;
        }

        public Keywords getKeywords() {
            return this.keywords;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public Status getStatus() {
            return this.status;
        }

        public Timing getTiming() {
            return this.timing;
        }

        public void add(PerformableScenario performableScenario) {
            this.scenarios.add(performableScenario);
        }

        public void addAll(List<PerformableScenario> performableScenarios) {
            this.scenarios.addAll(performableScenarios);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (this.isExcluded()) {
                context.reporter().storyExcluded(this.story, context.filter.asString());
                this.status = Status.EXCLUDED;
            }
            Timer timer = new Timer().start();
            try {
                context.stepsContext().resetStory();
                context.reporter().beforeStory(this.story, this.givenStory);
                context.reporter().narrative(this.story.getNarrative());
                context.reporter().lifecycle(this.story.getLifecycle());
                State state = context.state();
                this.performBeforeSteps(context);
                this.getGivenStories().perform(context);
                this.performWithStopExecutionExceptionHandling((FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
                    if (!context.failureOccurred() || !context.configuration().storyControls().skipStoryIfGivenStoryFailed()) {
                        context.reporter().beforeScenarios();
                        for (PerformableScenario scenario : this.scenarios) {
                            scenario.perform(context);
                        }
                    }
                }), (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
                    context.reporter().afterScenarios();
                    this.performAfterSteps(context);
                }));
                context.configuration().storyControls().resetCurrentStoryControls();
                if (context.restartStory()) {
                    context.reporter().afterStory(true);
                } else {
                    context.reporter().afterStory(this.givenStory);
                }
                this.status = context.status(state);
            }
            finally {
                this.timing = new Timing(timer.stop());
            }
        }

        @Override
        public void reportFailures(FailureContext context) {
            for (PerformableScenario scenario : this.scenarios) {
                scenario.reportFailures(context);
            }
        }

        public List<PerformableScenario> getScenarios() {
            return this.scenarios;
        }

        public boolean hasIncludedScenarios() {
            return this.getScenarios().stream().anyMatch(scenario -> !scenario.isExcluded());
        }
    }

    public static class PerformableGivenStories
    implements Performable {
        private final List<PerformableStory> performableGivenStories;
        private final GivenStories givenStories;

        public PerformableGivenStories(List<PerformableStory> performableGivenStories, GivenStories givenStories) {
            this.performableGivenStories = performableGivenStories;
            this.givenStories = givenStories;
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (this.performableGivenStories.size() > 0) {
                StoryReporter storyReporter = context.reporter();
                storyReporter.beforeGivenStories();
                storyReporter.givenStories(this.givenStories);
                for (PerformableStory story : this.performableGivenStories) {
                    story.perform(context);
                }
                storyReporter.afterGivenStories();
            }
        }

        @Override
        public void reportFailures(FailureContext context) {
        }
    }

    public static class PerformableScenario
    implements Performable {
        private final Scenario scenario;
        private final String storyPath;
        private boolean excluded;
        private Status status;
        private Timing timing = new Timing();
        private NormalPerformableScenario normalScenario;
        private List<ExamplePerformableScenario> exampleScenarios;

        public PerformableScenario(Scenario scenario, String storyPath) {
            this.scenario = scenario;
            this.storyPath = storyPath;
        }

        public void useNormalScenario(NormalPerformableScenario normalScenario) {
            this.normalScenario = normalScenario;
        }

        public void addExampleScenario(ExamplePerformableScenario exampleScenario) {
            if (this.exampleScenarios == null) {
                this.exampleScenarios = new ArrayList<ExamplePerformableScenario>();
            }
            this.exampleScenarios.add(exampleScenario);
        }

        public void excluded(boolean excluded) {
            this.excluded = excluded;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public Status getStatus() {
            return this.status;
        }

        public Timing getTiming() {
            return this.timing;
        }

        public Scenario getScenario() {
            return this.scenario;
        }

        public String getStoryPath() {
            return this.storyPath;
        }

        public Throwable getFailure() {
            FailureContext context = new FailureContext();
            this.reportFailures(context);
            List<Throwable> failures = context.getFailures();
            if (failures.size() > 0) {
                return failures.get(0);
            }
            return null;
        }

        public boolean hasNormalScenario() {
            return this.normalScenario != null;
        }

        public boolean hasExamples() {
            return this.exampleScenarios != null && this.exampleScenarios.size() > 0;
        }

        public boolean isPerformable() {
            return this.hasNormalScenario() || this.hasExamples() || this.isExcluded();
        }

        public List<ExamplePerformableScenario> getExamples() {
            return this.exampleScenarios;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform(RunContext context) throws InterruptedException {
            if (this.isExcluded()) {
                context.embedderMonitor().scenarioExcluded(this.scenario, context.filter());
                return;
            }
            Timer timer = new Timer().start();
            try {
                context.stepsContext().resetScenario();
                context.reporter().beforeScenario(this.scenario);
                State state = context.state();
                if (this.hasExamples()) {
                    context.reporter().beforeExamples(this.scenario.getSteps(), this.scenario.getExamplesTable());
                    for (ExamplePerformableScenario exampleScenario : this.exampleScenarios) {
                        exampleScenario.perform(context);
                    }
                    context.reporter().afterExamples();
                } else {
                    context.stepsContext().resetExample();
                    this.normalScenario.perform(context);
                }
                this.status = context.status(state);
            }
            finally {
                this.timing = new Timing(timer.stop());
                context.reporter().afterScenario(this.timing);
            }
        }

        @Override
        public void reportFailures(FailureContext context) {
            if (this.hasExamples()) {
                for (ExamplePerformableScenario exampleScenario : this.exampleScenarios) {
                    exampleScenario.reportFailures(context);
                }
            } else {
                this.normalScenario.reportFailures(context);
            }
        }
    }

    public static class NormalPerformableScenario
    extends AbstractPerformableScenario {
        public NormalPerformableScenario(Story story) {
            super(story);
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            this.resetStateIfConfigured(context);
            this.performScenario(context);
        }
    }

    public static class ExamplePerformableScenario
    extends AbstractPerformableScenario {
        private final int exampleIndex;

        public ExamplePerformableScenario(Story story, Map<String, String> exampleParameters, int exampleIndex) {
            super(story, exampleParameters);
            this.exampleIndex = exampleIndex;
        }

        @Override
        public void perform(RunContext context) throws InterruptedException {
            Meta parameterMeta = this.parameterMeta(context.configuration().keywords(), this.parameters).inheritFrom(this.getStoryAndScenarioMeta());
            if (parameterMeta.isEmpty() || !context.filter().excluded(parameterMeta)) {
                this.resetStateIfConfigured(context);
                context.stepsContext().resetExample();
                context.reporter().example(this.parameters, this.exampleIndex);
                this.performScenario(context);
            }
        }

        private Meta parameterMeta(Keywords keywords, Map<String, String> parameters) {
            String meta = keywords.meta();
            if (parameters.containsKey(meta)) {
                return Meta.createMeta(parameters.get(meta), keywords);
            }
            return Meta.EMPTY;
        }
    }

    public static abstract class AbstractPerformableScenario
    extends PerformableEntity {
        private transient Story story;
        protected final Map<String, String> parameters;
        protected final PerformableSteps steps = new PerformableSteps();
        private Meta storyAndScenarioMeta = new Meta();

        protected AbstractPerformableScenario(Story story) {
            this(story, new HashMap<String, String>());
        }

        protected AbstractPerformableScenario(Story story, Map<String, String> parameters) {
            super(StoryReporter::beforeScenarioSteps, StoryReporter::afterScenarioSteps);
            this.story = story;
            this.parameters = parameters;
        }

        public void addSteps(PerformableSteps steps) {
            this.steps.add(steps);
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        protected void performScenario(RunContext context) throws InterruptedException {
            this.performBeforeSteps(context);
            this.getGivenStories().perform(context);
            this.performWithStopExecutionExceptionHandling((FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
                boolean restart = true;
                while (restart) {
                    restart = false;
                    try {
                        context.reporter().beforeScenarioSteps(null, null);
                        this.steps.perform(context, true);
                    }
                    catch (RestartingScenarioFailure e) {
                        restart = true;
                    }
                }
            }), (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
                context.reporter().afterScenarioSteps(null, null);
                this.performAfterSteps(context);
            }));
        }

        @Override
        public void reportFailures(FailureContext context) {
            this.getBeforeSteps(Lifecycle.ExecutionType.SYSTEM).reportFailures(context);
            this.getBeforeSteps(Lifecycle.ExecutionType.USER).reportFailures(context);
            this.steps.reportFailures(context);
            this.getAfterSteps(Lifecycle.ExecutionType.USER).reportFailures(context);
            this.getAfterSteps(Lifecycle.ExecutionType.SYSTEM).reportFailures(context);
        }

        protected void resetStateIfConfigured(RunContext context) {
            if (context.configuration().storyControls().resetStateBeforeScenario()) {
                if (context.failureOccurred()) {
                    context.addFailure(this.story);
                }
                context.resetState();
            }
        }

        public Meta getStoryAndScenarioMeta() {
            return this.storyAndScenarioMeta;
        }

        public void setStoryAndScenarioMeta(Meta storyAndScenarioMeta) {
            this.storyAndScenarioMeta = storyAndScenarioMeta;
        }
    }

    public static interface State {
        public State run(Step var1, List<StepResult> var2, Keywords var3, StoryReporter var4);

        public RuntimeException getFailure();
    }

    private static interface LifecycleStepsExecutionHook {
        public void perform(StoryReporter var1, StepCollector.Stage var2, Lifecycle.ExecutionType var3);
    }

    public static abstract class PerformableEntity
    implements Performable {
        private PerformableGivenStories givenStories = new PerformableGivenStories(Collections.emptyList(), null);
        private final Map<StepCollector.Stage, Map<Lifecycle.ExecutionType, PerformableSteps>> stageSteps = new EnumMap<StepCollector.Stage, Map<Lifecycle.ExecutionType, PerformableSteps>>(StepCollector.Stage.class);
        private final LifecycleStepsExecutionHook beforeHook;
        private final LifecycleStepsExecutionHook afterHook;

        public PerformableEntity(LifecycleStepsExecutionHook beforeHook, LifecycleStepsExecutionHook afterHook) {
            this.beforeHook = beforeHook;
            this.afterHook = afterHook;
        }

        public void setGivenStories(PerformableGivenStories givenStories) {
            this.givenStories = givenStories;
        }

        public void addBeforeSteps(Lifecycle.ExecutionType type, PerformableSteps beforeSteps) {
            this.getBeforeSteps(type).add(beforeSteps);
        }

        public void addAfterSteps(Lifecycle.ExecutionType type, PerformableSteps afterSteps) {
            this.getAfterSteps(type).add(afterSteps);
        }

        protected void performWithStopExecutionExceptionHandling(FailableRunnable<InterruptedException> action, FailableRunnable<InterruptedException> afterHook) throws InterruptedException {
            try {
                action.run();
            }
            finally {
                afterHook.run();
            }
        }

        protected void performBeforeSteps(RunContext context) throws InterruptedException {
            this.performHookSteps(context, StepCollector.Stage.BEFORE, Lifecycle.ExecutionType.SYSTEM);
            this.performHookSteps(context, StepCollector.Stage.BEFORE, Lifecycle.ExecutionType.USER);
        }

        protected void performAfterSteps(RunContext context) throws InterruptedException {
            this.performHookSteps(context, StepCollector.Stage.AFTER, Lifecycle.ExecutionType.USER);
            this.performHookSteps(context, StepCollector.Stage.AFTER, Lifecycle.ExecutionType.SYSTEM);
        }

        protected PerformableSteps getBeforeSteps(Lifecycle.ExecutionType type) {
            return this.getPerformableSteps(StepCollector.Stage.BEFORE, type);
        }

        protected PerformableSteps getAfterSteps(Lifecycle.ExecutionType type) {
            return this.getPerformableSteps(StepCollector.Stage.AFTER, type);
        }

        private PerformableSteps getPerformableSteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
            Map steps = this.stageSteps.computeIfAbsent(stage, t -> new EnumMap(Lifecycle.ExecutionType.class));
            return steps.computeIfAbsent(type, s -> new PerformableSteps());
        }

        private void performHookSteps(RunContext context, StepCollector.Stage stage, Lifecycle.ExecutionType type) throws InterruptedException {
            StoryReporter reporter = context.reporter();
            this.beforeHook.perform(reporter, stage, type);
            this.getPerformableSteps(stage, type).perform(context, false);
            this.afterHook.perform(reporter, stage, type);
        }

        public PerformableGivenStories getGivenStories() {
            return this.givenStories;
        }
    }

    public static enum Status {
        SUCCESSFUL,
        FAILED,
        PENDING,
        NOT_PERFORMED,
        EXCLUDED;

    }

    public static interface Performable
    extends ReportingFailures {
        public void perform(RunContext var1) throws InterruptedException;
    }

    public static interface ReportingFailures {
        public void reportFailures(FailureContext var1);
    }

    public static class FailureContext {
        List<Throwable> failures = new ArrayList<Throwable>();

        public void addFailure(Throwable failure) {
            this.failures.add(failure);
        }

        public List<Throwable> getFailures() {
            return this.failures;
        }
    }

    private static class StoryRunContext {
        private State state;
        private String path;
        private StoryReporter reporter;

        private StoryRunContext() {
        }

        private State state() {
            return this.state;
        }

        private void stateIs(State state) {
            this.state = state;
        }

        private void resetState() {
            this.state = new FineSoFar();
        }

        private String path() {
            return this.path;
        }

        private void pathIs(String path) {
            this.path = path;
        }

        public StoryReporter reporter() {
            return this.reporter;
        }

        private void reporterIs(StoryReporter reporter) {
            this.reporter = reporter;
        }
    }

    private static final class Pending
    implements State {
        private final PendingStepFound failure;

        private Pending(PendingStepFound failure) {
            this.failure = failure;
        }

        @Override
        public State run(Step step, List<StepResult> results, Keywords keywords, StoryReporter reporter) {
            StepResult result = AbstractStepResult.pending((StepCreator.PendingStep)step);
            results.add(result);
            result.describeTo(reporter);
            return this;
        }

        @Override
        public PendingStepFound getFailure() {
            return this.failure;
        }
    }

    private static final class Ignoring
    implements State {
        private final IgnoringStepsFailure failure;

        private Ignoring(IgnoringStepsFailure failure) {
            this.failure = failure;
        }

        @Override
        public State run(Step step, List<StepResult> results, Keywords keywords, StoryReporter reporter) {
            String stepAsString = step.asString(keywords);
            reporter.beforeStep(new org.jbehave.core.model.Step(StepCreator.StepExecutionType.IGNORABLE, stepAsString));
            StepResult result = AbstractStepResult.ignorable(stepAsString);
            results.add(result);
            result.describeTo(reporter);
            return this;
        }

        @Override
        public IgnoringStepsFailure getFailure() {
            return this.failure;
        }
    }

    private static final class SomethingHappened
    implements State {
        private UUIDExceptionWrapper failure;

        public SomethingHappened(UUIDExceptionWrapper failure) {
            this.failure = failure;
        }

        @Override
        public State run(Step step, List<StepResult> results, Keywords keywords, StoryReporter reporter) {
            StepResult result = step.doNotPerform(reporter, this.getFailure());
            results.add(result);
            result.describeTo(reporter);
            return this;
        }

        @Override
        public UUIDExceptionWrapper getFailure() {
            return this.failure;
        }
    }

    private static final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        @Override
        public State run(Step step, List<StepResult> results, Keywords keywords, StoryReporter reporter) {
            State state;
            StepResult result;
            try {
                result = step.perform(reporter, this.getFailure());
                UUIDExceptionWrapper stepFailure = result.getFailure();
                state = stepFailure == null ? this : new SomethingHappened(stepFailure);
            }
            catch (IgnoringStepsFailure e) {
                result = AbstractStepResult.ignorable(step.asString(keywords));
                state = new Ignoring(e);
            }
            catch (PendingStepFound e) {
                result = AbstractStepResult.pending((StepCreator.PendingStep)step);
                state = new Pending(e);
            }
            int indexOfResult = results.size();
            results.add(result);
            List<Step> composedSteps = step.getComposedSteps();
            if (!composedSteps.isEmpty()) {
                reporter.beforeComposedSteps();
                for (Step composedStep : composedSteps) {
                    state = state.run(composedStep, results, keywords, reporter);
                }
                reporter.afterComposedSteps();
            }
            if (state instanceof Ignoring) {
                result = AbstractStepResult.ignorable(step.asString(keywords));
                results.set(indexOfResult, result);
            }
            result.describeTo(reporter);
            return state;
        }

        @Override
        public UUIDExceptionWrapper getFailure() {
            return null;
        }
    }
}

