/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.StoryControls;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;

public class FilteredStory {
    private final boolean filterIgnored;
    private final boolean storyExcluded;
    private final List<Scenario> scenariosIncluded = new ArrayList<Scenario>();

    public FilteredStory(MetaFilter filter, Story story, StoryControls storyControls) {
        this(filter, story, storyControls, false);
    }

    public FilteredStory(MetaFilter filter, Story story, StoryControls storyControls, boolean givenStory) {
        this.filterIgnored = givenStory && storyControls.ignoreMetaFiltersIfGivenStory();
        String storyMetaPrefix = storyControls.storyMetaPrefix();
        String scenarioMetaPrefix = storyControls.scenarioMetaPrefix();
        Meta storyMeta = story.getMeta().inheritFrom(story.asMeta(storyMetaPrefix));
        this.storyExcluded = filter.excluded(storyMeta);
        for (Scenario scenario : story.getScenarios()) {
            if (scenario.getExamplesTable().getRowCount() > 0 && this.metaByRow(scenario, storyControls)) {
                this.scenariosIncluded.add(scenario);
                continue;
            }
            Meta scenarioMeta = scenario.getMeta().inheritFrom(scenario.asMeta(scenarioMetaPrefix).inheritFrom(storyMeta));
            if (filter.excluded(scenarioMeta)) continue;
            this.scenariosIncluded.add(scenario);
        }
    }

    public boolean excluded() {
        return !this.filterIgnored && this.storyExcluded && this.scenariosIncluded.isEmpty();
    }

    public boolean excluded(Scenario scenario) {
        return !this.filterIgnored && !this.scenariosIncluded.contains(scenario);
    }

    private boolean metaByRow(Scenario scenario, StoryControls storyControls) {
        if (scenario.getExamplesTable().getProperties().containsKey("metaByRow")) {
            return scenario.getExamplesTable().metaByRow();
        }
        return storyControls.metaByRow();
    }
}

