/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;

public class DelegatingEmbedderMonitor
implements EmbedderMonitor {
    private final Collection<EmbedderMonitor> delegates;

    public DelegatingEmbedderMonitor(Collection<EmbedderMonitor> delegates) {
        this.delegates = delegates;
    }

    public DelegatingEmbedderMonitor(EmbedderMonitor ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void runningEmbeddable(String name) {
        this.delegates.forEach(d -> d.runningEmbeddable(name));
    }

    @Override
    public void embeddableFailed(String name, Throwable cause) {
        this.delegates.forEach(d -> d.embeddableFailed(name, cause));
    }

    @Override
    public void embeddableNotConfigurable(String name) {
        this.delegates.forEach(d -> d.embeddableNotConfigurable(name));
    }

    @Override
    public void embeddablesSkipped(List<String> classNames) {
        this.delegates.forEach(d -> d.embeddablesSkipped(classNames));
    }

    @Override
    public void metaExcluded(Meta meta, MetaFilter filter) {
        this.delegates.forEach(d -> d.metaExcluded(meta, filter));
    }

    @Override
    public void runningStory(String path) {
        this.delegates.forEach(d -> d.runningStory(path));
    }

    @Override
    public void storyFailed(String path, Throwable cause) {
        this.delegates.forEach(d -> d.storyFailed(path, cause));
    }

    @Override
    public void storiesSkipped(List<String> storyPaths) {
        this.delegates.forEach(d -> d.storiesSkipped(storyPaths));
    }

    @Override
    public void storiesExcluded(List<Story> excluded, MetaFilter filter, boolean verbose) {
        this.delegates.forEach(d -> d.storiesExcluded(excluded, filter, verbose));
    }

    @Override
    public void scenarioExcluded(Scenario scenario, MetaFilter filter) {
        this.delegates.forEach(d -> d.scenarioExcluded(scenario, filter));
    }

    @Override
    public void batchFailed(BatchFailures failures) {
        this.delegates.forEach(d -> d.batchFailed(failures));
    }

    @Override
    public void beforeOrAfterStoriesFailed() {
        this.delegates.forEach(EmbedderMonitor::beforeOrAfterStoriesFailed);
    }

    @Override
    public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
        this.delegates.forEach(d -> d.generatingReportsView(outputDirectory, formats, viewProperties));
    }

    @Override
    public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
        this.delegates.forEach(d -> d.reportsViewGenerationFailed(outputDirectory, formats, viewProperties, cause));
    }

    @Override
    public void reportsViewGenerated(ReportsCount count) {
        this.delegates.forEach(d -> d.reportsViewGenerated(count));
    }

    @Override
    public void reportsViewFailures(ReportsCount count) {
        this.delegates.forEach(d -> d.reportsViewFailures(count));
    }

    @Override
    public void reportsViewNotGenerated() {
        this.delegates.forEach(EmbedderMonitor::reportsViewNotGenerated);
    }

    @Override
    public void runningWithAnnotatedEmbedderRunner(String className) {
        this.delegates.forEach(d -> d.runningWithAnnotatedEmbedderRunner(className));
    }

    @Override
    public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
        this.delegates.forEach(d -> d.annotatedInstanceNotOfType(annotatedInstance, type));
    }

    @Override
    public void mappingStory(String storyPath, List<String> metaFilters) {
        this.delegates.forEach(d -> d.mappingStory(storyPath, metaFilters));
    }

    @Override
    public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
        this.delegates.forEach(d -> d.generatingMapsView(outputDirectory, storyMaps, viewProperties));
    }

    @Override
    public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
        this.delegates.forEach(d -> d.mapsViewGenerationFailed(outputDirectory, storyMaps, viewProperties, cause));
    }

    @Override
    public void processingSystemProperties(Properties properties) {
        this.delegates.forEach(d -> d.processingSystemProperties(properties));
    }

    @Override
    public void systemPropertySet(String name, String value) {
        this.delegates.forEach(d -> d.systemPropertySet(name, value));
    }

    @Override
    public void storyTimeout(Story story, StoryDuration storyDuration) {
        this.delegates.forEach(d -> d.storyTimeout(story, storyDuration));
    }

    @Override
    public void usingThreads(int threads) {
        this.delegates.forEach(d -> d.usingThreads(threads));
    }

    @Override
    public void usingExecutorService(ExecutorService executorService) {
        this.delegates.forEach(d -> d.usingExecutorService(executorService));
    }

    @Override
    public void usingControls(EmbedderControls embedderControls) {
        this.delegates.forEach(d -> d.usingControls(embedderControls));
    }

    @Override
    public void invalidTimeoutFormat(String path) {
        this.delegates.forEach(d -> d.invalidTimeoutFormat(path));
    }

    @Override
    public void usingTimeout(String path, long timeout) {
        this.delegates.forEach(d -> d.usingTimeout(path, timeout));
    }
}

