/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.condition;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.jbehave.core.condition.StepConditionMatchException;
import org.jbehave.core.condition.StepConditionMatcher;

public class InstanceStepConditionMatcher
implements StepConditionMatcher {
    private final Collection<Predicate<Object>> conditions;

    public InstanceStepConditionMatcher(Collection<Predicate<Object>> conditions) {
        conditions.stream().map(Object::getClass).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((type, count) -> Validate.isTrue((count == 1L ? 1 : 0) != 0, (String)"Only one instance of %s condition is allowed", (Object[])new Object[]{type}));
        this.conditions = conditions;
    }

    @Override
    public boolean matches(Class<? extends Predicate<Object>> condition, Object value) throws StepConditionMatchException {
        return this.conditions.stream().filter(c -> c.getClass().equals(condition)).findFirst().orElseThrow(() -> new StepConditionMatchException(String.format("Unable to find implementation for the %s condition", condition))).test(value);
    }
}

