/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.model.Alias;
import org.jbehave.core.model.AliasVariant;
import org.jbehave.core.parsers.AliasParser;
import org.jbehave.core.steps.AbstractCandidateSteps;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public class Steps
extends AbstractCandidateSteps {
    private final Class<?> type;
    private final InjectableStepsFactory stepsFactory;
    private final StepCreator stepCreator;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        super(configuration);
        this.type = this.getClass();
        this.stepsFactory = new InstanceStepsFactory(configuration, this);
        this.stepCreator = new StepCreator(this.type, this.stepsFactory, this.configuration().stepsContext(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public Steps(Configuration configuration, Object instance) {
        this(configuration, instance.getClass(), new InstanceStepsFactory(configuration, instance));
    }

    public Steps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        super(configuration);
        this.type = type;
        this.stepsFactory = stepsFactory;
        this.stepCreator = new StepCreator(type, stepsFactory, this.configuration().stepsContext(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public Class<?> type() {
        return this.type;
    }

    public Object instance() {
        return this.stepsFactory.createInstanceOfType(this.type);
    }

    @Override
    public List<StepCandidate> listCandidates() {
        Map<StepType, List<Alias>> aliases = this.findAliases();
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
                Steps.findVariants(StepType.GIVEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, variant.getValue(), priority));
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
                Steps.findVariants(StepType.WHEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.WHEN, variant.getValue(), priority));
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidatesFromVariants(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
            Steps.findVariants(StepType.THEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.THEN, variant.getValue(), priority));
        }
        return candidates;
    }

    private static Collection<AliasVariant> findVariants(StepType stepType, String stepValue, Map<StepType, List<Alias>> aliases) {
        return aliases.getOrDefault((Object)stepType, Collections.emptyList()).stream().filter(alias -> stepValue.equals(alias.getStepIdentifier())).map(Alias::getVariants).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<StepType, List<Alias>> findAliases() {
        StoryLoader resourceLoader = this.configuration().storyLoader();
        AliasParser aliasParser = this.configuration().aliasParser();
        Collection aliases = this.configuration().aliasPaths().stream().map(resourceLoader::loadResourceAsText).collect(Collectors.collectingAndThen(Collectors.toSet(), aliasParser::parse));
        return aliases.stream().collect(Collectors.groupingBy(Alias::getType, Collectors.toList()));
    }

    private void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority) {
        PatternVariantBuilder b = new PatternVariantBuilder(value);
        for (String variant : b.allVariants()) {
            this.addCandidate(candidates, method, stepType, variant, priority);
        }
    }

    private void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(org.jbehave.core.annotations.Alias.class)) {
            String alias = method.getAnnotation(org.jbehave.core.annotations.Alias.class).value();
            this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
        }
    }

    private void addCandidate(List<StepCandidate> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        StepCandidate candidate = this.createCandidate(stepPatternAsString, priority, stepType, method, this.type, this.stepsFactory);
        this.checkForDuplicateCandidates(candidates, candidate);
        if (method.isAnnotationPresent(Composite.class)) {
            candidate.composedOf(method.getAnnotation(Composite.class).steps());
        }
        candidates.add(candidate);
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeStories() {
        return this.listSteps(BeforeStories.class, (T v) -> true, BeforeStories::order);
    }

    @Override
    public List<BeforeOrAfterStep> listAfterStories() {
        return this.listSteps(AfterStories.class, (T v) -> true, AfterStories::order);
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeStory(boolean givenStory) {
        return this.listSteps(BeforeStory.class, (T v) -> v.uponGivenStory() == givenStory, BeforeStory::order);
    }

    @Override
    public List<BeforeOrAfterStep> listAfterStory(boolean givenStory) {
        return this.listSteps(AfterStory.class, (T v) -> v.uponGivenStory() == givenStory, AfterStory::order);
    }

    @Override
    public Map<ScenarioType, List<BeforeOrAfterStep>> listBeforeScenario() {
        Map<Method, BeforeScenario> beforeScenarioMethods = this.methodsAnnotatedWith(BeforeScenario.class);
        EnumMap<ScenarioType, List<BeforeOrAfterStep>> stepsPerType = new EnumMap<ScenarioType, List<BeforeOrAfterStep>>(ScenarioType.class);
        for (ScenarioType scenarioType : ScenarioType.values()) {
            stepsPerType.put(scenarioType, this.listSteps(beforeScenarioMethods, (T v) -> v.uponType() == scenarioType, BeforeScenario::order));
        }
        return stepsPerType;
    }

    @Override
    public Map<ScenarioType, List<BeforeOrAfterStep>> listAfterScenario() {
        Map<Method, AfterScenario> afterScenarioMethods = this.methodsAnnotatedWith(AfterScenario.class);
        EnumMap<ScenarioType, List<BeforeOrAfterStep>> stepsPerType = new EnumMap<ScenarioType, List<BeforeOrAfterStep>>(ScenarioType.class);
        for (ScenarioType scenarioType : ScenarioType.values()) {
            ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
            for (AfterScenario.Outcome outcome : new AfterScenario.Outcome[]{AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE}) {
                steps.addAll(this.listSteps(afterScenarioMethods, (T v) -> v.uponType() == scenarioType && v.uponOutcome() == outcome, (Method m, T a) -> new BeforeOrAfterStep((Method)m, a.order(), outcome, this.stepCreator)));
            }
            stepsPerType.put(scenarioType, steps);
        }
        return stepsPerType;
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Class<T> type, Predicate<T> predicate, ToIntFunction<T> order) {
        return this.listSteps(this.methodsAnnotatedWith(type), predicate, order);
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Map<Method, T> methods, Predicate<T> predicate, ToIntFunction<T> order) {
        return this.listSteps(methods, predicate, (Method m, T a) -> new BeforeOrAfterStep((Method)m, order.applyAsInt(a), this.stepCreator));
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Map<Method, T> methods, Predicate<T> predicate, BiFunction<Method, T, BeforeOrAfterStep> factory) {
        return methods.entrySet().stream().filter(e -> predicate.test((Annotation)e.getValue())).map(e -> (BeforeOrAfterStep)factory.apply((Method)e.getKey(), (Annotation)e.getValue())).collect(Collectors.toList());
    }

    private Method[] allMethods() {
        return this.type.getMethods();
    }

    private <T extends Annotation> Map<Method, T> methodsAnnotatedWith(Class<T> annotationClass) {
        LinkedHashMap<Method, T> annotated = new LinkedHashMap<Method, T>();
        for (Method method : this.allMethods()) {
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            annotated.put(method, annotation);
        }
        return annotated;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.instance()).toString();
    }
}

