/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import org.jbehave.core.model.StepPattern;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;

public class DelegatingStepMonitor
implements StepMonitor {
    private final Collection<StepMonitor> delegates;

    public DelegatingStepMonitor(Collection<StepMonitor> delegates) {
        this.delegates = delegates;
    }

    public DelegatingStepMonitor(StepMonitor ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void convertedValueOfType(String value, Type type, Object converted, Queue<Class<?>> converterClasses) {
        for (StepMonitor monitor : this.delegates) {
            monitor.convertedValueOfType(value, type, converted, converterClasses);
        }
    }

    @Override
    public void stepMatchesType(String stepAsString, String previousAsString, boolean matchesType, StepType stepType, Method method, Object stepsInstance) {
        for (StepMonitor monitor : this.delegates) {
            monitor.stepMatchesType(stepAsString, previousAsString, matchesType, stepType, method, stepsInstance);
        }
    }

    @Override
    public void stepMatchesPattern(String step, boolean matches, StepPattern stepPattern, Method method, Object stepsInstance) {
        for (StepMonitor monitor : this.delegates) {
            monitor.stepMatchesPattern(step, matches, stepPattern, method, stepsInstance);
        }
    }

    @Override
    public void foundParameter(String parameter, int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.foundParameter(parameter, position);
        }
    }

    @Override
    public void beforePerforming(String step, boolean dryRun, Method method) {
        for (StepMonitor monitor : this.delegates) {
            monitor.beforePerforming(step, dryRun, method);
        }
    }

    @Override
    public void afterPerforming(String step, boolean dryRun, Method method) {
        for (StepMonitor monitor : this.delegates) {
            monitor.afterPerforming(step, dryRun, method);
        }
    }

    @Override
    public void usingAnnotatedNameForParameter(String name, int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingAnnotatedNameForParameter(name, position);
        }
    }

    @Override
    public void usingNaturalOrderForParameter(int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingNaturalOrderForParameter(position);
        }
    }

    @Override
    public void usingParameterNameForParameter(String name, int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingParameterNameForParameter(name, position);
        }
    }

    @Override
    public void usingTableAnnotatedNameForParameter(String name, int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingTableAnnotatedNameForParameter(name, position);
        }
    }

    @Override
    public void usingTableParameterNameForParameter(String name, int position) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingTableParameterNameForParameter(name, position);
        }
    }

    @Override
    public void usingStepsContextParameter(String parameter) {
        for (StepMonitor monitor : this.delegates) {
            monitor.usingStepsContextParameter(parameter);
        }
    }
}

