/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.model.Meta;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;

public class BeforeOrAfterStep {
    private final Method method;
    private final int order;
    private final StepCreator stepCreator;
    private final AfterScenario.Outcome outcome;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public BeforeOrAfterStep(Method method, int order, StepCreator stepCreator) {
        this(method, order, AfterScenario.Outcome.ANY, stepCreator);
    }

    public BeforeOrAfterStep(Method method, int order, AfterScenario.Outcome outcome, StepCreator stepCreator) {
        this.method = method;
        this.order = order;
        this.outcome = outcome;
        this.stepCreator = stepCreator;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getOrder() {
        return this.order;
    }

    public Step createStep() {
        return this.createStepWith(Meta.EMPTY);
    }

    public Step createStepWith(Meta meta) {
        return this.stepCreator.createBeforeOrAfterStep(this.method, meta);
    }

    public Step createStepUponOutcome(Meta storyAndScenarioMeta) {
        return this.stepCreator.createAfterStepUponOutcome(this.method, this.outcome, storyAndScenarioMeta);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.method).append(this.order).append((Object)this.outcome).append((Object)this.stepMonitor).toString();
    }
}

