/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepType;

public abstract class AbstractCandidateSteps
implements CandidateSteps {
    private final Configuration configuration;

    protected AbstractCandidateSteps(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration configuration() {
        return this.configuration;
    }

    protected void checkForDuplicateCandidates(List<StepCandidate> candidates, StepCandidate candidate) {
        String candidateName = candidate.getName();
        String parameterPrefix = this.configuration.stepPatternParser().getPrefix();
        if (candidates.stream().anyMatch(this.isDuplicate(candidate, candidateName, parameterPrefix))) {
            throw new DuplicateCandidateFound(candidate);
        }
    }

    private Predicate<StepCandidate> isDuplicate(StepCandidate candidate, String candidateName, String parameterPrefix) {
        return c -> candidateName.startsWith(StringUtils.substringBefore((String)c.getName(), (String)parameterPrefix)) && c.matches(candidateName) && candidate.matches(c.getName());
    }

    protected StepCandidate createCandidate(String stepPatternAsString, int priority, StepType stepType, Method method, Class<?> type, InjectableStepsFactory stepsFactory) {
        StepCandidate candidate = new StepCandidate(stepPatternAsString, priority, stepType, method, type, stepsFactory, this.configuration.stepsContext(), this.configuration.keywords(), this.configuration.stepPatternParser(), this.configuration.parameterConverters(), this.configuration.parameterControls());
        candidate.useStepMonitor(this.configuration.stepMonitor());
        candidate.useParanamer(this.configuration.paranamer());
        candidate.doDryRun(this.configuration.storyControls().dryRun());
        return candidate;
    }

    public static class DuplicateCandidateFound
    extends RuntimeException {
        public static final String DUPLICATE_FORMAT = "{0} {1}";

        public DuplicateCandidateFound(StepCandidate candidate) {
            super(MessageFormat.format(DUPLICATE_FORMAT, new Object[]{candidate.getStepType(), candidate.getPatternAsString()}));
        }
    }
}

