/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.Verbatim;
import org.jbehave.core.reporters.EscapeMode;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StackTraceFormatter;
import org.jbehave.core.reporters.TemplateProcessor;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.Timing;

public class TemplateableOutput
extends NullStoryReporter {
    private final File file;
    private final Keywords keywords;
    private final TemplateProcessor processor;
    private final String templatePath;
    private OutputStory outputStory = new OutputStory();
    private OutputScenario outputScenario = new OutputScenario();
    private OutputStep failedStep;
    private Scope scope;
    private StepCollector.Stage stage;

    public TemplateableOutput(File file, Keywords keywords, TemplateProcessor processor, String templatePath) {
        this.file = file;
        this.keywords = keywords;
        this.processor = processor;
        this.templatePath = templatePath;
    }

    @Override
    public void storyExcluded(Story story, String filter) {
        this.outputStory.excludedBy = filter;
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        if (!givenStory) {
            this.outputStory = new OutputStory();
            this.outputStory.description = story.getDescription().asString();
            this.outputStory.path = story.getPath();
            this.scope = Scope.STORY;
            this.stage = StepCollector.Stage.BEFORE;
        }
        if (!story.getMeta().isEmpty()) {
            this.outputStory.meta = new OutputMeta(story.getMeta());
        }
    }

    @Override
    public void narrative(Narrative narrative) {
        if (!narrative.isEmpty()) {
            this.outputStory.narrative = new OutputNarrative(narrative);
        }
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        if (!lifecycle.isEmpty()) {
            this.outputStory.lifecycle = new OutputLifecycle(lifecycle);
        }
    }

    @Override
    public void scenarioExcluded(Scenario scenario, String filter) {
        this.outputScenario.excludedBy = filter;
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        if (this.outputScenario.currentExample == null) {
            this.outputScenario = new OutputScenario();
        }
        this.outputScenario.title = scenario.getTitle();
        this.scope = Scope.SCENARIO;
        Meta meta = scenario.getMeta();
        if (!meta.isEmpty()) {
            this.outputScenario.meta = new OutputMeta(meta);
        }
    }

    private void addStep(OutputStep outputStep) {
        if (this.scope == Scope.STORY) {
            if (this.stage == StepCollector.Stage.BEFORE) {
                this.outputStory.addBeforeStep(outputStep);
            } else {
                this.outputStory.addAfterStep(outputStep);
            }
        } else {
            this.outputScenario.addStep(outputStep);
        }
    }

    @Override
    public void successful(String step) {
        this.addStep(new OutputStep(step, "successful"));
    }

    @Override
    public void ignorable(String step) {
        this.addStep(new OutputStep(step, "ignorable"));
    }

    @Override
    public void comment(String step) {
        this.addStep(new OutputStep(step, "comment"));
    }

    @Override
    public void pending(String step) {
        this.addStep(new OutputStep(step, "pending"));
    }

    @Override
    public void notPerformed(String step) {
        this.addStep(new OutputStep(step, "notPerformed"));
    }

    @Override
    public void failed(String step, Throwable storyFailure) {
        this.failedStep = new OutputStep(step, "failed");
        this.failedStep.failure = storyFailure;
        this.addStep(this.failedStep);
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failed(step, table.failureCause());
        this.failedStep.outcomes = table;
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        if (!givenStories.getStories().isEmpty()) {
            this.outputScenario.givenStories = givenStories;
        }
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.givenStories(new GivenStories(StringUtils.join(storyPaths, (String)",")));
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.outputScenario.examplesSteps = steps;
        this.outputScenario.examplesTable = table;
    }

    @Override
    public void example(Map<String, String> parameters, int exampleIndex) {
        this.outputScenario.examples.add(parameters);
        this.outputScenario.currentExample = parameters;
    }

    @Override
    public void afterExamples() {
        this.outputScenario.currentExample = null;
    }

    @Override
    public void afterScenario(Timing timing) {
        if (this.outputScenario.currentExample == null) {
            this.outputStory.scenarios.add(this.outputScenario);
        }
        this.scope = Scope.STORY;
        this.stage = StepCollector.Stage.AFTER;
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.outputStory.pendingMethods = methods;
    }

    @Override
    public void restarted(String step, Throwable cause) {
        this.addStep(new OutputRestart(step, cause.getMessage()));
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        this.addStep(new OutputRestart(story.getName(), cause.getMessage()));
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.outputStory.cancelled = true;
        this.outputStory.storyDuration = storyDuration;
    }

    @Override
    public void afterStory(boolean givenStory) {
        if (!givenStory) {
            Map<String, Object> model = this.newDataModel();
            model.put("story", this.outputStory);
            model.put("keywords", new OutputKeywords(this.keywords));
            TemplateHashModel enumModels = BeansWrapper.getDefaultInstance().getEnumModels();
            try {
                String escapeModeEnum = EscapeMode.class.getCanonicalName();
                TemplateHashModel escapeEnums = (TemplateHashModel)enumModels.get(escapeModeEnum);
                model.put("EscapeMode", escapeEnums);
            }
            catch (TemplateModelException e) {
                throw new IllegalArgumentException(e);
            }
            this.write(this.file, this.templatePath, model);
        }
    }

    private File write(File file, String resource, Map<String, Object> dataModel) {
        try {
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            this.processor.process(resource, dataModel, writer);
            ((Writer)writer).close();
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(resource, e);
        }
    }

    private Map<String, Object> newDataModel() {
        return new HashMap<String, Object>();
    }

    public static class OutputParameter {
        private final String parameter;

        public OutputParameter(String pattern, int start, int end) {
            this.parameter = pattern.substring(start, end).trim();
        }

        public String getValue() {
            String value = StringUtils.remove((String)this.parameter, (String)"\uff5f");
            value = StringUtils.remove((String)value, (String)"\uff60");
            return value;
        }

        public String toString() {
            return this.parameter;
        }
    }

    public static class OutputStep {
        private final String step;
        private final String outcome;
        private Throwable failure;
        private OutcomesTable outcomes;
        private List<OutputParameter> parameters;
        private String stepPattern;
        private String tableAsString;
        private ExamplesTable table;
        private String verbatimAsString;
        private Verbatim verbatim;

        public OutputStep(String step, String outcome) {
            this.step = step;
            this.outcome = outcome;
            this.parseTableAsString();
            this.parseVerbatimAsString();
            this.parseParameters();
            this.createStepPattern();
        }

        public String getStep() {
            return this.step;
        }

        public String getStepPattern() {
            return this.stepPattern;
        }

        public List<OutputParameter> getParameters() {
            return this.parameters;
        }

        public String getOutcome() {
            return this.outcome;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public String getFailureCause() {
            if (this.failure != null) {
                return new StackTraceFormatter(true).stackTrace(this.failure);
            }
            return "";
        }

        public ExamplesTable getTable() {
            return this.table;
        }

        public Verbatim getVerbatim() {
            return this.verbatim;
        }

        public OutcomesTable getOutcomes() {
            return this.outcomes;
        }

        public String getOutcomesFailureCause() {
            if (this.outcomes.failureCause() != null) {
                return new StackTraceFormatter(true).stackTrace(this.outcomes.failureCause());
            }
            return "";
        }

        public String getFormattedStep(String parameterPattern) {
            return this.getFormattedStep(EscapeMode.NONE, parameterPattern);
        }

        public String getFormattedStep(EscapeMode escapeMode, String parameterPattern) {
            String escapedStep = escapeMode.escapeString(this.stepPattern);
            if (!this.parameters.isEmpty()) {
                try {
                    return MessageFormat.format(escapedStep, this.formatParameters(escapeMode, parameterPattern));
                }
                catch (RuntimeException e) {
                    throw new StepFormattingFailed(this.stepPattern, parameterPattern, this.parameters, e);
                }
            }
            return escapedStep;
        }

        private Object[] formatParameters(EscapeMode escapeMode, String parameterPattern) {
            Object[] arguments = new Object[this.parameters.size()];
            for (int a = 0; a < this.parameters.size(); ++a) {
                arguments[a] = MessageFormat.format(parameterPattern, escapeMode.escapeString(this.parameters.get(a).getValue()));
            }
            return arguments;
        }

        private void parseParameters() {
            this.parameters = this.findParameters("\uff5f\uff5f", "\uff60\uff60");
            if (this.parameters.isEmpty()) {
                this.parameters = this.findParameters("\uff5f", "\uff60");
            }
        }

        private List<OutputParameter> findParameters(String start, String end) {
            ArrayList<OutputParameter> parameters = new ArrayList<OutputParameter>();
            Matcher matcher = Pattern.compile("(" + start + ".*?" + end + ")(\\W|\\Z)", 32).matcher(this.step);
            while (matcher.find()) {
                parameters.add(new OutputParameter(this.step, matcher.start(), matcher.end()));
            }
            return parameters;
        }

        private void parseTableAsString() {
            if (this.step.contains("\uff3b") && this.step.contains("\uff3d")) {
                this.tableAsString = StringUtils.substringBetween((String)this.step, (String)"\uff3b", (String)"\uff3d");
                this.table = new ExamplesTable(this.tableAsString);
            }
        }

        private void parseVerbatimAsString() {
            if (this.step.contains("\u301a") && this.step.contains("\u301b")) {
                this.verbatimAsString = StringUtils.substringBetween((String)this.step, (String)"\u301a", (String)"\u301b");
                this.verbatim = new Verbatim(this.verbatimAsString);
            }
        }

        private void createStepPattern() {
            this.stepPattern = this.step;
            if (this.tableAsString != null) {
                this.stepPattern = StringUtils.replaceOnce((String)this.stepPattern, (String)("\uff3b" + this.tableAsString + "\uff3d"), (String)"");
            }
            if (this.verbatimAsString != null) {
                this.stepPattern = StringUtils.replaceOnce((String)this.stepPattern, (String)("\u301a" + this.verbatimAsString + "\u301b"), (String)"");
            }
            for (int count = 0; count < this.parameters.size(); ++count) {
                String value = this.parameters.get(count).toString();
                this.stepPattern = this.stepPattern.replace(value, "{" + count + "}");
            }
        }

        public static class StepFormattingFailed
        extends RuntimeException {
            public StepFormattingFailed(String stepPattern, String parameterPattern, List<OutputParameter> parameters, RuntimeException cause) {
                super("Failed to format step '" + stepPattern + "' with parameter pattern '" + parameterPattern + "' and parameters: " + parameters, cause);
            }
        }
    }

    public static class OutputRestart
    extends OutputStep {
        public OutputRestart(String step, String outcome) {
            super(step, outcome);
        }
    }

    public static class OutputScenario {
        private String title;
        private List<OutputStep> steps = new ArrayList<OutputStep>();
        private OutputMeta meta;
        private GivenStories givenStories;
        private String excludedBy;
        private List<String> examplesSteps;
        private ExamplesTable examplesTable;
        private Map<String, String> currentExample;
        private List<Map<String, String>> examples = new ArrayList<Map<String, String>>();
        private Map<Map<String, String>, List<OutputStep>> stepsByExample = new HashMap<Map<String, String>, List<OutputStep>>();

        public String getTitle() {
            return this.title;
        }

        public void addStep(OutputStep outputStep) {
            if (this.examplesTable == null) {
                this.steps.add(outputStep);
            } else {
                List<OutputStep> currentExampleSteps = this.stepsByExample.get(this.currentExample);
                if (currentExampleSteps == null) {
                    currentExampleSteps = new ArrayList<OutputStep>();
                    this.stepsByExample.put(this.currentExample, currentExampleSteps);
                }
                currentExampleSteps.add(outputStep);
            }
        }

        public List<OutputStep> getSteps() {
            return this.steps;
        }

        public List<OutputStep> getStepsByExample(Map<String, String> example) {
            List<OutputStep> steps = this.stepsByExample.get(example);
            if (steps == null) {
                return new ArrayList<OutputStep>();
            }
            return steps;
        }

        public OutputMeta getMeta() {
            return this.meta;
        }

        public GivenStories getGivenStories() {
            return this.givenStories;
        }

        public String getExcludedBy() {
            return this.excludedBy;
        }

        public List<String> getExamplesSteps() {
            return this.examplesSteps;
        }

        public ExamplesTable getExamplesTable() {
            return this.examplesTable;
        }

        public List<Map<String, String>> getExamples() {
            return this.examples;
        }
    }

    public static class OutputLifecycle {
        private final Lifecycle lifecycle;

        public OutputLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        public Set<Scope> getScopes() {
            return this.lifecycle.getScopes();
        }

        public boolean hasBeforeSteps() {
            return this.lifecycle.hasBeforeSteps();
        }

        public List<String> getBeforeSteps() {
            return this.lifecycle.getBeforeSteps();
        }

        public List<String> getBeforeSteps(Scope scope) {
            return this.lifecycle.getBeforeSteps(scope);
        }

        public boolean hasAfterSteps() {
            return this.lifecycle.hasAfterSteps();
        }

        public List<String> getAfterSteps() {
            return this.lifecycle.getAfterSteps();
        }

        public List<String> getAfterSteps(Scope scope) {
            return this.lifecycle.getAfterSteps(scope);
        }

        public List<String> getAfterSteps(Scope scope, AfterScenario.Outcome outcome) {
            return this.lifecycle.getAfterSteps(scope, outcome);
        }

        public List<String> getAfterSteps(AfterScenario.Outcome outcome) {
            return this.lifecycle.getAfterSteps(outcome);
        }

        public List<String> getAfterSteps(AfterScenario.Outcome outcome, Meta meta) {
            return this.lifecycle.getAfterSteps(outcome, meta);
        }

        public Set<AfterScenario.Outcome> getOutcomes() {
            return this.lifecycle.getOutcomes();
        }

        public MetaFilter getMetaFilter(AfterScenario.Outcome outcome) {
            return this.lifecycle.getMetaFilter(outcome);
        }
    }

    public static class OutputNarrative {
        private final Narrative narrative;

        public OutputNarrative(Narrative narrative) {
            this.narrative = narrative;
        }

        public String getInOrderTo() {
            return this.narrative.inOrderTo();
        }

        public String getAsA() {
            return this.narrative.asA();
        }

        public String getiWantTo() {
            return this.narrative.iWantTo();
        }

        public String getSoThat() {
            return this.narrative.soThat();
        }

        public boolean isAlternative() {
            return this.narrative.isAlternative();
        }
    }

    public static class OutputMeta {
        private final Meta meta;

        public OutputMeta(Meta meta) {
            this.meta = meta;
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String name : this.meta.getPropertyNames()) {
                properties.put(name, this.meta.getProperty(name));
            }
            return properties;
        }
    }

    public static class OutputStory {
        private String description;
        private String path;
        private OutputMeta meta;
        private OutputNarrative narrative;
        private OutputLifecycle lifecycle;
        private String excludedBy;
        private List<String> pendingMethods;
        private List<OutputStep> beforeSteps = new ArrayList<OutputStep>();
        private List<OutputStep> afterSteps = new ArrayList<OutputStep>();
        private List<OutputScenario> scenarios = new ArrayList<OutputScenario>();
        private boolean cancelled;
        private StoryDuration storyDuration;

        public String getDescription() {
            return this.description;
        }

        public String getPath() {
            return this.path;
        }

        public OutputMeta getMeta() {
            return this.meta;
        }

        public OutputNarrative getNarrative() {
            return this.narrative;
        }

        public OutputLifecycle getLifecycle() {
            return this.lifecycle;
        }

        public String getExcludedBy() {
            return this.excludedBy;
        }

        public void addBeforeStep(OutputStep outputStep) {
            this.beforeSteps.add(outputStep);
        }

        public void addAfterStep(OutputStep outputStep) {
            this.afterSteps.add(outputStep);
        }

        public List<OutputStep> getBeforeSteps() {
            return this.beforeSteps;
        }

        public List<OutputStep> getAfterSteps() {
            return this.afterSteps;
        }

        public List<String> getPendingMethods() {
            return this.pendingMethods;
        }

        public List<OutputScenario> getScenarios() {
            return this.scenarios;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public StoryDuration getStoryDuration() {
            return this.storyDuration;
        }
    }

    public static class OutputKeywords {
        private final Keywords keywords;

        public OutputKeywords(Keywords keywords) {
            this.keywords = keywords;
        }

        public String getLifecycle() {
            return this.keywords.lifecycle();
        }

        public String getScope() {
            return this.keywords.scope();
        }

        public String getScopeScenario() {
            return this.keywords.scopeScenario();
        }

        public String getScopeStory() {
            return this.keywords.scopeStory();
        }

        public String getBefore() {
            return this.keywords.before();
        }

        public String getAfter() {
            return this.keywords.after();
        }

        public String getMeta() {
            return this.keywords.meta();
        }

        public String getMetaProperty() {
            return this.keywords.metaProperty();
        }

        public String getNarrative() {
            return this.keywords.narrative();
        }

        public String getInOrderTo() {
            return this.keywords.inOrderTo();
        }

        public String getAsA() {
            return this.keywords.asA();
        }

        public String getiWantTo() {
            return this.keywords.iWantTo();
        }

        public String getSoThat() {
            return this.keywords.soThat();
        }

        public String getScenario() {
            return this.keywords.scenario();
        }

        public String getGivenStories() {
            return this.keywords.givenStories();
        }

        public String getExamplesTable() {
            return this.keywords.examplesTable();
        }

        public String getExamplesTableRow() {
            return this.keywords.examplesTableRow();
        }

        public String getExamplesTableHeaderSeparator() {
            return this.keywords.examplesTableHeaderSeparator();
        }

        public String getExamplesTableValueSeparator() {
            return this.keywords.examplesTableValueSeparator();
        }

        public String getExamplesTableIgnorableSeparator() {
            return this.keywords.examplesTableIgnorableSeparator();
        }

        public String getGiven() {
            return this.keywords.given();
        }

        public String getWhen() {
            return this.keywords.when();
        }

        public String getThen() {
            return this.keywords.then();
        }

        public String getAnd() {
            return this.keywords.and();
        }

        public String getIgnorable() {
            return this.keywords.ignorable();
        }

        public String getPending() {
            return this.keywords.pending();
        }

        public String getNotPerformed() {
            return this.keywords.notPerformed();
        }

        public String getFailed() {
            return this.keywords.failed();
        }

        public String getDryRun() {
            return this.keywords.dryRun();
        }

        public String getStoryCancelled() {
            return this.keywords.storyCancelled();
        }

        public String getDuration() {
            return this.keywords.duration();
        }

        public String getOutcome() {
            return this.keywords.outcome();
        }

        public String getMetaFilter() {
            return this.keywords.metaFilter();
        }

        public String getYes() {
            return this.keywords.yes();
        }

        public String getNo() {
            return this.keywords.no();
        }
    }
}

