/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.steps.Timing;

public class TeamCityConsoleOutput
extends ConsoleOutput {
    private static final String TEAMCITY_EVENT = "##teamcity[{0} name=''{1}'']\n";
    private static final String TEAMCITY_EVENT_MESSAGE = "##teamcity[{0} name=''{1}'' message=''{2}'']\n";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
    private String eventName;
    private Keywords keywords;

    public TeamCityConsoleOutput() {
        this(new LocalizedKeywords());
    }

    public TeamCityConsoleOutput(Keywords keywords) {
        super(keywords);
        this.keywords = keywords;
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        this.eventName = this.keywords.scenario() + this.scenarioTitle(scenario);
        this.print(this.format("testStarted", this.eventName));
        super.beforeScenario(scenario);
    }

    @Override
    public void afterScenario(Timing timing) {
        super.afterScenario(timing);
        this.print(this.format("testFinished", this.eventName));
        this.eventName = null;
    }

    @Override
    public void pending(String step) {
        super.pending(step);
        this.print(this.format("testIgnored", this.eventName));
    }

    @Override
    public void failed(String step, Throwable storyFailure) {
        super.failed(step, storyFailure);
        this.print(this.format("testFailed", this.eventName, storyFailure.getMessage()));
    }

    private String format(String event, String name) {
        return MessageFormat.format(TEAMCITY_EVENT, event, name);
    }

    private String format(String event, String name, String message) {
        return MessageFormat.format(TEAMCITY_EVENT_MESSAGE, event, name, message);
    }

    private String scenarioTitle(Scenario scenario) {
        String scenarioTitle = scenario.getTitle();
        if (StringUtils.isEmpty((CharSequence)scenarioTitle)) {
            scenarioTitle = "scenario-" + DATE_FORMAT.format(new Date());
        }
        return scenarioTitle;
    }
}

