/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.Timing;

public class SilentSuccessFilter
extends NullStoryReporter {
    private final StoryReporter delegate;
    private State runState = State.SILENT;
    private State beforeStoryState = State.SILENT;
    private State afterStoryState = State.SILENT;
    private State scenarioState = State.SILENT;
    private List<Todo> scenarioTodos = new ArrayList<Todo>();
    private boolean givenStory;

    public SilentSuccessFilter(StoryReporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void dryRun() {
        this.runState = this.createState(this.delegate::dryRun);
        this.runState.report();
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.runState = this.createState(() -> this.delegate.pendingMethods(methods));
        this.runState.report();
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.givenStory = givenStory;
        this.beforeStoryState = this.createState(() -> {
            this.delegate.beforeStory(story, givenStory);
            this.beforeStoryState = State.SILENT;
        });
    }

    @Override
    public void narrative(Narrative narrative) {
        this.beforeStoryState = this.createState(() -> this.delegate.narrative(narrative));
        this.beforeStoryState.report();
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        this.beforeStoryState = this.createState(() -> this.delegate.lifecycle(lifecycle));
        this.beforeStoryState.report();
    }

    @Override
    public void storyExcluded(Story story, String filter) {
        this.beforeStoryState = this.createState(() -> this.delegate.storyExcluded(story, filter));
        this.beforeStoryState.report();
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.afterStoryState.report();
    }

    @Override
    public void ignorable(String step) {
        this.addScenarioTodo(() -> this.delegate.ignorable(step));
    }

    @Override
    public void comment(String step) {
        this.addScenarioTodo(() -> this.delegate.comment(step));
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.addScenarioTodo(() -> this.delegate.failed(step, cause));
        this.setStateToNoisy();
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.addScenarioTodo(() -> this.delegate.failedOutcomes(step, table));
        this.setStateToNoisy();
    }

    @Override
    public void notPerformed(String step) {
        this.addScenarioTodo(() -> this.delegate.notPerformed(step));
        this.setStateToNoisy();
    }

    @Override
    public void pending(String step) {
        this.addScenarioTodo(() -> this.delegate.pending(step));
        this.setStateToNoisy();
    }

    @Override
    public void successful(String step) {
        this.addScenarioTodo(() -> this.delegate.successful(step));
    }

    @Override
    public void afterScenario(Timing timing) {
        this.addScenarioTodo(() -> this.delegate.afterScenario(timing));
        this.scenarioState.report();
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        this.scenarioTodos = new ArrayList<Todo>();
        this.addScenarioTodo(() -> this.delegate.beforeScenario(scenario));
    }

    @Override
    public void scenarioExcluded(Scenario scenario, String filter) {
        this.scenarioState = this.createState(() -> this.delegate.scenarioExcluded(scenario, filter));
        this.scenarioState.report();
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        this.addScenarioTodo(() -> this.delegate.givenStories(givenStories));
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.addScenarioTodo(() -> this.delegate.givenStories(storyPaths));
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.addScenarioTodo(() -> this.delegate.beforeExamples(steps, table));
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        this.addScenarioTodo(() -> this.delegate.example(tableRow, exampleIndex));
    }

    @Override
    public void afterExamples() {
        this.addScenarioTodo(() -> this.delegate.afterExamples());
    }

    private void addScenarioTodo(final Runnable todoAction) {
        this.scenarioTodos.add(new Todo(){

            @Override
            public void doNow() {
                todoAction.run();
            }
        });
    }

    private State createState(final Runnable stateReporter) {
        return new State(){

            @Override
            public void report() {
                stateReporter.run();
            }
        };
    }

    private void setStateToNoisy() {
        this.scenarioState = new State(){

            @Override
            public void report() {
                SilentSuccessFilter.this.beforeStoryState.report();
                for (Todo todo : SilentSuccessFilter.this.scenarioTodos) {
                    todo.doNow();
                }
                SilentSuccessFilter.this.afterStoryState = new State(){

                    @Override
                    public void report() {
                        SilentSuccessFilter.this.delegate.afterStory(SilentSuccessFilter.this.givenStory);
                        SilentSuccessFilter.this.afterStoryState = State.SILENT;
                    }
                };
                SilentSuccessFilter.this.scenarioState = State.SILENT;
            }
        };
    }

    private static interface State {
        public static final State SILENT = new State(){

            @Override
            public void report() {
            }
        };

        public void report();
    }

    private static interface Todo {
        public void doNow();
    }
}

