/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Step;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.Timing;

public class DelegatingStoryReporter
implements StoryReporter {
    private final Collection<StoryReporter> delegates;

    public DelegatingStoryReporter(Collection<StoryReporter> delegates) {
        this.delegates = delegates;
    }

    public DelegatingStoryReporter(StoryReporter ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public void beforeStoriesSteps(StepCollector.Stage stage) {
        this.delegate(reporter -> reporter.beforeStoriesSteps(stage));
    }

    @Override
    public void afterStoriesSteps(StepCollector.Stage stage) {
        this.delegate(reporter -> reporter.afterStoriesSteps(stage));
    }

    @Override
    public void afterScenario(Timing timing) {
        this.delegate(reporter -> reporter.afterScenario(timing));
    }

    @Override
    public void afterScenarios() {
        this.delegate(StoryReporter::afterScenarios);
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.delegate(reporter -> reporter.afterStory(givenStory));
    }

    @Override
    public void beforeScenarios() {
        this.delegate(StoryReporter::beforeScenarios);
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        this.delegate(reporter -> reporter.beforeScenario(scenario));
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.delegate(reporter -> reporter.beforeStory(story, givenStory));
    }

    @Override
    public void narrative(Narrative narrative) {
        this.delegate(reporter -> reporter.narrative(narrative));
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        this.delegate(reporter -> reporter.lifecycle(lifecycle));
    }

    @Override
    public void beforeScenarioSteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.delegate(reporter -> reporter.beforeScenarioSteps(stage, type));
    }

    @Override
    public void afterScenarioSteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.delegate(reporter -> reporter.afterScenarioSteps(stage, type));
    }

    @Override
    public void beforeComposedSteps() {
        this.delegate(StoryReporter::beforeComposedSteps);
    }

    @Override
    public void afterComposedSteps() {
        this.delegate(StoryReporter::afterComposedSteps);
    }

    @Override
    public void beforeStorySteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.delegate(reporter -> reporter.beforeStorySteps(stage, type));
    }

    @Override
    public void afterStorySteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        this.delegate(reporter -> reporter.afterStorySteps(stage, type));
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.delegate(reporter -> reporter.beforeExamples(steps, table));
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        this.delegate(reporter -> reporter.example(tableRow, exampleIndex));
    }

    @Override
    public void afterExamples() {
        this.delegate(StoryReporter::afterExamples);
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.delegate(reporter -> reporter.failed(step, cause));
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.delegate(reporter -> reporter.failedOutcomes(step, table));
    }

    @Override
    public void beforeGivenStories() {
        this.delegate(StoryReporter::beforeGivenStories);
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        this.delegate(reporter -> reporter.givenStories(givenStories));
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.delegate(reporter -> reporter.givenStories(storyPaths));
    }

    @Override
    public void afterGivenStories() {
        this.delegate(StoryReporter::afterGivenStories);
    }

    @Override
    public void beforeStep(Step step) {
        this.delegate(reporter -> reporter.beforeStep(step));
    }

    @Override
    public void ignorable(String step) {
        this.delegate(reporter -> reporter.ignorable(step));
    }

    @Override
    public void comment(String step) {
        this.delegate(reporter -> reporter.comment(step));
    }

    @Override
    public void notPerformed(String step) {
        this.delegate(reporter -> reporter.notPerformed(step));
    }

    @Override
    public void pending(String step) {
        this.delegate(reporter -> reporter.pending(step));
    }

    @Override
    public void successful(String step) {
        this.delegate(reporter -> reporter.successful(step));
    }

    @Override
    public void scenarioExcluded(Scenario scenario, String filter) {
        this.delegate(reporter -> reporter.scenarioExcluded(scenario, filter));
    }

    @Override
    public void storyExcluded(Story story, String filter) {
        this.delegate(reporter -> reporter.storyExcluded(story, filter));
    }

    @Override
    public void dryRun() {
        this.delegate(StoryReporter::dryRun);
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.delegate(reporter -> reporter.pendingMethods(methods));
    }

    @Override
    public void restarted(String step, Throwable cause) {
        this.delegate(reporter -> reporter.restarted(step, cause));
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        this.delegate(reporter -> reporter.restartedStory(story, cause));
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.delegate(reporter -> reporter.storyCancelled(story, storyDuration));
    }

    private void delegate(Consumer<StoryReporter> reporter) {
        this.delegates.forEach(reporter);
    }

    public Collection<StoryReporter> getDelegates() {
        return this.delegates;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

