/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.Alias;
import org.jbehave.core.model.AliasVariant;
import org.jbehave.core.parsers.AliasParser;
import org.jbehave.core.steps.StepType;

public class JsonAliasParser
implements AliasParser {
    private final Keywords keywords;

    public JsonAliasParser(Keywords keywords) {
        this.keywords = keywords;
    }

    @Override
    public Collection<Alias> parse(Set<String> aliasesAsStrings) {
        if (aliasesAsStrings.isEmpty()) {
            return Collections.emptyList();
        }
        Gson gson = new Gson();
        Type aliasType = new TypeToken<List<AliasContainer>>(){}.getType();
        return aliasesAsStrings.stream().map(json -> (List)gson.fromJson(json, aliasType)).flatMap(Collection::stream).map(JsonAliasParser::validate).collect(Collectors.groupingBy(rec$ -> ((AliasContainer)rec$).getName(), Collectors.collectingAndThen(Collectors.toList(), JsonAliasParser::mergeAliases))).values().stream().map(this::convert).collect(Collectors.toList());
    }

    private static AliasContainer validate(AliasContainer alias) {
        Validate.isTrue((alias.getName() != null ? 1 : 0) != 0, (String)"The 'name' property that identifies step must be set", (Object[])new Object[0]);
        Set aliases = alias.getAliases();
        Validate.isTrue((aliases != null ? 1 : 0) != 0, (String)"The 'aliases' property must be set", (Object[])new Object[0]);
        aliases.forEach(entry -> Validate.isTrue((((AliasEntry)entry).getName() != null ? 1 : 0) != 0, (String)"The 'name' property of alias must be set", (Object[])new Object[0]));
        return alias;
    }

    private static AliasContainer mergeAliases(List<AliasContainer> aliases) {
        if (aliases.size() == 1) {
            return aliases.get(0);
        }
        return (AliasContainer)aliases.stream().reduce((l, r) -> {
            ((AliasContainer)l).getAliases().addAll(((AliasContainer)r).getAliases());
            return l;
        }).get();
    }

    private Alias convert(AliasContainer container) {
        String name = container.getName();
        StepType stepType = this.keywords.stepTypeFor(name);
        List<AliasVariant> variants = container.getAliases().stream().map(alias -> {
            String aliasName = ((AliasEntry)alias).getName();
            StepType aliasType = this.keywords.stepTypeFor(((AliasEntry)alias).getName());
            if (aliasType != stepType) {
                throw new InvalidAliasType(aliasName, stepType);
            }
            return this.keywords.stepWithoutStartingWord(aliasName, aliasType);
        }).map(AliasVariant::new).collect(Collectors.toList());
        return new Alias(this.keywords.stepWithoutStartingWord(name, stepType), stepType, variants);
    }

    public static class InvalidAliasType
    extends RuntimeException {
        public InvalidAliasType(String alias, StepType stepType) {
            super(String.format("The alias '%s' must be of type '%s'", new Object[]{alias, stepType}));
        }
    }

    private static final class AliasEntry {
        private String name;

        private AliasEntry() {
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AliasEntry)) {
                return false;
            }
            AliasEntry other = (AliasEntry)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    private static final class AliasContainer {
        private String name;
        private Set<AliasEntry> aliases;

        private AliasContainer() {
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        private Set<AliasEntry> getAliases() {
            return this.aliases;
        }

        private void setAliases(Set<AliasEntry> aliases) {
            this.aliases = aliases;
        }
    }
}

