/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.TableParsers;

public class TableTransformers {
    public static final String FROM_LANDSCAPE = "FROM_LANDSCAPE";
    public static final String FORMATTING = "FORMATTING";
    public static final String REPLACING = "REPLACING";
    private final Map<String, TableTransformer> transformers = new HashMap<String, TableTransformer>();

    public TableTransformers() {
        this.useTransformer(FROM_LANDSCAPE, new FromLandscape());
        this.useTransformer(FORMATTING, new Formatting());
        this.useTransformer(REPLACING, new Replacing());
    }

    public String transform(String transformerName, String tableAsString, TableParsers tableParsers, ExamplesTable.TableProperties properties) {
        TableTransformer transformer = this.transformers.get(transformerName);
        if (transformer != null) {
            return transformer.transform(tableAsString, tableParsers, properties);
        }
        return tableAsString;
    }

    public void useTransformer(String name, TableTransformer transformer) {
        this.transformers.put(name, transformer);
    }

    public static class Replacing
    implements TableTransformer {
        @Override
        public String transform(String tableAsString, TableParsers tableParsers, ExamplesTable.TableProperties properties) {
            String replacing = properties.getProperties().getProperty("replacing");
            String replacement = properties.getProperties().getProperty("replacement");
            if (replacing == null || replacement == null) {
                return tableAsString;
            }
            return tableAsString.replace(replacing, replacement);
        }
    }

    public static class Formatting
    implements TableTransformer {
        @Override
        public String transform(String tableAsString, TableParsers tableParsers, ExamplesTable.TableProperties properties) {
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            for (String rowAsString : tableAsString.split(properties.getRowSeparator())) {
                if (this.ignoreRow(rowAsString, properties.getIgnorableSeparator())) continue;
                data.add(tableParsers.parseRow(rowAsString, rowAsString.contains(properties.getHeaderSeparator()), properties));
            }
            StringBuilder builder = new StringBuilder();
            Map<Integer, Integer> maxWidths = this.maxWidth(data);
            for (int r = 0; r < data.size(); ++r) {
                String formattedRow = this.formatRow((List)data.get(r), maxWidths, r == 0 ? properties.getHeaderSeparator() : properties.getValueSeparator());
                builder.append(formattedRow).append(properties.getRowSeparator());
            }
            return builder.toString();
        }

        private boolean ignoreRow(String rowAsString, String ignorableSeparator) {
            return rowAsString.startsWith(ignorableSeparator) || rowAsString.length() == 0;
        }

        private Map<Integer, Integer> maxWidth(List<List<String>> data) {
            HashMap<Integer, Integer> maxWidths = new HashMap<Integer, Integer>();
            for (List<String> row : data) {
                for (int c = 0; c < row.size(); ++c) {
                    String cell = row.get(c).trim();
                    Integer width = (Integer)maxWidths.get(c);
                    int length = cell.length();
                    if (width != null && length <= width) continue;
                    width = length;
                    maxWidths.put(c, width);
                }
            }
            return maxWidths;
        }

        private String formatRow(List<String> row, Map<Integer, Integer> maxWidths, String separator) {
            StringBuilder builder = new StringBuilder();
            builder.append(separator);
            for (int c = 0; c < row.size(); ++c) {
                builder.append(this.formatValue(row.get(c).trim(), maxWidths.get(c))).append(separator);
            }
            return builder.toString();
        }

        private String formatValue(String value, int width) {
            if (value.length() < width) {
                return value + this.padding(width - value.length());
            }
            return value;
        }

        private String padding(int size) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class FromLandscape
    implements TableTransformer {
        @Override
        public String transform(String tableAsString, TableParsers tableParsers, ExamplesTable.TableProperties properties) {
            LinkedHashMap<String, ArrayList<String>> data = new LinkedHashMap<String, ArrayList<String>>();
            for (String rowAsString : tableAsString.split(properties.getRowSeparator())) {
                if (this.ignoreRow(rowAsString, properties.getIgnorableSeparator())) continue;
                List<String> values = tableParsers.parseRow(rowAsString, false, properties);
                String header = values.get(0);
                ArrayList<String> rowValues = new ArrayList<String>(values);
                rowValues.remove(0);
                data.put(header, rowValues);
            }
            if (data.values().stream().mapToInt(List::size).distinct().count() != 1L) {
                String errorMessage = data.entrySet().stream().map(e -> {
                    int numberOfCells = ((List)e.getValue()).size();
                    StringBuilder rowDescription = new StringBuilder((String)e.getKey()).append(" -> ").append(numberOfCells).append(" cell");
                    if (numberOfCells > 1) {
                        rowDescription.append('s');
                    }
                    return rowDescription.toString();
                }).collect(Collectors.joining(", ", "The table rows have unequal numbers of cells: ", ""));
                throw new IllegalArgumentException(errorMessage);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(properties.getHeaderSeparator());
            for (String header : data.keySet()) {
                builder.append(header).append(properties.getHeaderSeparator());
            }
            builder.append(properties.getRowSeparator());
            int numberOfCells = ((List)data.values().iterator().next()).size();
            for (int c = 0; c < numberOfCells; ++c) {
                builder.append(properties.getValueSeparator());
                for (List row : data.values()) {
                    builder.append((String)row.get(c)).append(properties.getValueSeparator());
                }
                builder.append(properties.getRowSeparator());
            }
            return builder.toString();
        }

        private boolean ignoreRow(String rowAsString, String ignorableSeparator) {
            return rowAsString.startsWith(ignorableSeparator) || rowAsString.length() == 0;
        }
    }

    public static interface TableTransformer {
        public String transform(String var1, TableParsers var2, ExamplesTable.TableProperties var3);
    }
}

