/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.steps.ParameterConverters;

public class TableParsers {
    private static final String ROW_SEPARATOR_PATTERN = "\r?\n";
    private final Keywords keywords;
    private final ParameterConverters parameterConverters;
    private final Optional<String> defaultNullPlaceholder;

    public TableParsers(ParameterConverters parameterConverters) {
        this(new LocalizedKeywords(), parameterConverters);
    }

    public TableParsers(Keywords keywords, ParameterConverters parameterConverters) {
        this(keywords, parameterConverters, Optional.empty());
    }

    public TableParsers(Keywords keywords, ParameterConverters parameterConverters, Optional<String> defaultNullPlaceholder) {
        this.keywords = keywords;
        this.parameterConverters = parameterConverters;
        this.defaultNullPlaceholder = defaultNullPlaceholder;
    }

    public ExamplesTable.TablePropertiesQueue parseProperties(String tableAsString) {
        LinkedList<ExamplesTable.TableProperties> properties = new LinkedList<ExamplesTable.TableProperties>();
        String tableWithoutProperties = tableAsString.trim();
        Matcher matcher = ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(tableWithoutProperties);
        while (matcher.matches()) {
            String propertiesAsString = matcher.group(1);
            propertiesAsString = StringUtils.replace((String)propertiesAsString, (String)"\\{", (String)"{");
            propertiesAsString = StringUtils.replace((String)propertiesAsString, (String)"\\}", (String)"}");
            properties.add(new ExamplesTable.TableProperties(propertiesAsString, this.keywords, this.parameterConverters));
            tableWithoutProperties = matcher.group(2).trim();
            matcher = ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(tableWithoutProperties);
        }
        if (properties.isEmpty()) {
            properties.add(new ExamplesTable.TableProperties("", this.keywords, this.parameterConverters));
        }
        return new ExamplesTable.TablePropertiesQueue(tableWithoutProperties, properties);
    }

    public ExamplesTable.TableRows parseRows(String tableAsString, ExamplesTable.TableProperties properties) {
        String[] rows;
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (String row : rows = tableAsString.split(ROW_SEPARATOR_PATTERN)) {
            String trimmedRow = row.trim();
            if (trimmedRow.startsWith(properties.getIgnorableSeparator()) || trimmedRow.isEmpty()) continue;
            if (headers.isEmpty()) {
                headers.addAll(this.parseRow(trimmedRow, true, properties));
                continue;
            }
            List<String> columns = this.parseRow(trimmedRow, false, properties);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int column = 0; column < columns.size(); ++column) {
                if (column >= headers.size()) continue;
                map.put((String)headers.get(column), columns.get(column));
            }
            data.add(map);
        }
        return new ExamplesTable.TableRows(headers, data);
    }

    public List<String> parseRow(String rowAsString, boolean header, ExamplesTable.TableProperties properties) {
        String separator = header ? properties.getHeaderSeparator() : properties.getValueSeparator();
        String commentSeparator = properties.getCommentSeparator();
        Optional<String> nullPlaceholder = properties.getNullPlaceholder().map(Optional::of).orElse(this.defaultNullPlaceholder);
        UnaryOperator<String> trimmer = properties.isTrim() ? String::trim : UnaryOperator.identity();
        String[] cells = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rowAsString.trim(), (String)separator);
        ArrayList<String> row = new ArrayList<String>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            String cell = cells[i];
            cell = StringUtils.substringBefore((String)cell, (String)commentSeparator);
            if ((i == 0 || i == cells.length - 1) && cell.isEmpty()) continue;
            String trimmedCell = (String)trimmer.apply(cell);
            row.add(nullPlaceholder.filter(trimmedCell::equals).isPresent() ? null : trimmedCell);
        }
        return row;
    }
}

