/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.Matcher;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.i18n.LocalizedKeywords;

public class OutcomesTable {
    private static final String NEWLINE = "\n";
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private final Keywords keywords;
    private final Map<Type, String> formats;
    private final List<Outcome<?>> outcomes = new ArrayList();
    private final List<Outcome<?>> failedOutcomes = new ArrayList();
    private UUIDExceptionWrapper failureCause;

    public OutcomesTable() {
        this(new LocalizedKeywords());
    }

    public OutcomesTable(Keywords keywords) {
        this(keywords, OutcomesTable.defaultFormats());
    }

    public OutcomesTable(Map<Type, String> formats) {
        this((Keywords)new LocalizedKeywords(), formats);
    }

    public OutcomesTable(Keywords keywords, Map<Type, String> formats) {
        this.keywords = keywords;
        this.formats = this.mergeWithDefaults(formats);
    }

    @Deprecated
    public OutcomesTable(Keywords keywords, String dateFormat) {
        this(keywords, OutcomesTable.mergeWithDefaults(Date.class, dateFormat));
    }

    public <T> void addOutcome(String description, T value, Matcher<T> matcher) {
        this.outcomes.add(new Outcome<T>(description, value, matcher));
    }

    public void verify() {
        boolean failed = false;
        this.failedOutcomes.clear();
        for (Outcome<?> outcome : this.outcomes) {
            if (outcome.isVerified()) continue;
            this.failedOutcomes.add(outcome);
            failed = true;
            break;
        }
        if (failed) {
            this.failureCause = new UUIDExceptionWrapper(new OutcomesFailed(this));
            throw this.failureCause;
        }
    }

    public UUIDExceptionWrapper failureCause() {
        return this.failureCause;
    }

    public List<Outcome<?>> getOutcomes() {
        return this.outcomes;
    }

    public List<Outcome<?>> getFailedOutcomes() {
        return this.failedOutcomes;
    }

    public List<String> getOutcomeFields() {
        return this.keywords.outcomeFields();
    }

    public Map<Type, String> getFormats() {
        return this.formats;
    }

    public String getFormat(Type type) {
        return this.formats.get(type);
    }

    public String getFormat(String typeName) {
        try {
            return this.getFormat(Class.forName(typeName));
        }
        catch (ClassNotFoundException e) {
            throw new FormatTypeInvalid(typeName, e);
        }
    }

    @Deprecated
    public String getDateFormat() {
        return this.getFormat((Type)((Object)Date.class));
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.getOutcomeFields().iterator();
        while (iterator.hasNext()) {
            sb.append("|").append(iterator.next());
            if (iterator.hasNext()) continue;
            sb.append("|").append(NEWLINE);
        }
        for (Outcome<?> outcome : this.outcomes) {
            sb.append("|").append(outcome.getDescription()).append("|").append(outcome.getValue()).append("|").append(outcome.getMatcher()).append("|").append(outcome.isVerified()).append("|").append(NEWLINE);
        }
        return sb.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static Map<Type, String> defaultFormats() {
        HashMap<Type, String> map = new HashMap<Type, String>();
        map.put((Type)((Object)Date.class), "EEE MMM dd hh:mm:ss zzz yyyy");
        map.put((Type)((Object)Number.class), "0.###");
        map.put((Type)((Object)Boolean.class), "yes,no");
        return map;
    }

    private static Map<Type, String> mergeWithDefaults(Type type, String format) {
        Map<Type, String> map = OutcomesTable.defaultFormats();
        map.put(type, format);
        return map;
    }

    private Map<Type, String> mergeWithDefaults(Map<Type, String> formats) {
        Map<Type, String> map = OutcomesTable.defaultFormats();
        map.putAll(formats);
        return map;
    }

    public static class FormatTypeInvalid
    extends RuntimeException {
        public FormatTypeInvalid(String type, Throwable e) {
            super(type, e);
        }
    }

    public static class OutcomesFailed
    extends UUIDExceptionWrapper {
        private transient OutcomesTable outcomes;

        public OutcomesFailed(OutcomesTable outcomes) {
            this.outcomes = outcomes;
        }

        public OutcomesTable outcomesTable() {
            return this.outcomes;
        }
    }

    public static class Outcome<T> {
        private final String description;
        private final T value;
        private final Matcher<T> matcher;
        private final boolean verified;

        public Outcome(String description, T value, Matcher<T> matcher) {
            this.description = description;
            this.value = value;
            this.matcher = matcher;
            this.verified = matcher.matches(value);
        }

        public String getDescription() {
            return this.description;
        }

        public T getValue() {
            return this.value;
        }

        public Matcher<T> getMatcher() {
            return this.matcher;
        }

        public boolean isVerified() {
            return this.verified;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

