/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.junit;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.junit.JUnit4DescriptionGenerator;
import org.jbehave.core.junit.TextManipulator;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Step;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.Timing;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class JUnit4StoryReporter
extends NullStoryReporter {
    private final RunNotifier notifier;
    private final Description rootDescription;
    private final Keywords keywords;
    private PendingStepStrategy pendingStepStrategy = new PassingUponPendingStep();
    private final ThreadLocal<TestState> testState = ThreadLocal.withInitial(() -> new TestState());
    private final AtomicInteger testCounter = new AtomicInteger();

    public JUnit4StoryReporter(RunNotifier notifier, Description rootDescription, Keywords keywords) {
        this.rootDescription = rootDescription;
        this.notifier = notifier;
        this.keywords = keywords;
    }

    @Override
    public void beforeStoriesSteps(StepCollector.Stage stage) {
        String name = null;
        if (stage == StepCollector.Stage.BEFORE) {
            this.notifier.fireTestRunStarted(this.rootDescription);
            name = "BeforeStories";
        } else if (stage == StepCollector.Stage.AFTER) {
            name = "AfterStories";
        }
        Description storyDescription = this.findStoryDescription(name);
        TestState testState = this.testState.get();
        testState.currentStoryDescription = storyDescription;
        testState.currentStep = storyDescription;
        this.notifier.fireTestStarted(storyDescription);
    }

    @Override
    public void afterStoriesSteps(StepCollector.Stage stage) {
        TestState testState = this.testState.get();
        this.notifier.fireTestFinished(testState.currentStoryDescription);
        if (stage == StepCollector.Stage.AFTER) {
            Result result = new Result();
            this.notifier.fireTestRunFinished(result);
        }
    }

    @Override
    public void beforeStory(Story story, boolean isGivenStory) {
        TestState testState = this.testState.get();
        if (isGivenStory) {
            if (testState.currentStep != null) {
                this.notifier.fireTestStarted(testState.currentStep);
            }
            testState.givenStoryLevel++;
        } else {
            Description storyDescription = this.findStoryDescription(story.getName());
            testState.currentStoryDescription = storyDescription;
            this.notifier.fireTestStarted(storyDescription);
            if (storyDescription.isSuite()) {
                testState.scenarioDescriptions = this.filter(storyDescription.getChildren(), (Collection<Pair<ElementAction, Predicate<Description>>>)ImmutableList.of((Object)Pair.of((Object)((Object)ElementAction.DROP), this.isTest()), (Object)Pair.of((Object)((Object)ElementAction.TAKE), this.isSuite()))).iterator();
                testState.moveToNextScenario();
            }
            testState.currentStep = testState.currentStoryDescription;
        }
    }

    @Override
    public void beforeStorySteps(StepCollector.Stage stage, Lifecycle.ExecutionType type) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            if (stage == StepCollector.Stage.BEFORE && type == Lifecycle.ExecutionType.SYSTEM) {
                this.loadStepDescriptions(this.filter(testState.getStoryChildren(), (Collection<Pair<ElementAction, Predicate<Description>>>)ImmutableList.of((Object)Pair.of((Object)((Object)ElementAction.TAKE), this.isTest()))));
            }
            if (stage == StepCollector.Stage.AFTER && type == Lifecycle.ExecutionType.USER) {
                this.loadStepDescriptions(this.filter(testState.getStoryChildren(), (Collection<Pair<ElementAction, Predicate<Description>>>)ImmutableList.of((Object)Pair.of((Object)((Object)ElementAction.DROP), this.isTest()), (Object)Pair.of((Object)((Object)ElementAction.DROP), this.isSuite()), (Object)Pair.of((Object)((Object)ElementAction.TAKE), this.isTest()))));
            }
        }
    }

    private void loadStepDescriptions(List<Description> stepDescriptions) {
        TestState testState = this.testState.get();
        testState.loadStepDescriptions(stepDescriptions);
        if (testState.stepDescriptions.hasNext()) {
            testState.moveToNextStep();
        }
    }

    private Predicate<Description> isTest() {
        return description -> description.getAnnotation(JUnit4DescriptionGenerator.JUnit4Test.class) != null;
    }

    private Predicate<Description> isSuite() {
        return this.isTest().negate();
    }

    private List<Description> filter(List<Description> descriptions, Collection<Pair<ElementAction, Predicate<Description>>> filters) {
        Iterator<Pair<ElementAction, Predicate<Description>>> filtersIterator = filters.iterator();
        Pair<ElementAction, Predicate<Description>> currentFilter = filtersIterator.next();
        ArrayList<Description> resultDescriptions = new ArrayList<Description>();
        for (Description description : descriptions) {
            while (!((Predicate)currentFilter.getValue()).test(description)) {
                if (!filtersIterator.hasNext()) {
                    return resultDescriptions;
                }
                currentFilter = filtersIterator.next();
            }
            ((ElementAction)((Object)currentFilter.getKey())).compute(resultDescriptions, description);
        }
        return resultDescriptions;
    }

    private Description findStoryDescription(String storyName) {
        String escapedStoryName = TextManipulator.escape(storyName);
        for (Description storyDescription : this.rootDescription.getChildren()) {
            if (storyDescription.getDisplayName().equals(escapedStoryName)) {
                return storyDescription;
            }
            if (!storyDescription.isTest() || storyDescription.getMethodName() == null || !storyDescription.getMethodName().equals(storyName)) continue;
            return storyDescription;
        }
        throw new IllegalStateException("No JUnit description found for story with name: " + storyName);
    }

    @Override
    public void afterStory(boolean isGivenStory) {
        TestState testState = this.testState.get();
        if (isGivenStory) {
            testState.givenStoryLevel--;
            if (testState.currentStep != null) {
                this.notifier.fireTestFinished(testState.currentStep);
            }
            this.prepareNextStep();
        } else {
            if (!testState.failedSteps.contains(testState.currentStoryDescription)) {
                this.notifier.fireTestFinished(testState.currentStoryDescription);
                if (testState.currentStoryDescription.isTest()) {
                    this.testCounter.incrementAndGet();
                }
            }
            this.testState.remove();
        }
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            this.notifier.fireTestStarted(testState.currentScenario);
            ArrayList children = testState.currentScenario.getChildren();
            List<Description> examples = this.filterExamples(children);
            if (!examples.isEmpty()) {
                testState.exampleDescriptions = examples.iterator();
                testState.currentExample = null;
            }
            if (children.size() > examples.size()) {
                ArrayList steps = new ArrayList(testState.currentScenario.getChildren());
                steps.removeAll(examples);
                testState.loadStepDescriptions(steps);
                testState.moveToNextStep();
            }
        }
    }

    private List<Description> filterExamples(List<Description> children) {
        for (int i = 0; i < children.size(); ++i) {
            Description child = children.get(i);
            boolean isExample = child.getDisplayName().startsWith(this.keywords.examplesTableRow() + " ");
            if (!isExample) continue;
            return children.subList(i, children.size());
        }
        return Collections.emptyList();
    }

    @Override
    public void afterScenario(Timing timing) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            this.notifier.fireTestFinished(testState.currentScenario);
            testState.moveToNextScenario();
        }
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            testState.moveToNextExample();
            testState.loadStepDescriptions(testState.currentExample.getChildren());
            testState.moveToNextStep();
        }
    }

    @Override
    public void beforeStep(Step step) {
        if (step.getExecutionType() != StepCreator.StepExecutionType.EXECUTABLE) {
            return;
        }
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning() && testState.currentStep != null) {
            if (testState.currentStep == testState.currentStoryDescription) {
                testState.currentStep = testState.currentScenario;
            }
            if (testState.currentStepStatus == StepStatus.STARTED) {
                testState.parentSteps.push(testState.currentStep);
                testState.moveToNextStep();
            }
            this.notifier.fireTestStarted(testState.currentStep);
            testState.currentStepStatus = StepStatus.STARTED;
        }
    }

    @Override
    public void failed(String step, Throwable e) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            Throwable thrownException = e instanceof UUIDExceptionWrapper ? e.getCause() : e;
            this.notifier.fireTestFailure(new Failure(testState.currentStep, thrownException));
            testState.failedSteps.add(testState.currentStep);
            this.finishStep(testState);
        }
    }

    @Override
    public void successful(String step) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            if (testState.currentStep != null) {
                this.finishStep(testState);
            } else {
                this.prepareNextStep();
            }
        }
    }

    private void prepareNextStep() {
        TestState testState = this.testState.get();
        if (testState.currentStep != null && testState.currentStep.isTest()) {
            this.testCounter.incrementAndGet();
        }
        if (testState.stepDescriptions != null && testState.stepDescriptions.hasNext()) {
            testState.moveToNextStep();
        }
    }

    private void finishStep(TestState testState) {
        if (testState.currentStepStatus == StepStatus.FINISHED && !testState.parentSteps.isEmpty()) {
            this.notifier.fireTestFinished((Description)testState.parentSteps.poll());
        } else {
            this.notifier.fireTestFinished(testState.currentStep);
            testState.currentStepStatus = StepStatus.FINISHED;
            this.prepareNextStep();
        }
    }

    @Override
    public void pending(String step) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            if (this.pendingStepStrategy instanceof FailingUponPendingStep) {
                this.notifier.fireTestStarted(testState.currentStep);
                this.notifier.fireTestFailure(new Failure(testState.currentStep, (Throwable)new RuntimeException("Step is pending!")));
                testState.failedSteps.add(testState.currentStep);
                this.finishStep(testState);
            } else {
                this.notifier.fireTestIgnored(testState.currentStep);
                this.prepareNextStep();
            }
        }
    }

    @Override
    public void ignorable(String step) {
        TestState testState = this.testState.get();
        if (!testState.isGivenStoryRunning()) {
            this.notifier.fireTestIgnored(testState.currentStep);
            testState.currentStepStatus = StepStatus.FINISHED;
            this.prepareNextStep();
        }
    }

    @Override
    public void notPerformed(String step) {
        this.ignorable(step);
    }

    @Override
    public void scenarioExcluded(Scenario scenario, String filter) {
        TestState testState = this.testState.get();
        this.notifier.fireTestIgnored(testState.currentStep);
        this.notifier.fireTestIgnored(testState.currentScenario);
    }

    public void usePendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        this.pendingStepStrategy = pendingStepStrategy;
    }

    private static enum ElementAction {
        DROP{

            @Override
            public <T> void compute(Collection<T> collection, T element) {
            }
        }
        ,
        TAKE{

            @Override
            public <T> void compute(Collection<T> collection, T element) {
                collection.add(element);
            }
        };


        public abstract <T> void compute(Collection<T> var1, T var2);
    }

    private static enum StepStatus {
        STARTED,
        FINISHED;

    }

    private class TestState {
        private Description currentStep;
        private StepStatus currentStepStatus;
        private final Deque<Description> parentSteps = new LinkedList<Description>();
        private Iterator<Description> stepDescriptions;
        private Description currentScenario;
        private Iterator<Description> scenarioDescriptions;
        private Description currentExample;
        private Iterator<Description> exampleDescriptions;
        private Description currentStoryDescription;
        private int givenStoryLevel;
        private final Set<Description> failedSteps = new HashSet<Description>();

        private TestState() {
        }

        private void moveToNextScenario() {
            this.currentStep = this.currentScenario = this.getNextOrNull(this.scenarioDescriptions);
            this.stepDescriptions = null;
        }

        private void moveToNextExample() {
            this.currentExample = this.getNextOrNull(this.exampleDescriptions);
        }

        private void moveToNextStep() {
            this.currentStep = this.getNextOrNull(this.stepDescriptions);
        }

        private boolean isGivenStoryRunning() {
            return this.givenStoryLevel != 0;
        }

        private void loadStepDescriptions(List<Description> steps) {
            this.stepDescriptions = this.getAllDescendants(steps).iterator();
        }

        private <T> T getNextOrNull(Iterator<T> iterator) {
            return iterator.hasNext() ? (T)iterator.next() : null;
        }

        private Collection<Description> getAllDescendants(List<Description> steps) {
            ArrayList<Description> descendants = new ArrayList<Description>();
            for (Description child : steps) {
                descendants.add(child);
                descendants.addAll(this.getAllDescendants(child.getChildren()));
            }
            return descendants;
        }

        private List<Description> getStoryChildren() {
            return this.currentStoryDescription.getChildren();
        }
    }
}

