/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.AllStepCandidates;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.junit.TextManipulator;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepType;
import org.junit.runner.Description;

public class JUnit4DescriptionGenerator {
    private final TextManipulator textManipulator = new TextManipulator();
    private final Configuration configuration;
    private final AllStepCandidates allStepCandidates;
    private String previousNonAndStep;
    private int testCases;
    private final JUnit4Test junitTestMeta;

    public JUnit4DescriptionGenerator(AllStepCandidates allStepCandidates, Configuration configuration) {
        this.configuration = configuration;
        this.allStepCandidates = allStepCandidates;
        this.junitTestMeta = new JUnit4Test(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JUnit4Test.class;
            }
        };
    }

    public List<Description> createDescriptionsFrom(PerformableTree performableTree) {
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        for (PerformableTree.PerformableStory performableStory : performableTree.getRoot().getStories()) {
            if (performableStory.isExcluded()) continue;
            Story story = performableStory.getStory();
            Lifecycle lifecycle = story.getLifecycle();
            Description storyDescription = this.createDescriptionForStory(story);
            this.addBeforeOrAfterStep(this.allStepCandidates.getBeforeStorySteps(false), storyDescription, "@BeforeStory: ");
            this.addSteps(storyDescription, lifecycle.getBeforeSteps(Scope.STORY));
            if (story.hasGivenStories()) {
                this.insertGivenStories(story.getGivenStories(), storyDescription);
            }
            List<PerformableTree.PerformableScenario> scenarios = performableStory.getScenarios();
            for (Description scenarioDescription : this.getScenarioDescriptions(lifecycle, scenarios)) {
                storyDescription.addChild(scenarioDescription);
            }
            this.addSteps(storyDescription, lifecycle.getAfterSteps(Scope.STORY, AfterScenario.Outcome.ANY));
            this.addBeforeOrAfterStep(this.allStepCandidates.getAfterStorySteps(false), storyDescription, "@AfterStory: ");
            storyDescriptions.add(storyDescription);
        }
        return storyDescriptions;
    }

    public Description createDescriptionsFrom(Lifecycle lifecycle, PerformableTree.PerformableScenario performableScenario) {
        Scenario scenario = performableScenario.getScenario();
        Description scenarioDescription = this.createDescriptionForScenario(scenario);
        if (performableScenario.hasExamples() && !scenario.getGivenStories().requireParameters()) {
            this.insertDescriptionForExamples(lifecycle, performableScenario, scenarioDescription);
        } else {
            this.addScenarioSteps(lifecycle, ScenarioType.NORMAL, scenario, scenarioDescription);
        }
        return scenarioDescription;
    }

    private void addScenarioSteps(Lifecycle lifecycle, ScenarioType scenarioType, Scenario scenario, Description scenarioDescription) {
        this.addBeforeOrAfterScenarioStep(this.allStepCandidates::getBeforeScenarioSteps, scenarioType, scenarioDescription, "@BeforeScenario: ");
        this.addSteps(scenarioDescription, lifecycle.getBeforeSteps(Scope.SCENARIO));
        if (scenario.hasGivenStories()) {
            this.insertGivenStories(scenario.getGivenStories(), scenarioDescription);
        }
        this.addScenarioSteps(lifecycle, scenarioDescription, scenario);
        this.addSteps(scenarioDescription, lifecycle.getAfterSteps(Scope.SCENARIO, AfterScenario.Outcome.ANY));
        this.addBeforeOrAfterScenarioStep(this.allStepCandidates::getAfterScenarioSteps, scenarioType, scenarioDescription, "@AfterScenario: ");
    }

    private void addScenarioSteps(Lifecycle lifecycle, Description scenarioDescription, Scenario scenario) {
        List<String> beforeSteps = lifecycle.getBeforeSteps(Scope.STEP);
        List<String> afterSteps = lifecycle.getAfterSteps(Scope.STEP);
        this.previousNonAndStep = null;
        String tempPreviousNonAndStep = null;
        for (String scenarioStep : scenario.getSteps()) {
            this.addSteps(scenarioDescription, beforeSteps);
            this.previousNonAndStep = tempPreviousNonAndStep;
            this.addStep(scenarioDescription, scenarioStep);
            tempPreviousNonAndStep = this.previousNonAndStep;
            this.addSteps(scenarioDescription, afterSteps);
        }
    }

    private void addBeforeOrAfterScenarioStep(Function<ScenarioType, List<BeforeOrAfterStep>> stepsProvider, ScenarioType scenarioType, Description description, String stepName) {
        ArrayList<BeforeOrAfterStep> beforeOrAfterSteps = new ArrayList<BeforeOrAfterStep>();
        beforeOrAfterSteps.addAll((Collection)stepsProvider.apply(scenarioType));
        beforeOrAfterSteps.addAll((Collection)stepsProvider.apply(ScenarioType.ANY));
        this.addBeforeOrAfterStep(beforeOrAfterSteps, description, stepName);
    }

    private void addBeforeOrAfterStep(List<BeforeOrAfterStep> beforeOrAfterSteps, Description description, String stepPrefix) {
        beforeOrAfterSteps.forEach(steps -> {
            ++this.testCases;
            Method method = steps.getMethod();
            String stepName = this.uniquify(stepPrefix + steps.getMethod().getName());
            Description testDescription = Description.createTestDescription(method.getDeclaringClass(), (String)stepName, (Annotation[])new Annotation[]{this.junitTestMeta});
            description.addChild(testDescription);
        });
    }

    public String uniquify(String string) {
        return this.textManipulator.uniquify(string);
    }

    public int getTestCases() {
        return this.testCases;
    }

    private void insertGivenStories(GivenStories givenStories, Description parentDescription) {
        for (String path : givenStories.getPaths()) {
            this.addGivenStory(parentDescription, path);
        }
    }

    private void addGivenStory(Description parentDescription, String path) {
        parentDescription.addChild(Description.createSuiteDescription((String)this.uniquify(this.getFilename(path)), (Annotation[])new Annotation[]{this.junitTestMeta}));
        ++this.testCases;
    }

    private String getFilename(String path) {
        return path.substring(path.lastIndexOf(47) + 1).split("#")[0];
    }

    private void insertDescriptionForExamples(Lifecycle lifecycle, PerformableTree.PerformableScenario performableScenario, Description scenarioDescription) {
        Scenario scenario = performableScenario.getScenario();
        for (PerformableTree.ExamplePerformableScenario examplePerformableScenario : performableScenario.getExamples()) {
            Description exampleRowDescription = Description.createSuiteDescription((String)(this.configuration.keywords().examplesTableRow() + " " + examplePerformableScenario.getParameters()), (Annotation[])new Annotation[0]);
            scenarioDescription.addChild(exampleRowDescription);
            this.addScenarioSteps(lifecycle, ScenarioType.EXAMPLE, scenario, exampleRowDescription);
        }
    }

    private void addSteps(Description description, List<String> steps) {
        this.previousNonAndStep = null;
        steps.forEach(step -> this.addStep(description, (String)step));
    }

    private void addStep(Description description, String step) {
        String stringStepOneLine = this.stripLinebreaks(step);
        StepCandidate matchingStep = this.findMatchingStep(step);
        if (matchingStep == null) {
            this.addNonExistingStep(description, stringStepOneLine, step);
        } else {
            this.addExistingStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addExistingStep(Description description, String stringStepOneLine, StepCandidate matchingStep) {
        if (matchingStep.isComposite()) {
            this.addCompositeSteps(description, stringStepOneLine, matchingStep);
        } else {
            this.addRegularStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addNonExistingStep(Description description, String stringStepOneLine, String stepAsString) {
        Keywords keywords = this.configuration.keywords();
        if (keywords.isIgnorableStep(stepAsString)) {
            if (this.isStep(keywords.stepWithoutStartingWord(stepAsString, StepType.IGNORABLE))) {
                this.addIgnorableStep(description, stringStepOneLine);
            }
        } else {
            this.addPendingStep(description, stringStepOneLine);
        }
    }

    private boolean isStep(String stepAsString) {
        Keywords keywords = this.configuration.keywords();
        for (String stepStartingWord : keywords.startingWordsByType().values()) {
            if (!keywords.stepStartsWithWord(stepAsString, stepStartingWord)) continue;
            return true;
        }
        return false;
    }

    private void addIgnorableStep(Description description, String stringStep) {
        ++this.testCases;
        description.addChild(Description.createSuiteDescription((String)stringStep, (Annotation[])new Annotation[0]));
    }

    private void addPendingStep(Description description, String stringStep) {
        ++this.testCases;
        description.addChild(Description.createSuiteDescription((String)this.uniquify("[PENDING] " + stringStep), (Annotation[])new Annotation[0]));
    }

    private void addRegularStep(Description description, String stringStep, StepCandidate step) {
        ++this.testCases;
        description.addChild(Description.createTestDescription(step.getStepsType(), (String)this.uniquify(stringStep), (Annotation[])new Annotation[]{this.junitTestMeta}));
    }

    private void addCompositeSteps(Description description, String stringStep, StepCandidate step) {
        Description testDescription = Description.createSuiteDescription((String)this.uniquify(stringStep), (Annotation[])new Annotation[]{this.junitTestMeta});
        this.addSteps(testDescription, Arrays.asList(step.composedSteps()));
        description.addChild(testDescription);
    }

    private List<Description> getScenarioDescriptions(Lifecycle lifecycle, List<PerformableTree.PerformableScenario> performableScenarios) {
        ArrayList<Description> scenarioDescriptions = new ArrayList<Description>();
        for (PerformableTree.PerformableScenario scenario : performableScenarios) {
            if (scenario.isExcluded()) continue;
            scenarioDescriptions.add(this.createDescriptionsFrom(lifecycle, scenario));
        }
        return scenarioDescriptions;
    }

    private StepCandidate findMatchingStep(String stringStep) {
        for (StepCandidate step : this.allStepCandidates.getRegularSteps()) {
            if (!step.matches(stringStep, this.previousNonAndStep)) continue;
            if (step.getStepType() != StepType.AND) {
                this.previousNonAndStep = step.getStartingWord() + " ";
            }
            return step;
        }
        return null;
    }

    private String stripLinebreaks(String stringStep) {
        if (stringStep.indexOf(10) != -1) {
            return stringStep.substring(0, stringStep.indexOf(10));
        }
        return stringStep;
    }

    private Description createDescriptionForStory(Story story) {
        return Description.createSuiteDescription((String)this.uniquify(story.getName()), (Annotation[])new Annotation[0]);
    }

    private Description createDescriptionForScenario(Scenario scenario) {
        return Description.createSuiteDescription((String)(this.configuration.keywords().scenario() + " " + this.uniquify(scenario.getTitle())), (Annotation[])new Annotation[0]);
    }

    public static @interface JUnit4Test {
    }
}

