/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryResourceNotFound;

public class LoadFromClasspath
implements StoryLoader {
    private final Charset charset;
    protected final ClassLoader classLoader;

    public LoadFromClasspath() {
        this(StandardCharsets.UTF_8);
    }

    public LoadFromClasspath(Charset charset) {
        this(Thread.currentThread().getContextClassLoader(), charset);
    }

    public LoadFromClasspath(Class<?> loadFromClass) {
        this(loadFromClass.getClassLoader());
    }

    public LoadFromClasspath(ClassLoader classLoader) {
        this(classLoader, StandardCharsets.UTF_8);
    }

    public LoadFromClasspath(ClassLoader classLoader, Charset charset) {
        this.classLoader = classLoader;
        this.charset = charset;
    }

    @Override
    public String loadResourceAsText(String resourcePath) {
        String string;
        block8: {
            InputStream stream = this.resourceAsStream(resourcePath);
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)this.charset);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidStoryResource(resourcePath, e);
                }
            }
            stream.close();
        }
        return string;
    }

    @Override
    public String loadStoryAsText(String storyPath) {
        return this.loadResourceAsText(storyPath);
    }

    protected InputStream resourceAsStream(String resourcePath) {
        InputStream stream = this.classLoader.getResourceAsStream(resourcePath);
        if (stream == null) {
            throw new StoryResourceNotFound(resourcePath, this.classLoader);
        }
        return stream;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

