/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepCandidate;

public class AllStepCandidates {
    private final List<BeforeOrAfterStep> beforeStoriesSteps = new ArrayList<BeforeOrAfterStep>();
    private final List<BeforeOrAfterStep> afterStoriesSteps = new ArrayList<BeforeOrAfterStep>();
    private final List<BeforeOrAfterStep> beforeGivenStorySteps = new ArrayList<BeforeOrAfterStep>();
    private final List<BeforeOrAfterStep> afterGivenStorySteps = new ArrayList<BeforeOrAfterStep>();
    private final List<BeforeOrAfterStep> beforeStorySteps = new ArrayList<BeforeOrAfterStep>();
    private final List<BeforeOrAfterStep> afterStorySteps = new ArrayList<BeforeOrAfterStep>();
    private final Map<ScenarioType, List<BeforeOrAfterStep>> beforeScenarioSteps = new EnumMap<ScenarioType, List<BeforeOrAfterStep>>(ScenarioType.class);
    private final Map<ScenarioType, List<BeforeOrAfterStep>> afterScenarioSteps = new EnumMap<ScenarioType, List<BeforeOrAfterStep>>(ScenarioType.class);
    private final List<StepCandidate> regularSteps = new ArrayList<StepCandidate>();

    public AllStepCandidates(List<CandidateSteps> candidateSteps) {
        for (ScenarioType type : ScenarioType.values()) {
            this.beforeScenarioSteps.put(type, new ArrayList());
            this.afterScenarioSteps.put(type, new ArrayList());
        }
        for (CandidateSteps candidateStep : candidateSteps) {
            this.beforeStoriesSteps.addAll(candidateStep.listBeforeStories());
            this.afterStoriesSteps.addAll(candidateStep.listAfterStories());
            this.beforeGivenStorySteps.addAll(candidateStep.listBeforeStory(true));
            this.afterGivenStorySteps.addAll(candidateStep.listAfterStory(true));
            this.beforeStorySteps.addAll(candidateStep.listBeforeStory(false));
            this.afterStorySteps.addAll(candidateStep.listAfterStory(false));
            candidateStep.listBeforeScenario().forEach((scenarioType, steps) -> this.beforeScenarioSteps.get(scenarioType).addAll((Collection<BeforeOrAfterStep>)steps));
            candidateStep.listAfterScenario().forEach((scenarioType, steps) -> this.afterScenarioSteps.get(scenarioType).addAll((Collection<BeforeOrAfterStep>)steps));
            this.regularSteps.addAll(candidateStep.listCandidates());
        }
        this.sortBeforeSteps(this.beforeStoriesSteps);
        this.sortAfterSteps(this.afterStoriesSteps);
        this.sortBeforeSteps(this.beforeGivenStorySteps);
        this.sortAfterSteps(this.afterGivenStorySteps);
        this.sortBeforeSteps(this.beforeStorySteps);
        this.sortAfterSteps(this.afterStorySteps);
        this.beforeScenarioSteps.values().forEach(this::sortBeforeSteps);
        this.afterScenarioSteps.values().forEach(this::sortAfterSteps);
    }

    private void sortBeforeSteps(List<BeforeOrAfterStep> beforeSteps) {
        this.sortSteps(beforeSteps, Comparator.reverseOrder());
    }

    private void sortAfterSteps(List<BeforeOrAfterStep> afterSteps) {
        this.sortSteps(afterSteps, Comparator.naturalOrder());
    }

    private void sortSteps(List<BeforeOrAfterStep> steps, Comparator<Integer> comparator) {
        steps.sort(Comparator.comparing(BeforeOrAfterStep::getOrder, comparator));
    }

    public List<BeforeOrAfterStep> getBeforeStoriesSteps() {
        return this.beforeStoriesSteps;
    }

    public List<BeforeOrAfterStep> getAfterStoriesSteps() {
        return this.afterStoriesSteps;
    }

    public List<BeforeOrAfterStep> getBeforeStorySteps(boolean givenStory) {
        return givenStory ? this.beforeGivenStorySteps : this.beforeStorySteps;
    }

    public List<BeforeOrAfterStep> getAfterStorySteps(boolean givenStory) {
        return givenStory ? this.afterGivenStorySteps : this.afterStorySteps;
    }

    public List<BeforeOrAfterStep> getBeforeScenarioSteps(ScenarioType scenarioType) {
        return this.beforeScenarioSteps.get((Object)scenarioType);
    }

    public List<BeforeOrAfterStep> getAfterScenarioSteps(ScenarioType scenarioType) {
        return this.afterScenarioSteps.get((Object)scenarioType);
    }

    public List<StepCandidate> getRegularSteps() {
        return this.regularSteps;
    }
}

