/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.CaseUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.KnownFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.Verbatim;
import org.jbehave.core.reporters.EscapeMode;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.core.reporters.StackTraceFormatter;
import org.jbehave.core.steps.StepCollector;

public abstract class PrintStreamOutput
extends NullStoryReporter {
    private static final String EMPTY = "";
    public static final String NL = "\n";
    private final Format format;
    private final PrintStream output;
    private final Properties outputPatterns;
    private final Keywords keywords;
    private ThreadLocal<Boolean> reportFailureTrace = new ThreadLocal();
    private ThreadLocal<Boolean> compressFailureTrace = new ThreadLocal();
    private ThreadLocal<Throwable> cause = new ThreadLocal();
    private ThreadLocal<Boolean> dryRun = ThreadLocal.withInitial(() -> false);

    protected PrintStreamOutput(Format format, PrintStream output, Properties defaultPatterns, Properties outputPatterns, Keywords keywords) {
        this(format, output, PrintStreamOutput.mergePatterns(defaultPatterns, outputPatterns), keywords, false, false);
    }

    protected PrintStreamOutput(Format format, PrintStream output, Properties defaultPatterns, Properties outputPatterns, Keywords keywords, boolean reportFailureTrace, boolean compressFailureTrace) {
        this(format, output, PrintStreamOutput.mergePatterns(defaultPatterns, outputPatterns), keywords, reportFailureTrace, compressFailureTrace);
    }

    protected PrintStreamOutput(Format format, PrintStream output, Properties outputPatterns, Keywords keywords, boolean reportFailureTrace, boolean compressFailureTrace) {
        this.format = format;
        this.output = output;
        this.outputPatterns = outputPatterns;
        this.keywords = keywords;
        this.doReportFailureTrace(reportFailureTrace);
        this.doCompressFailureTrace(compressFailureTrace);
    }

    private static Properties mergePatterns(Properties defaultPatterns, Properties outputPatterns) {
        Properties patterns = new Properties();
        patterns.putAll((Map<?, ?>)defaultPatterns);
        patterns.putAll((Map<?, ?>)outputPatterns);
        return patterns;
    }

    @Override
    public void beforeStep(String step) {
    }

    @Override
    public void successful(String step) {
        this.print(this.format("successful", "{0}\n", step));
    }

    @Override
    public void ignorable(String step) {
        this.print(this.format("ignorable", "{0}\n", step));
    }

    @Override
    public void comment(String step) {
        this.print(this.format("comment", "{0}\n", step));
    }

    @Override
    public void pending(String step) {
        this.print(this.format("pending", "{0} ({1})\n", step, this.keywords.pending()));
    }

    @Override
    public void notPerformed(String step) {
        this.print(this.format("notPerformed", "{0} ({1})\n", step, this.keywords.notPerformed()));
    }

    @Override
    public void failed(String step, Throwable storyFailure) {
        if (!(storyFailure instanceof UUIDExceptionWrapper)) {
            throw new ClassCastException(storyFailure + " should be an instance of UUIDExceptionWrapper");
        }
        this.cause.set(storyFailure.getCause());
        this.print(this.format("failed", "{0} ({1})\n({2})\n", step, this.keywords.failed(), storyFailure.getCause(), ((UUIDExceptionWrapper)storyFailure).getUUID()));
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.failed(step, table.failureCause());
        this.print(table);
    }

    private void print(OutcomesTable table) {
        this.print(this.format("outcomesTableStart", NL, new Object[0]));
        List<OutcomesTable.Outcome<?>> rows = table.getOutcomes();
        this.print(this.format("outcomesTableHeadStart", "|", new Object[0]));
        for (String string : table.getOutcomeFields()) {
            this.print(this.format("outcomesTableHeadCell", "{0}|", string));
        }
        this.print(this.format("outcomesTableHeadEnd", NL, new Object[0]));
        this.print(this.format("outcomesTableBodyStart", EMPTY, new Object[0]));
        for (OutcomesTable.Outcome outcome : rows) {
            this.print(this.format("outcomesTableRowStart", "|", outcome.isVerified() ? "verified" : "notVerified"));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getDescription()));
            this.print(this.format("outcomesTableCell", "{0}|", this.renderOutcomeValue(outcome.getValue(), table.getDateFormat())));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.getMatcher()));
            this.print(this.format("outcomesTableCell", "{0}|", outcome.isVerified() ? this.keywords.yes() : this.keywords.no()));
            this.print(this.format("outcomesTableRowEnd", NL, new Object[0]));
        }
        this.print(this.format("outcomesTableBodyEnd", NL, new Object[0]));
        this.print(this.format("outcomesTableEnd", NL, new Object[0]));
    }

    private Object renderOutcomeValue(Object value, String dateFormat) {
        if (value instanceof Date) {
            return new SimpleDateFormat(dateFormat).format(value);
        }
        return value;
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        this.print(this.format("filter", "{0}\n", filter));
    }

    @Override
    public void storyCancelled(Story story, StoryDuration storyDuration) {
        this.print(this.format("storyCancelled", "{0}: {1} ({2} s)\n", this.keywords.storyCancelled(), this.keywords.duration(), storyDuration.getDurationInSecs()));
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.print(this.format("beforeStory", "{0}\n({1})\n", story.getDescription().asString(), story.getPath()));
        if (this.dryRun.get().booleanValue()) {
            this.print(this.format("dryRun", "{0}\n", this.keywords.dryRun()));
        }
        this.print(story.getMeta());
    }

    @Override
    public void narrative(Narrative narrative) {
        if (!narrative.isEmpty()) {
            if (!narrative.isAlternative()) {
                this.print(this.format("narrative", "{0}\n{1} {2}\n{3} {4}\n{5} {6}\n", this.keywords.narrative(), this.keywords.inOrderTo(), narrative.inOrderTo(), this.keywords.asA(), narrative.asA(), this.keywords.iWantTo(), narrative.iWantTo()));
            } else {
                this.print(this.format("narrative", "{0}\n{1} {2}\n{3} {4}\n{5} {6}\n", this.keywords.narrative(), this.keywords.asA(), narrative.asA(), this.keywords.iWantTo(), narrative.iWantTo(), this.keywords.soThat(), narrative.soThat()));
            }
        }
    }

    @Override
    public void lifecyle(Lifecycle lifecycle) {
        if (!lifecycle.isEmpty()) {
            this.print(this.format("lifecycleStart", "{0}\n", this.keywords.lifecycle()));
            if (lifecycle.hasBeforeSteps()) {
                this.print(this.format("lifecycleBeforeStart", "{0}\n", this.keywords.before()));
                for (Scope scope : lifecycle.getScopes()) {
                    this.printWithScope(lifecycle.getBeforeSteps(scope), scope);
                }
                this.print(this.format("lifecycleBeforeEnd", NL, new Object[0]));
            }
            if (lifecycle.hasAfterSteps()) {
                this.print(this.format("lifecycleAfterStart", "{0}\n", this.keywords.after()));
                for (Scope scope : lifecycle.getScopes()) {
                    this.printOutcomes(lifecycle, scope);
                }
                this.print(this.format("lifecycleAfterEnd", NL, new Object[0]));
            }
            this.print(this.format("lifecycleEnd", NL, new Object[0]));
        }
    }

    private void printOutcomes(Lifecycle lifecycle, Scope scope) {
        for (AfterScenario.Outcome outcome : lifecycle.getOutcomes()) {
            List<String> afterSteps = lifecycle.getAfterSteps(scope, outcome);
            if (afterSteps.isEmpty()) continue;
            this.print(this.format("lifecycleAfterScopeStart", "{0} {1}\n", this.keywords.scope(), this.formatScope(scope)));
            this.print(this.format("lifecycleOutcomeStart", "{0} {1}\n", this.keywords.outcome(), this.formatOutcome(outcome)));
            MetaFilter metaFilter = lifecycle.getMetaFilter(outcome);
            if (!metaFilter.isEmpty()) {
                this.print(this.format("lifecycleMetaFilter", "{0} {1}\n", this.keywords.metaFilter(), metaFilter.asString()));
            }
            this.print(afterSteps);
            this.print(this.format("lifecycleOutcomeEnd", NL, new Object[0]));
            this.print(this.format("lifecycleAfterScopeEnd", NL, new Object[0]));
        }
    }

    private void printWithScope(List<String> steps, Scope scope) {
        if (!steps.isEmpty()) {
            this.print(this.format("lifecycleBeforeScopeStart", "{0} {1}\n", this.keywords.scope(), this.formatScope(scope)));
            this.print(steps);
            this.print(this.format("lifecycleBeforeScopeEnd", NL, new Object[0]));
        }
    }

    private String formatScope(Scope scope) {
        switch (scope) {
            case SCENARIO: {
                return this.keywords.scopeScenario();
            }
            case STORY: {
                return this.keywords.scopeStory();
            }
        }
        return scope.name();
    }

    private String formatOutcome(AfterScenario.Outcome outcome) {
        switch (outcome) {
            case ANY: {
                return this.keywords.outcomeAny();
            }
            case SUCCESS: {
                return this.keywords.outcomeSuccess();
            }
            case FAILURE: {
                return this.keywords.outcomeFailure();
            }
        }
        return outcome.name();
    }

    private void print(List<String> steps) {
        for (String step : steps) {
            this.print(this.format("lifecycleStep", "{0}\n", step));
        }
    }

    private void print(Meta meta) {
        if (!meta.isEmpty()) {
            this.print(this.format("metaStart", "{0}\n", this.keywords.meta()));
            for (String name : meta.getPropertyNames()) {
                this.print(this.format("metaProperty", "{0}{1} {2}", this.keywords.metaProperty(), name, meta.getProperty(name)));
            }
            this.print(this.format("metaEnd", NL, new Object[0]));
        }
    }

    @Override
    public void beforeStorySteps(StepCollector.Stage stage) {
        this.printStorySteps("before", stage);
    }

    @Override
    public void afterStorySteps(StepCollector.Stage stage) {
        this.printStorySteps("after", stage);
    }

    private void printStorySteps(String stepsStage, StepCollector.Stage storyStage) {
        String storyStageName = CaseUtils.toCamelCase((String)storyStage.name(), (boolean)true, (char[])new char[0]);
        this.print(this.format(stepsStage + storyStageName + "StorySteps", EMPTY, new Object[0]));
    }

    @Override
    public void afterStory(boolean givenOrRestartingStory) {
        this.print(this.format("afterStory", NL, new Object[0]));
        if (!givenOrRestartingStory && this.output != System.out) {
            this.output.close();
        }
    }

    @Override
    public void beforeGivenStories() {
        this.print(this.format("beforeGivenStories", EMPTY, new Object[0]));
    }

    @Override
    public void givenStories(GivenStories givenStories) {
        this.print(this.format("givenStoriesStart", "{0}\n", this.keywords.givenStories()));
        for (GivenStory givenStory : givenStories.getStories()) {
            this.print(this.format("givenStory", "{0}{1}\n", givenStory.asString(), givenStory.hasAnchor() ? givenStory.getParameters() : EMPTY));
        }
        this.print(this.format("givenStoriesEnd", NL, new Object[0]));
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.givenStories(new GivenStories(StringUtils.join(storyPaths, (String)",")));
    }

    @Override
    public void afterGivenStories() {
        this.print(this.format("afterGivenStories", EMPTY, new Object[0]));
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        this.print(this.format("filter", "{0}\n", filter));
    }

    @Override
    public void beforeScenario(Scenario scenario) {
        this.cause.set(null);
        this.print(this.format("beforeScenario", "{0} {1}\n", this.keywords.scenario(), scenario.getTitle()));
        this.print(scenario.getMeta());
    }

    @Override
    public void afterScenario() {
        if (this.cause.get() != null && !(this.cause.get() instanceof KnownFailure) && this.reportFailureTrace()) {
            this.print(this.format("afterScenarioWithFailure", "\n{0}\n", new StackTraceFormatter(this.compressFailureTrace()).stackTrace(this.cause.get())));
        } else {
            this.print(this.format("afterScenario", NL, new Object[0]));
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.print(this.format("beforeExamples", "{0}\n", this.keywords.examplesTable()));
        this.print(this.format("examplesStepsStart", EMPTY, new Object[0]));
        for (String step : steps) {
            this.print(this.format("examplesStep", "{0}\n", step));
        }
        this.print(this.format("examplesStepsEnd", EMPTY, new Object[0]));
        this.print(this.formatTable(table));
    }

    @Override
    public void example(Map<String, String> tableRow, int exampleIndex) {
        this.print(this.format("example", "\n{0} {1}\n", this.keywords.examplesTableRow(), tableRow));
    }

    @Override
    public void afterExamples() {
        this.print(this.format("afterExamples", NL, new Object[0]));
    }

    @Override
    public void dryRun() {
        this.dryRun.set(true);
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.print(this.format("pendingMethodsStart", EMPTY, new Object[0]));
        for (String method : methods) {
            this.print(this.format("pendingMethod", "{0}\n", method));
        }
        this.print(this.format("pendingMethodsEnd", EMPTY, new Object[0]));
    }

    @Override
    public void restarted(String step, Throwable cause) {
        this.print(this.format("restarted", "{0} {1}\n", step, cause.getMessage()));
    }

    @Override
    public void restartedStory(Story story, Throwable cause) {
        this.print(this.format("restartedStory", "{0} {1}\n", story.getPath(), cause.getMessage()));
    }

    protected String format(String key, String defaultPattern, Object ... args) {
        String escape = this.escape(defaultPattern);
        String s = this.lookupPattern(key, escape);
        Object[] objects = this.escapeAll(args);
        return MessageFormat.format(s, objects);
    }

    protected String formatTable(ExamplesTable table) {
        ByteArrayOutputStream formatted = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(formatted);
        this.print(out, this.format("examplesTableStart", NL, new Object[0]));
        List<Map<String, String>> rows = table.getRows();
        List<String> headers = table.getHeaders();
        this.print(out, this.format("examplesTableHeadStart", "|", new Object[0]));
        for (String string : headers) {
            this.print(out, this.format("examplesTableHeadCell", "{0}|", string));
        }
        this.print(out, this.format("examplesTableHeadEnd", NL, new Object[0]));
        this.print(out, this.format("examplesTableBodyStart", EMPTY, new Object[0]));
        for (Map map : rows) {
            this.print(out, this.format("examplesTableRowStart", "|", new Object[0]));
            for (String header : headers) {
                this.print(out, this.format("examplesTableCell", "{0}|", map.get(header)));
            }
            this.print(out, this.format("examplesTableRowEnd", NL, new Object[0]));
        }
        this.print(out, this.format("examplesTableBodyEnd", EMPTY, new Object[0]));
        this.print(out, this.format("examplesTableEnd", EMPTY, new Object[0]));
        return ((Object)formatted).toString();
    }

    protected String formatVerbatim(Verbatim verbatim) {
        ByteArrayOutputStream formatted = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(formatted);
        this.print(out, this.format("verbatimStart", NL, new Object[0]));
        this.print(out, verbatim.getContent());
        this.print(out, this.format("verbatimEnd", NL, new Object[0]));
        return ((Object)formatted).toString();
    }

    private String escape(String defaultPattern) {
        return (String)this.escapeAll(defaultPattern)[0];
    }

    private Object[] escapeAll(Object ... args) {
        return this.escape(this.format, args);
    }

    protected Object[] escape(Format format, Object ... args) {
        return Stream.of(args).map(format::escapeValue).toArray();
    }

    protected String lookupPattern(String key, String defaultPattern) {
        if (this.outputPatterns.containsKey(key)) {
            return this.outputPatterns.getProperty(key);
        }
        return defaultPattern;
    }

    public boolean reportFailureTrace() {
        Boolean reportFailure = this.reportFailureTrace.get();
        if (reportFailure != null) {
            return reportFailure;
        }
        return false;
    }

    public PrintStreamOutput doReportFailureTrace(boolean reportFailureTrace) {
        this.reportFailureTrace.set(reportFailureTrace);
        return this;
    }

    public boolean compressFailureTrace() {
        return this.compressFailureTrace.get();
    }

    public PrintStreamOutput doCompressFailureTrace(boolean compressFailureTrace) {
        this.compressFailureTrace.set(compressFailureTrace);
        return this;
    }

    protected void overwritePattern(String key, String pattern) {
        this.outputPatterns.put(key, pattern);
    }

    protected void print(String text) {
        boolean containsVerbatim;
        String tableStart = this.format("\uff3b", "\uff3b", new Object[0]);
        String tableEnd = this.format("\uff3d", "\uff3d", new Object[0]);
        boolean containsTable = text.contains(tableStart) && text.contains(tableEnd);
        String verbatimStart = this.format("\u301a", "\u301a", new Object[0]);
        String verbatimEnd = this.format("\u301b", "\u301b", new Object[0]);
        boolean bl = containsVerbatim = text.contains(verbatimStart) && text.contains(verbatimEnd);
        String textToPrint = containsTable ? this.transformPrintingTable(text, tableStart, tableEnd) : (containsVerbatim ? this.transformPrintingVerbatim(text, verbatimStart, verbatimEnd) : text);
        this.print(this.output, textToPrint.replace(this.format("\uff5f", "\uff5f", new Object[0]), this.format("parameterValueStart", EMPTY, new Object[0])).replace(this.format("\uff60", "\uff60", new Object[0]), this.format("parameterValueEnd", EMPTY, new Object[0])).replace(this.format("\u2424", "\u2424", new Object[0]), this.format("parameterValueNewline", NL, new Object[0])));
    }

    protected String transformPrintingTable(String text, String tableStart, String tableEnd) {
        String tableAsString = StringUtils.substringBetween((String)text, (String)tableStart, (String)tableEnd);
        return text.replace(tableAsString, this.formatTable(new ExamplesTable(tableAsString))).replace(tableStart, this.format("parameterValueStart", EMPTY, new Object[0])).replace(tableEnd, this.format("parameterValueEnd", EMPTY, new Object[0]));
    }

    protected String transformPrintingVerbatim(String text, String verbatimStart, String verbatimEnd) {
        String verbatimAsString = StringUtils.substringBetween((String)text, (String)verbatimStart, (String)verbatimEnd);
        return text.replace(verbatimAsString, this.formatVerbatim(new Verbatim(verbatimAsString))).replace(verbatimStart, this.format("parameterValueStart", EMPTY, new Object[0])).replace(verbatimEnd, this.format("parameterValueEnd", EMPTY, new Object[0]));
    }

    protected void print(PrintStream output, String text) {
        output.print(text);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.format).append((Object)this.output).toString();
    }

    public static enum Format {
        TXT{

            @Override
            public Object escapeValue(Object object) {
                return object;
            }
        }
        ,
        HTML{

            @Override
            public Object escapeValue(Object object) {
                return EscapeMode.HTML.escapeString(Format.asString(object));
            }
        }
        ,
        XML{

            @Override
            public Object escapeValue(Object object) {
                return EscapeMode.XML.escapeString(Format.asString(object));
            }
        }
        ,
        JSON{

            @Override
            public Object escapeValue(Object object) {
                return EscapeMode.JSON.escapeString(Format.asString(object));
            }
        };


        public abstract Object escapeValue(Object var1);

        private static String asString(Object object) {
            return object != null ? object.toString() : PrintStreamOutput.EMPTY;
        }
    }
}

