/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;

public class Scenario {
    private final String title;
    private final Meta meta;
    private final GivenStories givenStories;
    private final ExamplesTable examplesTable;
    private final List<String> steps;

    public Scenario() {
        this(Arrays.asList(new String[0]));
    }

    public Scenario(List<String> steps) {
        this(null, steps);
    }

    public Scenario(String title, Meta meta) {
        this(title, meta, null, null, Arrays.asList(new String[0]));
    }

    public Scenario(String title, List<String> steps) {
        this(title, null, null, null, steps);
    }

    public Scenario(String title, Meta meta, GivenStories givenStories, ExamplesTable examplesTable, List<String> steps) {
        this.title = title;
        this.meta = meta;
        this.givenStories = givenStories;
        this.examplesTable = examplesTable;
        this.steps = steps;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public boolean hasGivenStories() {
        return this.givenStories != null;
    }

    public GivenStories getGivenStories() {
        if (!this.hasGivenStories()) {
            return GivenStories.EMPTY;
        }
        return this.givenStories;
    }

    public boolean hasExamplesTable() {
        return this.examplesTable != null;
    }

    public ExamplesTable getExamplesTable() {
        if (!this.hasExamplesTable()) {
            return ExamplesTable.EMPTY;
        }
        return this.examplesTable;
    }

    public boolean hasMeta() {
        return this.meta != null;
    }

    public Meta getMeta() {
        if (!this.hasMeta()) {
            return Meta.EMPTY;
        }
        return this.meta;
    }

    public Meta asMeta(String prefix) {
        Properties p = new Properties();
        p.setProperty(prefix + "title", this.getTitle());
        p.setProperty(prefix + "givenStories", this.getGivenStories().asString());
        p.setProperty(prefix + "examplesTable", this.getExamplesTable().asString());
        return new Meta(p);
    }

    public List<String> getSteps() {
        return this.getSteps(true);
    }

    public List<String> getSteps(boolean trim) {
        return trim ? this.trim(this.steps) : this.steps;
    }

    private List<String> trim(List<String> steps) {
        return steps.stream().map(String::trim).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

