/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.embedder.StoryTimeouts;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector;

public class StoryManager {
    private final Configuration configuration;
    private final EmbedderControls embedderControls;
    private final EmbedderMonitor embedderMonitor;
    private final ExecutorService executorService;
    private final InjectableStepsFactory stepsFactory;
    private final PerformableTree performableTree;
    private final Map<String, RunningStory> runningStories = new HashMap<String, RunningStory>();
    private final Map<MetaFilter, List<Story>> excludedStories = new HashMap<MetaFilter, List<Story>>();
    private PerformableTree.RunContext context;
    private StoryTimeouts timeouts;

    public StoryManager(Configuration configuration, InjectableStepsFactory stepsFactory, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, ExecutorService executorService, PerformableTree performableTree, StoryTimeouts.TimeoutParser ... parsers) {
        this.configuration = configuration;
        this.embedderControls = embedderControls;
        this.embedderMonitor = embedderMonitor;
        this.executorService = executorService;
        this.stepsFactory = stepsFactory;
        this.performableTree = performableTree;
        this.timeouts = new StoryTimeouts(embedderControls, embedderMonitor);
        this.timeouts.withParsers(parsers);
    }

    public Story storyOfPath(String storyPath) {
        return this.performableTree.storyOfPath(this.configuration, storyPath);
    }

    public List<Story> storiesOfPaths(List<String> storyPaths) {
        ArrayList<Story> stories = new ArrayList<Story>(storyPaths.size());
        for (String storyPath : storyPaths) {
            stories.add(this.storyOfPath(storyPath));
        }
        return stories;
    }

    public Story storyOfText(String storyAsText, String storyId) {
        return this.performableTree.storyOfText(this.configuration, storyAsText, storyId);
    }

    public void clear() {
        this.runningStories.clear();
    }

    public PerformableTree.PerformableRoot performableRoot() {
        return this.performableTree.getRoot();
    }

    public List<StoryOutcome> outcomes() {
        ArrayList<StoryOutcome> outcomes = new ArrayList<StoryOutcome>();
        for (RunningStory story : this.runningStories.values()) {
            outcomes.add(new StoryOutcome(story));
        }
        return outcomes;
    }

    public void runStoriesAsPaths(List<String> storyPaths, MetaFilter filter, BatchFailures failures) {
        this.runStories(this.storiesOfPaths(storyPaths), filter, failures);
    }

    public void runStories(List<Story> stories, MetaFilter filter, BatchFailures failures) {
        this.context = this.performableTree.newRunContext(this.configuration, this.stepsFactory.createCandidateSteps(), this.embedderMonitor, filter, failures);
        this.performableTree.addStories(this.context, stories);
        this.performStories(this.context, this.performableTree, stories);
        failures.putAll(this.context.getFailures());
    }

    private void performStories(PerformableTree.RunContext context, PerformableTree performableTree, List<Story> stories) {
        performableTree.performBeforeOrAfterStories(context, StepCollector.Stage.BEFORE);
        this.runningStories(context, stories);
        this.waitUntilAllDoneOrFailed(context);
        MetaFilter filter = context.filter();
        List<Story> notAllowed = this.notAllowedBy(filter);
        if (!notAllowed.isEmpty()) {
            this.embedderMonitor.storiesNotAllowed(notAllowed, filter, this.embedderControls.verboseFiltering());
        }
        performableTree.performBeforeOrAfterStories(context, StepCollector.Stage.AFTER);
    }

    public Map<String, RunningStory> runningStories(PerformableTree.RunContext context, List<Story> stories) {
        for (Story story : stories) {
            this.filterRunning(context, story);
        }
        return this.runningStories;
    }

    private void filterRunning(PerformableTree.RunContext context, Story story) {
        FilteredStory filteredStory = context.filter(story);
        if (filteredStory.allowed()) {
            this.runningStories.put(story.getPath(), this.runningStory(story));
        } else {
            this.notAllowedBy(context.getFilter()).add(story);
        }
    }

    public List<Story> notAllowedBy(MetaFilter filter) {
        List<Story> stories = this.excludedStories.get(filter);
        if (stories == null) {
            stories = new ArrayList<Story>();
            this.excludedStories.put(filter, stories);
        }
        return stories;
    }

    public RunningStory runningStory(Story story) {
        return this.submit(new EnqueuedStory(this.performableTree, this.context, this.embedderControls, this.embedderMonitor, story, this.timeouts));
    }

    public void waitUntilAllDoneOrFailed(PerformableTree.RunContext context) {
        if (this.runningStories.values().isEmpty()) {
            return;
        }
        boolean allDone = false;
        boolean started = false;
        while (!allDone || !started) {
            allDone = true;
            for (RunningStory runningStory : this.runningStories.values()) {
                if (runningStory.isStarted()) {
                    started = true;
                    Story story = runningStory.getStory();
                    Future<ThrowableStory> future = runningStory.getFuture();
                    if (!future.isDone()) {
                        allDone = false;
                        StoryDuration duration = runningStory.getDuration();
                        runningStory.updateDuration();
                        if (!duration.timedOut()) continue;
                        this.embedderMonitor.storyTimeout(story, duration);
                        context.cancelStory(story, duration);
                        future.cancel(true);
                        if (!this.embedderControls.failOnStoryTimeout()) continue;
                        throw new StoryExecutionFailed(story.getPath(), new StoryTimedOut(duration));
                    }
                    try {
                        ThrowableStory throwableStory = future.get();
                        Throwable throwable = throwableStory.getThrowable();
                        if (throwable == null) continue;
                        context.addFailure(story, throwable);
                        if (this.embedderControls.ignoreFailureInStories()) continue;
                    }
                    catch (Throwable e) {
                        context.addFailure(story, e);
                        if (this.embedderControls.ignoreFailureInStories()) continue;
                    }
                    continue;
                }
                started = false;
                allDone = false;
            }
            this.tickTock();
        }
        this.writeStoryDurations(this.runningStories.values());
    }

    protected void writeStoryDurations(Collection<RunningStory> runningStories) {
        Properties storyDurations = new Properties();
        long total = 0L;
        for (RunningStory runningStory : runningStories) {
            long durationInMillis = runningStory.getDurationInMillis();
            total += durationInMillis;
            storyDurations.setProperty(runningStory.getStory().getPath(), Long.toString(durationInMillis));
            Future<ThrowableStory> future = runningStory.getFuture();
            if (future.isDone()) continue;
            future.cancel(true);
        }
        int threads = this.embedderControls.threads();
        long threadAverage = total / (long)threads;
        storyDurations.setProperty("total", Long.toString(total));
        storyDurations.setProperty("threads", Long.toString(threads));
        storyDurations.setProperty("threadAverage", Long.toString(threadAverage));
        this.write(storyDurations, "storyDurations.props");
    }

    private void write(Properties p, String name) {
        File outputDirectory = this.configuration.storyReporterBuilder().outputDirectory();
        try {
            outputDirectory.mkdirs();
            FileWriter output = new FileWriter(new File(outputDirectory, name));
            p.store(output, this.getClass().getName());
            ((Writer)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void tickTock() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized RunningStory submit(EnqueuedStory enqueuedStory) {
        return new RunningStory(enqueuedStory, this.executorService.submit(enqueuedStory));
    }

    public static class StoryOutcome {
        private String path;
        private Boolean done;
        private Boolean failed;

        public StoryOutcome(RunningStory story) {
            this.path = story.getStory().getPath();
            this.done = story.isDone();
            this.failed = story.isFailed();
        }

        public String getPath() {
            return this.path;
        }

        public Boolean isDone() {
            return this.done;
        }

        public Boolean isFailed() {
            return this.failed;
        }
    }

    public static class RunningStory {
        private EnqueuedStory enqueuedStory;
        private Future<ThrowableStory> future;
        private StoryDuration duration;

        public RunningStory(EnqueuedStory enqueuedStory, Future<ThrowableStory> future) {
            this.enqueuedStory = enqueuedStory;
            this.future = future;
        }

        public Future<ThrowableStory> getFuture() {
            return this.future;
        }

        public Story getStory() {
            return this.enqueuedStory.getStory();
        }

        public long getDurationInMillis() {
            if (this.duration == null) {
                return 0L;
            }
            return this.duration.getDurationInSecs() * 1000L;
        }

        public StoryDuration getDuration() {
            if (this.duration == null) {
                this.duration = new StoryDuration(this.enqueuedStory.getStartedAtMillis(), this.enqueuedStory.getTimeoutInSecs());
            }
            return this.duration;
        }

        public void updateDuration() {
            this.duration.update();
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public boolean isFailed() {
            if (this.isDone()) {
                try {
                    return this.future.get().getThrowable() != null;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean isStarted() {
            return this.enqueuedStory.getStartedAtMillis() != 0L;
        }
    }

    public static class ThrowableStory {
        private Story story;
        private Throwable throwable;

        public ThrowableStory(Story story, Throwable throwable) {
            this.story = story;
            this.throwable = throwable;
        }

        public Story getStory() {
            return this.story;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class StoryTimedOut
    extends RuntimeException {
        public StoryTimedOut(StoryDuration storyDuration) {
            super(storyDuration.getDurationInSecs() + "s > " + storyDuration.getTimeoutInSecs() + "s");
        }
    }

    public static class StoryExecutionFailed
    extends RuntimeException {
        public StoryExecutionFailed(String storyPath, Throwable failure) {
            super(storyPath, failure);
        }
    }

    static class EnqueuedStory
    implements Callable<ThrowableStory> {
        private final PerformableTree performableTree;
        private final PerformableTree.RunContext context;
        private final EmbedderControls embedderControls;
        private final EmbedderMonitor embedderMonitor;
        private final Story story;
        private final StoryTimeouts timeouts;
        private long startedAtMillis;

        public EnqueuedStory(PerformableTree performableTree, PerformableTree.RunContext context, EmbedderControls embedderControls, EmbedderMonitor embedderMonitor, Story story, StoryTimeouts timeouts) {
            this.performableTree = performableTree;
            this.context = context;
            this.embedderControls = embedderControls;
            this.embedderMonitor = embedderMonitor;
            this.story = story;
            this.timeouts = timeouts;
        }

        @Override
        public ThrowableStory call() {
            this.startedAtMillis = System.currentTimeMillis();
            String storyPath = this.story.getPath();
            try {
                this.embedderMonitor.runningStory(storyPath);
                this.performableTree.perform(this.context, this.story);
            }
            catch (Throwable e) {
                if (this.embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(storyPath, e);
                }
                return new ThrowableStory(this.story, new StoryExecutionFailed(storyPath, e));
            }
            return new ThrowableStory(this.story, null);
        }

        public Story getStory() {
            return this.story;
        }

        public long getStartedAtMillis() {
            return this.startedAtMillis;
        }

        public long getTimeoutInSecs() {
            return this.timeouts.getTimeoutInSecs(this.story);
        }
    }
}

