/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.util.Collections;
import java.util.Set;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.StoryControls;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PassingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.RethrowingFailure;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.AbsolutePathCalculator;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.PathCalculator;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.io.UnderscoredCamelCaseResolver;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.TableParsers;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.parsers.CompositeParser;
import org.jbehave.core.parsers.RegexCompositeParser;
import org.jbehave.core.parsers.RegexPrefixCapturingPatternParser;
import org.jbehave.core.parsers.RegexStoryParser;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.PrintStreamStepdocReporter;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.MarkUnmatchedStepsAsPending;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.context.StepsContext;

public abstract class Configuration {
    protected StoryControls storyControls;
    protected Keywords keywords;
    protected StepCollector stepCollector;
    protected StoryParser storyParser;
    protected CompositeParser compositeParser;
    protected StoryLoader storyLoader;
    protected StoryPathResolver storyPathResolver;
    protected FailureStrategy failureStrategy;
    protected PendingStepStrategy pendingStepStrategy;
    protected StoryReporter defaultStoryReporter;
    protected StoryReporterBuilder storyReporterBuilder;
    protected StepsContext stepsContext;
    protected StepFinder stepFinder;
    protected StepdocReporter stepdocReporter;
    protected StepPatternParser stepPatternParser;
    protected ParameterControls parameterControls;
    protected StepMonitor stepMonitor;
    protected Paranamer paranamer;
    protected ParameterConverters parameterConverters;
    protected TableParsers tableParsers;
    protected TableTransformers tableTransformers;
    protected ViewGenerator viewGenerator;
    protected PathCalculator pathCalculator;
    protected Set<String> compositePaths;
    protected ExamplesTableFactory examplesTableFactory;

    public Keywords keywords() {
        if (this.keywords == null) {
            this.keywords = new LocalizedKeywords();
        }
        return this.keywords;
    }

    public boolean dryRun() {
        return this.storyControls().dryRun();
    }

    public StoryControls storyControls() {
        if (this.storyControls == null) {
            this.storyControls = new StoryControls();
        }
        return this.storyControls;
    }

    public StoryParser storyParser() {
        if (this.storyParser == null) {
            this.storyParser = new RegexStoryParser(this.keywords(), this.examplesTableFactory());
        }
        return this.storyParser;
    }

    public CompositeParser compositeParser() {
        if (this.compositeParser == null) {
            this.compositeParser = new RegexCompositeParser(this.keywords());
        }
        return this.compositeParser;
    }

    public StoryLoader storyLoader() {
        if (this.storyLoader == null) {
            this.storyLoader = new LoadFromClasspath();
        }
        return this.storyLoader;
    }

    public ExamplesTableFactory examplesTableFactory() {
        if (this.examplesTableFactory == null) {
            this.examplesTableFactory = new ExamplesTableFactory(this.keywords(), this.storyLoader(), this.parameterConverters(), this.parameterControls(), this.tableParsers(), this.tableTransformers());
        }
        return this.examplesTableFactory;
    }

    public StoryPathResolver storyPathResolver() {
        if (this.storyPathResolver == null) {
            this.storyPathResolver = new UnderscoredCamelCaseResolver();
        }
        return this.storyPathResolver;
    }

    public FailureStrategy failureStrategy() {
        if (this.failureStrategy == null) {
            this.failureStrategy = new RethrowingFailure();
        }
        return this.failureStrategy;
    }

    public PendingStepStrategy pendingStepStrategy() {
        if (this.pendingStepStrategy == null) {
            this.pendingStepStrategy = new PassingUponPendingStep();
        }
        return this.pendingStepStrategy;
    }

    @Deprecated
    public StoryReporter defaultStoryReporter() {
        if (this.defaultStoryReporter == null) {
            this.defaultStoryReporter = new ConsoleOutput();
        }
        return this.defaultStoryReporter;
    }

    public StoryReporter storyReporter(String storyPath) {
        return this.storyReporterBuilder().build(storyPath);
    }

    public StoryReporterBuilder storyReporterBuilder() {
        if (this.storyReporterBuilder == null) {
            this.storyReporterBuilder = new StoryReporterBuilder();
        }
        return this.storyReporterBuilder;
    }

    public StepsContext stepsContext() {
        if (this.stepsContext == null) {
            this.stepsContext = new StepsContext();
        }
        return this.stepsContext;
    }

    public StepCollector stepCollector() {
        if (this.stepCollector == null) {
            this.stepCollector = new MarkUnmatchedStepsAsPending(this.stepFinder(), this.keywords());
        }
        return this.stepCollector;
    }

    public StepFinder stepFinder() {
        if (this.stepFinder == null) {
            this.stepFinder = new StepFinder();
        }
        return this.stepFinder;
    }

    public StepdocReporter stepdocReporter() {
        if (this.stepdocReporter == null) {
            this.stepdocReporter = new PrintStreamStepdocReporter();
        }
        return this.stepdocReporter;
    }

    public StepPatternParser stepPatternParser() {
        if (this.stepPatternParser == null) {
            this.stepPatternParser = new RegexPrefixCapturingPatternParser();
        }
        return this.stepPatternParser;
    }

    public ParameterControls parameterControls() {
        if (this.parameterControls == null) {
            this.parameterControls = new ParameterControls();
        }
        return this.parameterControls;
    }

    public StepMonitor stepMonitor() {
        if (this.stepMonitor == null) {
            this.stepMonitor = new SilentStepMonitor();
        }
        return this.stepMonitor;
    }

    public Paranamer paranamer() {
        if (this.paranamer == null) {
            this.paranamer = new NullParanamer();
        }
        return this.paranamer;
    }

    public ParameterConverters parameterConverters() {
        if (this.parameterConverters == null) {
            this.parameterConverters = new ParameterConverters(this.stepMonitor(), this.keywords(), this.storyLoader(), this.parameterControls(), this.tableTransformers());
        }
        return this.parameterConverters;
    }

    public TableParsers tableParsers() {
        if (this.tableParsers == null) {
            this.tableParsers = new TableParsers();
        }
        return this.tableParsers;
    }

    public TableTransformers tableTransformers() {
        if (this.tableTransformers == null) {
            this.tableTransformers = new TableTransformers();
        }
        return this.tableTransformers;
    }

    public ViewGenerator viewGenerator() {
        if (this.viewGenerator == null) {
            this.viewGenerator = new FreemarkerViewGenerator();
        }
        return this.viewGenerator;
    }

    public PathCalculator pathCalculator() {
        if (this.pathCalculator == null) {
            this.pathCalculator = new AbsolutePathCalculator();
        }
        return this.pathCalculator;
    }

    public Set<String> compositePaths() {
        if (this.compositePaths == null) {
            this.compositePaths = Collections.emptySet();
        }
        return this.compositePaths;
    }

    public Configuration useKeywords(Keywords keywords) {
        this.keywords = keywords;
        return this;
    }

    public Configuration doDryRun(Boolean dryRun) {
        this.storyControls().doDryRun(dryRun);
        return this;
    }

    public Configuration useStoryControls(StoryControls storyControls) {
        this.storyControls = storyControls;
        return this;
    }

    public Configuration usePendingStepStrategy(PendingStepStrategy pendingStepStrategy) {
        this.pendingStepStrategy = pendingStepStrategy;
        return this;
    }

    public Configuration useFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
        return this;
    }

    public Configuration useStoryParser(StoryParser storyParser) {
        this.storyParser = storyParser;
        return this;
    }

    public Configuration useCompositeParser(CompositeParser compositeParser) {
        this.compositeParser = compositeParser;
        return this;
    }

    public Configuration useStoryLoader(StoryLoader storyLoader) {
        this.storyLoader = storyLoader;
        return this;
    }

    public Configuration useExamplesTableFactory(ExamplesTableFactory examplesTableFactory) {
        this.examplesTableFactory = examplesTableFactory;
        return this;
    }

    public Configuration useStoryPathResolver(StoryPathResolver storyPathResolver) {
        this.storyPathResolver = storyPathResolver;
        return this;
    }

    public Configuration useDefaultStoryReporter(StoryReporter storyReporter) {
        this.defaultStoryReporter = storyReporter;
        return this;
    }

    public Configuration useStoryReporterBuilder(StoryReporterBuilder storyReporterBuilder) {
        this.storyReporterBuilder = storyReporterBuilder;
        return this;
    }

    public Configuration useStepCollector(StepCollector stepCollector) {
        this.stepCollector = stepCollector;
        return this;
    }

    public Configuration useStepFinder(StepFinder stepFinder) {
        this.stepFinder = stepFinder;
        return this;
    }

    public Configuration useStepdocReporter(StepdocReporter stepdocReporter) {
        this.stepdocReporter = stepdocReporter;
        return this;
    }

    public Configuration useStepPatternParser(StepPatternParser stepPatternParser) {
        this.stepPatternParser = stepPatternParser;
        return this;
    }

    public Configuration useParameterControls(ParameterControls parameterControls) {
        this.parameterControls = parameterControls;
        return this;
    }

    public Configuration useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        return this;
    }

    public Configuration useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
        return this;
    }

    public Configuration useParameterConverters(ParameterConverters parameterConverters) {
        this.parameterConverters = parameterConverters;
        return this;
    }

    public Configuration useTableTransformers(TableTransformers tableTransformers) {
        this.tableTransformers = tableTransformers;
        return this;
    }

    public Configuration useViewGenerator(ViewGenerator viewGenerator) {
        this.viewGenerator = viewGenerator;
        return this;
    }

    public Configuration usePathCalculator(PathCalculator pathCalculator) {
        this.pathCalculator = pathCalculator;
        return this;
    }

    public Configuration useCompositePaths(Set<String> compositePaths) {
        this.compositePaths = compositePaths;
        return this;
    }

    public Configuration useStepsContext(StepsContext stepsContext) {
        this.stepsContext = stepsContext;
        return this;
    }
}

